/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.coinbase.api.v3.domain.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.Side;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.StopDirection;
import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OrderConfiguration {
    @JsonProperty(value="sor_limit_ioc")
    private SorLimitIoc sorLimitIoc;
    @JsonProperty(value="market_market_ioc")
    private MarketMarketIoc marketMarketIoc;
    @JsonProperty(value="limit_limit_gtc")
    private LimitLimitGtc limitLimitGtc;
    @JsonProperty(value="limit_limit_gtd")
    private LimitLimitGtd limitLimitGtd;
    @JsonProperty(value="limit_limit_fok")
    private LimitLimitFok limitLimitFok;
    @JsonProperty(value="stop_limit_stop_limit_gtc")
    private StopLimitStopLimitGtc stopLimitStopLimitGtc;
    @JsonProperty(value="stop_limit_stop_limit_gtd")
    private StopLimitStopLimitGtd stopLimitStopLimitGtd;
    @JsonProperty(value="trigger_bracket_gtd")
    private TriggerBracketGtd triggerBracketGtd;
    @JsonProperty(value="trigger_bracket_gtc")
    private TriggerBracketGtc triggerBracketGtc;

    public static OrderConfigurationBuilder builder(Side side, BigDecimal quantity) {
        return new OrderConfigurationBuilder(side, quantity);
    }

    public SorLimitIoc getSorLimitIoc() {
        return this.sorLimitIoc;
    }

    public MarketMarketIoc getMarketMarketIoc() {
        return this.marketMarketIoc;
    }

    public LimitLimitGtc getLimitLimitGtc() {
        return this.limitLimitGtc;
    }

    public LimitLimitGtd getLimitLimitGtd() {
        return this.limitLimitGtd;
    }

    public LimitLimitFok getLimitLimitFok() {
        return this.limitLimitFok;
    }

    public StopLimitStopLimitGtc getStopLimitStopLimitGtc() {
        return this.stopLimitStopLimitGtc;
    }

    public StopLimitStopLimitGtd getStopLimitStopLimitGtd() {
        return this.stopLimitStopLimitGtd;
    }

    public TriggerBracketGtd getTriggerBracketGtd() {
        return this.triggerBracketGtd;
    }

    public TriggerBracketGtc getTriggerBracketGtc() {
        return this.triggerBracketGtc;
    }

    @JsonProperty(value="sor_limit_ioc")
    public void setSorLimitIoc(SorLimitIoc sorLimitIoc) {
        this.sorLimitIoc = sorLimitIoc;
    }

    @JsonProperty(value="market_market_ioc")
    public void setMarketMarketIoc(MarketMarketIoc marketMarketIoc) {
        this.marketMarketIoc = marketMarketIoc;
    }

    @JsonProperty(value="limit_limit_gtc")
    public void setLimitLimitGtc(LimitLimitGtc limitLimitGtc) {
        this.limitLimitGtc = limitLimitGtc;
    }

    @JsonProperty(value="limit_limit_gtd")
    public void setLimitLimitGtd(LimitLimitGtd limitLimitGtd) {
        this.limitLimitGtd = limitLimitGtd;
    }

    @JsonProperty(value="limit_limit_fok")
    public void setLimitLimitFok(LimitLimitFok limitLimitFok) {
        this.limitLimitFok = limitLimitFok;
    }

    @JsonProperty(value="stop_limit_stop_limit_gtc")
    public void setStopLimitStopLimitGtc(StopLimitStopLimitGtc stopLimitStopLimitGtc) {
        this.stopLimitStopLimitGtc = stopLimitStopLimitGtc;
    }

    @JsonProperty(value="stop_limit_stop_limit_gtd")
    public void setStopLimitStopLimitGtd(StopLimitStopLimitGtd stopLimitStopLimitGtd) {
        this.stopLimitStopLimitGtd = stopLimitStopLimitGtd;
    }

    @JsonProperty(value="trigger_bracket_gtd")
    public void setTriggerBracketGtd(TriggerBracketGtd triggerBracketGtd) {
        this.triggerBracketGtd = triggerBracketGtd;
    }

    @JsonProperty(value="trigger_bracket_gtc")
    public void setTriggerBracketGtc(TriggerBracketGtc triggerBracketGtc) {
        this.triggerBracketGtc = triggerBracketGtc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderConfiguration)) {
            return false;
        }
        OrderConfiguration other = (OrderConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SorLimitIoc this$sorLimitIoc = this.getSorLimitIoc();
        SorLimitIoc other$sorLimitIoc = other.getSorLimitIoc();
        if (this$sorLimitIoc == null ? other$sorLimitIoc != null : !((Object)this$sorLimitIoc).equals(other$sorLimitIoc)) {
            return false;
        }
        MarketMarketIoc this$marketMarketIoc = this.getMarketMarketIoc();
        MarketMarketIoc other$marketMarketIoc = other.getMarketMarketIoc();
        if (this$marketMarketIoc == null ? other$marketMarketIoc != null : !((Object)this$marketMarketIoc).equals(other$marketMarketIoc)) {
            return false;
        }
        LimitLimitGtc this$limitLimitGtc = this.getLimitLimitGtc();
        LimitLimitGtc other$limitLimitGtc = other.getLimitLimitGtc();
        if (this$limitLimitGtc == null ? other$limitLimitGtc != null : !((Object)this$limitLimitGtc).equals(other$limitLimitGtc)) {
            return false;
        }
        LimitLimitGtd this$limitLimitGtd = this.getLimitLimitGtd();
        LimitLimitGtd other$limitLimitGtd = other.getLimitLimitGtd();
        if (this$limitLimitGtd == null ? other$limitLimitGtd != null : !((Object)this$limitLimitGtd).equals(other$limitLimitGtd)) {
            return false;
        }
        LimitLimitFok this$limitLimitFok = this.getLimitLimitFok();
        LimitLimitFok other$limitLimitFok = other.getLimitLimitFok();
        if (this$limitLimitFok == null ? other$limitLimitFok != null : !((Object)this$limitLimitFok).equals(other$limitLimitFok)) {
            return false;
        }
        StopLimitStopLimitGtc this$stopLimitStopLimitGtc = this.getStopLimitStopLimitGtc();
        StopLimitStopLimitGtc other$stopLimitStopLimitGtc = other.getStopLimitStopLimitGtc();
        if (this$stopLimitStopLimitGtc == null ? other$stopLimitStopLimitGtc != null : !((Object)this$stopLimitStopLimitGtc).equals(other$stopLimitStopLimitGtc)) {
            return false;
        }
        StopLimitStopLimitGtd this$stopLimitStopLimitGtd = this.getStopLimitStopLimitGtd();
        StopLimitStopLimitGtd other$stopLimitStopLimitGtd = other.getStopLimitStopLimitGtd();
        if (this$stopLimitStopLimitGtd == null ? other$stopLimitStopLimitGtd != null : !((Object)this$stopLimitStopLimitGtd).equals(other$stopLimitStopLimitGtd)) {
            return false;
        }
        TriggerBracketGtd this$triggerBracketGtd = this.getTriggerBracketGtd();
        TriggerBracketGtd other$triggerBracketGtd = other.getTriggerBracketGtd();
        if (this$triggerBracketGtd == null ? other$triggerBracketGtd != null : !((Object)this$triggerBracketGtd).equals(other$triggerBracketGtd)) {
            return false;
        }
        TriggerBracketGtc this$triggerBracketGtc = this.getTriggerBracketGtc();
        TriggerBracketGtc other$triggerBracketGtc = other.getTriggerBracketGtc();
        return !(this$triggerBracketGtc == null ? other$triggerBracketGtc != null : !((Object)this$triggerBracketGtc).equals(other$triggerBracketGtc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SorLimitIoc $sorLimitIoc = this.getSorLimitIoc();
        result = result * 59 + ($sorLimitIoc == null ? 43 : ((Object)$sorLimitIoc).hashCode());
        MarketMarketIoc $marketMarketIoc = this.getMarketMarketIoc();
        result = result * 59 + ($marketMarketIoc == null ? 43 : ((Object)$marketMarketIoc).hashCode());
        LimitLimitGtc $limitLimitGtc = this.getLimitLimitGtc();
        result = result * 59 + ($limitLimitGtc == null ? 43 : ((Object)$limitLimitGtc).hashCode());
        LimitLimitGtd $limitLimitGtd = this.getLimitLimitGtd();
        result = result * 59 + ($limitLimitGtd == null ? 43 : ((Object)$limitLimitGtd).hashCode());
        LimitLimitFok $limitLimitFok = this.getLimitLimitFok();
        result = result * 59 + ($limitLimitFok == null ? 43 : ((Object)$limitLimitFok).hashCode());
        StopLimitStopLimitGtc $stopLimitStopLimitGtc = this.getStopLimitStopLimitGtc();
        result = result * 59 + ($stopLimitStopLimitGtc == null ? 43 : ((Object)$stopLimitStopLimitGtc).hashCode());
        StopLimitStopLimitGtd $stopLimitStopLimitGtd = this.getStopLimitStopLimitGtd();
        result = result * 59 + ($stopLimitStopLimitGtd == null ? 43 : ((Object)$stopLimitStopLimitGtd).hashCode());
        TriggerBracketGtd $triggerBracketGtd = this.getTriggerBracketGtd();
        result = result * 59 + ($triggerBracketGtd == null ? 43 : ((Object)$triggerBracketGtd).hashCode());
        TriggerBracketGtc $triggerBracketGtc = this.getTriggerBracketGtc();
        result = result * 59 + ($triggerBracketGtc == null ? 43 : ((Object)$triggerBracketGtc).hashCode());
        return result;
    }

    public String toString() {
        return "OrderConfiguration(sorLimitIoc=" + this.getSorLimitIoc() + ", marketMarketIoc=" + this.getMarketMarketIoc() + ", limitLimitGtc=" + this.getLimitLimitGtc() + ", limitLimitGtd=" + this.getLimitLimitGtd() + ", limitLimitFok=" + this.getLimitLimitFok() + ", stopLimitStopLimitGtc=" + this.getStopLimitStopLimitGtc() + ", stopLimitStopLimitGtd=" + this.getStopLimitStopLimitGtd() + ", triggerBracketGtd=" + this.getTriggerBracketGtd() + ", triggerBracketGtc=" + this.getTriggerBracketGtc() + ")";
    }

    public static class OrderConfigurationBuilder {
        private SorLimitIoc sorLimitIoc;
        private MarketMarketIoc marketMarketIoc;
        private LimitLimitGtc limitLimitGtc;
        private LimitLimitGtd limitLimitGtd;
        private LimitLimitFok limitLimitFok;
        private StopLimitStopLimitGtc stopLimitStopLimitGtc;
        private StopLimitStopLimitGtd stopLimitStopLimitGtd;
        private TriggerBracketGtd triggerBracketGtd;
        private TriggerBracketGtc triggerBracketGtc;
        Side side;
        String quantity;

        public OrderConfigurationBuilder(Side side, BigDecimal quantity) {
            this.side = side;
            this.quantity = quantity.toString();
        }

        public OrderConfigurationBuilder sorLimitIoc(BigDecimal limitPrice) {
            this.sorLimitIoc = new SorLimitIoc(this.quantity, limitPrice.toString());
            return this;
        }

        public OrderConfigurationBuilder marketMarketIoc() {
            return this.marketMarketIoc(false);
        }

        public OrderConfigurationBuilder marketMarketIoc(boolean postOnly) {
            this.marketMarketIoc = new MarketMarketIoc(this.side == Side.BUY ? this.quantity : null, this.side == Side.SELL ? this.quantity : null, postOnly);
            return this;
        }

        public OrderConfigurationBuilder limitLimitGtc(BigDecimal limitPrice) {
            this.limitLimitGtc = new LimitLimitGtc(this.quantity, limitPrice.toString());
            return this;
        }

        public OrderConfigurationBuilder limitLimitGtd(BigDecimal limitPrice, Date endTime) {
            return this.limitLimitGtd(limitPrice, endTime, false);
        }

        public OrderConfigurationBuilder limitLimitGtd(BigDecimal limitPrice, Date endTime, boolean postOnly) {
            this.limitLimitGtd = new LimitLimitGtd(this.quantity, limitPrice.toString(), endTime, postOnly);
            return this;
        }

        public OrderConfigurationBuilder triggerBracketGtc(BigDecimal limitPrice, BigDecimal stopTriggerPrice) {
            this.triggerBracketGtc = new TriggerBracketGtc(this.quantity, limitPrice.toString(), stopTriggerPrice.toString());
            return this;
        }

        public OrderConfigurationBuilder stopLimitStopLimitGtc(BigDecimal limitPrice, BigDecimal stopPrice, StopDirection stopDirection) {
            this.stopLimitStopLimitGtc = new StopLimitStopLimitGtc(this.quantity, limitPrice.toString(), stopPrice.toString(), stopDirection);
            return this;
        }

        public OrderConfigurationBuilder triggerBracketGtd(BigDecimal limitPrice, BigDecimal stopTriggerPrice, Date endTime) {
            this.triggerBracketGtd = new TriggerBracketGtd(this.quantity, limitPrice.toString(), stopTriggerPrice.toString(), endTime);
            return this;
        }

        public OrderConfigurationBuilder stopLimitStopLimitGtd(BigDecimal limitPrice, BigDecimal stopPrice, Date endTime, StopDirection stopDirection) {
            this.stopLimitStopLimitGtd = new StopLimitStopLimitGtd(this.quantity, limitPrice.toString(), stopPrice.toString(), endTime, stopDirection);
            return this;
        }

        public OrderConfiguration build() {
            OrderConfiguration orderConfiguration = new OrderConfiguration();
            if (this.sorLimitIoc != null) {
                orderConfiguration.setSorLimitIoc(this.sorLimitIoc);
            }
            if (this.marketMarketIoc != null) {
                orderConfiguration.setMarketMarketIoc(this.marketMarketIoc);
            }
            if (this.limitLimitGtc != null) {
                orderConfiguration.setLimitLimitGtc(this.limitLimitGtc);
            }
            if (this.limitLimitGtd != null) {
                orderConfiguration.setLimitLimitGtd(this.limitLimitGtd);
            }
            if (this.triggerBracketGtc != null) {
                orderConfiguration.setTriggerBracketGtc(this.triggerBracketGtc);
            }
            if (this.stopLimitStopLimitGtc != null) {
                orderConfiguration.setStopLimitStopLimitGtc(this.stopLimitStopLimitGtc);
            }
            if (this.triggerBracketGtd != null) {
                orderConfiguration.setTriggerBracketGtd(this.triggerBracketGtd);
            }
            if (this.stopLimitStopLimitGtd != null) {
                orderConfiguration.setStopLimitStopLimitGtd(this.stopLimitStopLimitGtd);
            }
            return orderConfiguration;
        }

        @JsonProperty(value="limit_limit_fok")
        public OrderConfigurationBuilder limitLimitFok(LimitLimitFok limitLimitFok) {
            this.limitLimitFok = limitLimitFok;
            return this;
        }

        public String toString() {
            return "OrderConfiguration.OrderConfigurationBuilder(sorLimitIoc=" + this.sorLimitIoc + ", marketMarketIoc=" + this.marketMarketIoc + ", limitLimitGtc=" + this.limitLimitGtc + ", limitLimitGtd=" + this.limitLimitGtd + ", limitLimitFok=" + this.limitLimitFok + ", stopLimitStopLimitGtc=" + this.stopLimitStopLimitGtc + ", stopLimitStopLimitGtd=" + this.stopLimitStopLimitGtd + ", triggerBracketGtd=" + this.triggerBracketGtd + ", triggerBracketGtc=" + this.triggerBracketGtc + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SorLimitIoc {
        @JsonProperty(value="base_size")
        private String baseSize;
        @JsonProperty(value="limit_price")
        private String limitPrice;

        public String getBaseSize() {
            return this.baseSize;
        }

        public String getLimitPrice() {
            return this.limitPrice;
        }

        @JsonProperty(value="base_size")
        public void setBaseSize(String baseSize) {
            this.baseSize = baseSize;
        }

        @JsonProperty(value="limit_price")
        public void setLimitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SorLimitIoc)) {
                return false;
            }
            SorLimitIoc other = (SorLimitIoc)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$baseSize = this.getBaseSize();
            String other$baseSize = other.getBaseSize();
            if (this$baseSize == null ? other$baseSize != null : !this$baseSize.equals(other$baseSize)) {
                return false;
            }
            String this$limitPrice = this.getLimitPrice();
            String other$limitPrice = other.getLimitPrice();
            return !(this$limitPrice == null ? other$limitPrice != null : !this$limitPrice.equals(other$limitPrice));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SorLimitIoc;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $baseSize = this.getBaseSize();
            result = result * 59 + ($baseSize == null ? 43 : $baseSize.hashCode());
            String $limitPrice = this.getLimitPrice();
            result = result * 59 + ($limitPrice == null ? 43 : $limitPrice.hashCode());
            return result;
        }

        public String toString() {
            return "OrderConfiguration.SorLimitIoc(baseSize=" + this.getBaseSize() + ", limitPrice=" + this.getLimitPrice() + ")";
        }

        public SorLimitIoc(String baseSize, String limitPrice) {
            this.baseSize = baseSize;
            this.limitPrice = limitPrice;
        }

        public SorLimitIoc() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MarketMarketIoc {
        @JsonProperty(value="base_size")
        private String baseSize;
        @JsonProperty(value="quote_size")
        private String quoteSize;
        @JsonProperty(value="post_only")
        private boolean postOnly;

        public String getBaseSize() {
            return this.baseSize;
        }

        public String getQuoteSize() {
            return this.quoteSize;
        }

        public boolean isPostOnly() {
            return this.postOnly;
        }

        @JsonProperty(value="base_size")
        public void setBaseSize(String baseSize) {
            this.baseSize = baseSize;
        }

        @JsonProperty(value="quote_size")
        public void setQuoteSize(String quoteSize) {
            this.quoteSize = quoteSize;
        }

        @JsonProperty(value="post_only")
        public void setPostOnly(boolean postOnly) {
            this.postOnly = postOnly;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MarketMarketIoc)) {
                return false;
            }
            MarketMarketIoc other = (MarketMarketIoc)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPostOnly() != other.isPostOnly()) {
                return false;
            }
            String this$baseSize = this.getBaseSize();
            String other$baseSize = other.getBaseSize();
            if (this$baseSize == null ? other$baseSize != null : !this$baseSize.equals(other$baseSize)) {
                return false;
            }
            String this$quoteSize = this.getQuoteSize();
            String other$quoteSize = other.getQuoteSize();
            return !(this$quoteSize == null ? other$quoteSize != null : !this$quoteSize.equals(other$quoteSize));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MarketMarketIoc;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPostOnly() ? 79 : 97);
            String $baseSize = this.getBaseSize();
            result = result * 59 + ($baseSize == null ? 43 : $baseSize.hashCode());
            String $quoteSize = this.getQuoteSize();
            result = result * 59 + ($quoteSize == null ? 43 : $quoteSize.hashCode());
            return result;
        }

        public String toString() {
            return "OrderConfiguration.MarketMarketIoc(baseSize=" + this.getBaseSize() + ", quoteSize=" + this.getQuoteSize() + ", postOnly=" + this.isPostOnly() + ")";
        }

        public MarketMarketIoc(String baseSize, String quoteSize, boolean postOnly) {
            this.baseSize = baseSize;
            this.quoteSize = quoteSize;
            this.postOnly = postOnly;
        }

        public MarketMarketIoc() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LimitLimitGtc {
        @JsonProperty(value="base_size")
        private String baseSize;
        @JsonProperty(value="limit_price")
        private String limitPrice;

        public String getBaseSize() {
            return this.baseSize;
        }

        public String getLimitPrice() {
            return this.limitPrice;
        }

        @JsonProperty(value="base_size")
        public void setBaseSize(String baseSize) {
            this.baseSize = baseSize;
        }

        @JsonProperty(value="limit_price")
        public void setLimitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LimitLimitGtc)) {
                return false;
            }
            LimitLimitGtc other = (LimitLimitGtc)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$baseSize = this.getBaseSize();
            String other$baseSize = other.getBaseSize();
            if (this$baseSize == null ? other$baseSize != null : !this$baseSize.equals(other$baseSize)) {
                return false;
            }
            String this$limitPrice = this.getLimitPrice();
            String other$limitPrice = other.getLimitPrice();
            return !(this$limitPrice == null ? other$limitPrice != null : !this$limitPrice.equals(other$limitPrice));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LimitLimitGtc;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $baseSize = this.getBaseSize();
            result = result * 59 + ($baseSize == null ? 43 : $baseSize.hashCode());
            String $limitPrice = this.getLimitPrice();
            result = result * 59 + ($limitPrice == null ? 43 : $limitPrice.hashCode());
            return result;
        }

        public String toString() {
            return "OrderConfiguration.LimitLimitGtc(baseSize=" + this.getBaseSize() + ", limitPrice=" + this.getLimitPrice() + ")";
        }

        public LimitLimitGtc(String baseSize, String limitPrice) {
            this.baseSize = baseSize;
            this.limitPrice = limitPrice;
        }

        public LimitLimitGtc() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LimitLimitGtd {
        @JsonProperty(value="base_size")
        private String baseSize;
        @JsonProperty(value="limit_price")
        private String limitPrice;
        @JsonProperty(value="end_time")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
        private Date endTime;
        @JsonProperty(value="post_only")
        private boolean postOnly;

        public String getBaseSize() {
            return this.baseSize;
        }

        public String getLimitPrice() {
            return this.limitPrice;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public boolean isPostOnly() {
            return this.postOnly;
        }

        @JsonProperty(value="base_size")
        public void setBaseSize(String baseSize) {
            this.baseSize = baseSize;
        }

        @JsonProperty(value="limit_price")
        public void setLimitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
        }

        @JsonProperty(value="end_time")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        @JsonProperty(value="post_only")
        public void setPostOnly(boolean postOnly) {
            this.postOnly = postOnly;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LimitLimitGtd)) {
                return false;
            }
            LimitLimitGtd other = (LimitLimitGtd)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPostOnly() != other.isPostOnly()) {
                return false;
            }
            String this$baseSize = this.getBaseSize();
            String other$baseSize = other.getBaseSize();
            if (this$baseSize == null ? other$baseSize != null : !this$baseSize.equals(other$baseSize)) {
                return false;
            }
            String this$limitPrice = this.getLimitPrice();
            String other$limitPrice = other.getLimitPrice();
            if (this$limitPrice == null ? other$limitPrice != null : !this$limitPrice.equals(other$limitPrice)) {
                return false;
            }
            Date this$endTime = this.getEndTime();
            Date other$endTime = other.getEndTime();
            return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LimitLimitGtd;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPostOnly() ? 79 : 97);
            String $baseSize = this.getBaseSize();
            result = result * 59 + ($baseSize == null ? 43 : $baseSize.hashCode());
            String $limitPrice = this.getLimitPrice();
            result = result * 59 + ($limitPrice == null ? 43 : $limitPrice.hashCode());
            Date $endTime = this.getEndTime();
            result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
            return result;
        }

        public String toString() {
            return "OrderConfiguration.LimitLimitGtd(baseSize=" + this.getBaseSize() + ", limitPrice=" + this.getLimitPrice() + ", endTime=" + this.getEndTime() + ", postOnly=" + this.isPostOnly() + ")";
        }

        public LimitLimitGtd(String baseSize, String limitPrice, Date endTime, boolean postOnly) {
            this.baseSize = baseSize;
            this.limitPrice = limitPrice;
            this.endTime = endTime;
            this.postOnly = postOnly;
        }

        public LimitLimitGtd() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LimitLimitFok {
        @JsonProperty(value="base_size")
        private String baseSize;
        @JsonProperty(value="limit_price")
        private String limitPrice;

        public String getBaseSize() {
            return this.baseSize;
        }

        public String getLimitPrice() {
            return this.limitPrice;
        }

        @JsonProperty(value="base_size")
        public void setBaseSize(String baseSize) {
            this.baseSize = baseSize;
        }

        @JsonProperty(value="limit_price")
        public void setLimitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LimitLimitFok)) {
                return false;
            }
            LimitLimitFok other = (LimitLimitFok)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$baseSize = this.getBaseSize();
            String other$baseSize = other.getBaseSize();
            if (this$baseSize == null ? other$baseSize != null : !this$baseSize.equals(other$baseSize)) {
                return false;
            }
            String this$limitPrice = this.getLimitPrice();
            String other$limitPrice = other.getLimitPrice();
            return !(this$limitPrice == null ? other$limitPrice != null : !this$limitPrice.equals(other$limitPrice));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LimitLimitFok;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $baseSize = this.getBaseSize();
            result = result * 59 + ($baseSize == null ? 43 : $baseSize.hashCode());
            String $limitPrice = this.getLimitPrice();
            result = result * 59 + ($limitPrice == null ? 43 : $limitPrice.hashCode());
            return result;
        }

        public String toString() {
            return "OrderConfiguration.LimitLimitFok(baseSize=" + this.getBaseSize() + ", limitPrice=" + this.getLimitPrice() + ")";
        }

        public LimitLimitFok(String baseSize, String limitPrice) {
            this.baseSize = baseSize;
            this.limitPrice = limitPrice;
        }

        public LimitLimitFok() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StopLimitStopLimitGtc {
        @JsonProperty(value="base_size")
        private String baseSize;
        @JsonProperty(value="limit_price")
        private String limitPrice;
        @JsonProperty(value="stop_price")
        private String stopPrice;
        @JsonProperty(value="stop_direction")
        private StopDirection stopDirection;

        public String getBaseSize() {
            return this.baseSize;
        }

        public String getLimitPrice() {
            return this.limitPrice;
        }

        public String getStopPrice() {
            return this.stopPrice;
        }

        public StopDirection getStopDirection() {
            return this.stopDirection;
        }

        @JsonProperty(value="base_size")
        public void setBaseSize(String baseSize) {
            this.baseSize = baseSize;
        }

        @JsonProperty(value="limit_price")
        public void setLimitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
        }

        @JsonProperty(value="stop_price")
        public void setStopPrice(String stopPrice) {
            this.stopPrice = stopPrice;
        }

        @JsonProperty(value="stop_direction")
        public void setStopDirection(StopDirection stopDirection) {
            this.stopDirection = stopDirection;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StopLimitStopLimitGtc)) {
                return false;
            }
            StopLimitStopLimitGtc other = (StopLimitStopLimitGtc)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$baseSize = this.getBaseSize();
            String other$baseSize = other.getBaseSize();
            if (this$baseSize == null ? other$baseSize != null : !this$baseSize.equals(other$baseSize)) {
                return false;
            }
            String this$limitPrice = this.getLimitPrice();
            String other$limitPrice = other.getLimitPrice();
            if (this$limitPrice == null ? other$limitPrice != null : !this$limitPrice.equals(other$limitPrice)) {
                return false;
            }
            String this$stopPrice = this.getStopPrice();
            String other$stopPrice = other.getStopPrice();
            if (this$stopPrice == null ? other$stopPrice != null : !this$stopPrice.equals(other$stopPrice)) {
                return false;
            }
            StopDirection this$stopDirection = this.getStopDirection();
            StopDirection other$stopDirection = other.getStopDirection();
            return !(this$stopDirection == null ? other$stopDirection != null : !((Object)((Object)this$stopDirection)).equals((Object)other$stopDirection));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StopLimitStopLimitGtc;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $baseSize = this.getBaseSize();
            result = result * 59 + ($baseSize == null ? 43 : $baseSize.hashCode());
            String $limitPrice = this.getLimitPrice();
            result = result * 59 + ($limitPrice == null ? 43 : $limitPrice.hashCode());
            String $stopPrice = this.getStopPrice();
            result = result * 59 + ($stopPrice == null ? 43 : $stopPrice.hashCode());
            StopDirection $stopDirection = this.getStopDirection();
            result = result * 59 + ($stopDirection == null ? 43 : ((Object)((Object)$stopDirection)).hashCode());
            return result;
        }

        public String toString() {
            return "OrderConfiguration.StopLimitStopLimitGtc(baseSize=" + this.getBaseSize() + ", limitPrice=" + this.getLimitPrice() + ", stopPrice=" + this.getStopPrice() + ", stopDirection=" + this.getStopDirection() + ")";
        }

        public StopLimitStopLimitGtc(String baseSize, String limitPrice, String stopPrice, StopDirection stopDirection) {
            this.baseSize = baseSize;
            this.limitPrice = limitPrice;
            this.stopPrice = stopPrice;
            this.stopDirection = stopDirection;
        }

        public StopLimitStopLimitGtc() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StopLimitStopLimitGtd {
        @JsonProperty(value="base_size")
        private String baseSize;
        @JsonProperty(value="limit_price")
        private String limitPrice;
        @JsonProperty(value="stop_price")
        private String stopPrice;
        @JsonProperty(value="end_time")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
        private Date endTime;
        @JsonProperty(value="stop_direction")
        private StopDirection stopDirection;

        public String getBaseSize() {
            return this.baseSize;
        }

        public String getLimitPrice() {
            return this.limitPrice;
        }

        public String getStopPrice() {
            return this.stopPrice;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public StopDirection getStopDirection() {
            return this.stopDirection;
        }

        @JsonProperty(value="base_size")
        public void setBaseSize(String baseSize) {
            this.baseSize = baseSize;
        }

        @JsonProperty(value="limit_price")
        public void setLimitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
        }

        @JsonProperty(value="stop_price")
        public void setStopPrice(String stopPrice) {
            this.stopPrice = stopPrice;
        }

        @JsonProperty(value="end_time")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        @JsonProperty(value="stop_direction")
        public void setStopDirection(StopDirection stopDirection) {
            this.stopDirection = stopDirection;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StopLimitStopLimitGtd)) {
                return false;
            }
            StopLimitStopLimitGtd other = (StopLimitStopLimitGtd)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$baseSize = this.getBaseSize();
            String other$baseSize = other.getBaseSize();
            if (this$baseSize == null ? other$baseSize != null : !this$baseSize.equals(other$baseSize)) {
                return false;
            }
            String this$limitPrice = this.getLimitPrice();
            String other$limitPrice = other.getLimitPrice();
            if (this$limitPrice == null ? other$limitPrice != null : !this$limitPrice.equals(other$limitPrice)) {
                return false;
            }
            String this$stopPrice = this.getStopPrice();
            String other$stopPrice = other.getStopPrice();
            if (this$stopPrice == null ? other$stopPrice != null : !this$stopPrice.equals(other$stopPrice)) {
                return false;
            }
            Date this$endTime = this.getEndTime();
            Date other$endTime = other.getEndTime();
            if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
                return false;
            }
            StopDirection this$stopDirection = this.getStopDirection();
            StopDirection other$stopDirection = other.getStopDirection();
            return !(this$stopDirection == null ? other$stopDirection != null : !((Object)((Object)this$stopDirection)).equals((Object)other$stopDirection));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StopLimitStopLimitGtd;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $baseSize = this.getBaseSize();
            result = result * 59 + ($baseSize == null ? 43 : $baseSize.hashCode());
            String $limitPrice = this.getLimitPrice();
            result = result * 59 + ($limitPrice == null ? 43 : $limitPrice.hashCode());
            String $stopPrice = this.getStopPrice();
            result = result * 59 + ($stopPrice == null ? 43 : $stopPrice.hashCode());
            Date $endTime = this.getEndTime();
            result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
            StopDirection $stopDirection = this.getStopDirection();
            result = result * 59 + ($stopDirection == null ? 43 : ((Object)((Object)$stopDirection)).hashCode());
            return result;
        }

        public String toString() {
            return "OrderConfiguration.StopLimitStopLimitGtd(baseSize=" + this.getBaseSize() + ", limitPrice=" + this.getLimitPrice() + ", stopPrice=" + this.getStopPrice() + ", endTime=" + this.getEndTime() + ", stopDirection=" + this.getStopDirection() + ")";
        }

        public StopLimitStopLimitGtd(String baseSize, String limitPrice, String stopPrice, Date endTime, StopDirection stopDirection) {
            this.baseSize = baseSize;
            this.limitPrice = limitPrice;
            this.stopPrice = stopPrice;
            this.endTime = endTime;
            this.stopDirection = stopDirection;
        }

        public StopLimitStopLimitGtd() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TriggerBracketGtd {
        @JsonProperty(value="base_size")
        private String baseSize;
        @JsonProperty(value="limit_price")
        private String limitPrice;
        @JsonProperty(value="stop_trigger_price")
        private String stopTriggerPrice;
        @JsonProperty(value="end_time")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
        private Date endTime;

        public String getBaseSize() {
            return this.baseSize;
        }

        public String getLimitPrice() {
            return this.limitPrice;
        }

        public String getStopTriggerPrice() {
            return this.stopTriggerPrice;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        @JsonProperty(value="base_size")
        public void setBaseSize(String baseSize) {
            this.baseSize = baseSize;
        }

        @JsonProperty(value="limit_price")
        public void setLimitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
        }

        @JsonProperty(value="stop_trigger_price")
        public void setStopTriggerPrice(String stopTriggerPrice) {
            this.stopTriggerPrice = stopTriggerPrice;
        }

        @JsonProperty(value="end_time")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TriggerBracketGtd)) {
                return false;
            }
            TriggerBracketGtd other = (TriggerBracketGtd)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$baseSize = this.getBaseSize();
            String other$baseSize = other.getBaseSize();
            if (this$baseSize == null ? other$baseSize != null : !this$baseSize.equals(other$baseSize)) {
                return false;
            }
            String this$limitPrice = this.getLimitPrice();
            String other$limitPrice = other.getLimitPrice();
            if (this$limitPrice == null ? other$limitPrice != null : !this$limitPrice.equals(other$limitPrice)) {
                return false;
            }
            String this$stopTriggerPrice = this.getStopTriggerPrice();
            String other$stopTriggerPrice = other.getStopTriggerPrice();
            if (this$stopTriggerPrice == null ? other$stopTriggerPrice != null : !this$stopTriggerPrice.equals(other$stopTriggerPrice)) {
                return false;
            }
            Date this$endTime = this.getEndTime();
            Date other$endTime = other.getEndTime();
            return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TriggerBracketGtd;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $baseSize = this.getBaseSize();
            result = result * 59 + ($baseSize == null ? 43 : $baseSize.hashCode());
            String $limitPrice = this.getLimitPrice();
            result = result * 59 + ($limitPrice == null ? 43 : $limitPrice.hashCode());
            String $stopTriggerPrice = this.getStopTriggerPrice();
            result = result * 59 + ($stopTriggerPrice == null ? 43 : $stopTriggerPrice.hashCode());
            Date $endTime = this.getEndTime();
            result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
            return result;
        }

        public String toString() {
            return "OrderConfiguration.TriggerBracketGtd(baseSize=" + this.getBaseSize() + ", limitPrice=" + this.getLimitPrice() + ", stopTriggerPrice=" + this.getStopTriggerPrice() + ", endTime=" + this.getEndTime() + ")";
        }

        public TriggerBracketGtd(String baseSize, String limitPrice, String stopTriggerPrice, Date endTime) {
            this.baseSize = baseSize;
            this.limitPrice = limitPrice;
            this.stopTriggerPrice = stopTriggerPrice;
            this.endTime = endTime;
        }

        public TriggerBracketGtd() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TriggerBracketGtc {
        @JsonProperty(value="base_size")
        private String baseSize;
        @JsonProperty(value="limit_price")
        private String limitPrice;
        @JsonProperty(value="stop_trigger_price")
        private String stopTriggerPrice;

        public String getBaseSize() {
            return this.baseSize;
        }

        public String getLimitPrice() {
            return this.limitPrice;
        }

        public String getStopTriggerPrice() {
            return this.stopTriggerPrice;
        }

        @JsonProperty(value="base_size")
        public void setBaseSize(String baseSize) {
            this.baseSize = baseSize;
        }

        @JsonProperty(value="limit_price")
        public void setLimitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
        }

        @JsonProperty(value="stop_trigger_price")
        public void setStopTriggerPrice(String stopTriggerPrice) {
            this.stopTriggerPrice = stopTriggerPrice;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TriggerBracketGtc)) {
                return false;
            }
            TriggerBracketGtc other = (TriggerBracketGtc)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$baseSize = this.getBaseSize();
            String other$baseSize = other.getBaseSize();
            if (this$baseSize == null ? other$baseSize != null : !this$baseSize.equals(other$baseSize)) {
                return false;
            }
            String this$limitPrice = this.getLimitPrice();
            String other$limitPrice = other.getLimitPrice();
            if (this$limitPrice == null ? other$limitPrice != null : !this$limitPrice.equals(other$limitPrice)) {
                return false;
            }
            String this$stopTriggerPrice = this.getStopTriggerPrice();
            String other$stopTriggerPrice = other.getStopTriggerPrice();
            return !(this$stopTriggerPrice == null ? other$stopTriggerPrice != null : !this$stopTriggerPrice.equals(other$stopTriggerPrice));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TriggerBracketGtc;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $baseSize = this.getBaseSize();
            result = result * 59 + ($baseSize == null ? 43 : $baseSize.hashCode());
            String $limitPrice = this.getLimitPrice();
            result = result * 59 + ($limitPrice == null ? 43 : $limitPrice.hashCode());
            String $stopTriggerPrice = this.getStopTriggerPrice();
            result = result * 59 + ($stopTriggerPrice == null ? 43 : $stopTriggerPrice.hashCode());
            return result;
        }

        public String toString() {
            return "OrderConfiguration.TriggerBracketGtc(baseSize=" + this.getBaseSize() + ", limitPrice=" + this.getLimitPrice() + ", stopTriggerPrice=" + this.getStopTriggerPrice() + ")";
        }

        public TriggerBracketGtc(String baseSize, String limitPrice, String stopTriggerPrice) {
            this.baseSize = baseSize;
            this.limitPrice = limitPrice;
            this.stopTriggerPrice = stopTriggerPrice;
        }

        public TriggerBracketGtc() {
        }
    }
}

