/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.coinbase.api.v3.domain.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.request.OrderConfiguration;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.MarginType;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.Side;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OrderRequest {
    @JsonProperty(value="client_order_id")
    private String clientOrderId;
    @JsonProperty(value="product_id")
    private String productId;
    private Side side;
    @JsonProperty(value="self_trade_prevention_id")
    private String selfTradePreventionId;
    private String leverage;
    @JsonProperty(value="margin_type")
    private MarginType marginType;
    @JsonProperty(value="retail_portfolio_id")
    private String retailPortfolioId;
    @JsonProperty(value="order_configuration")
    private OrderConfiguration orderConfiguration;

    OrderRequest(String clientOrderId, String productId, Side side, String selfTradePreventionId, String leverage, MarginType marginType, String retailPortfolioId, OrderConfiguration orderConfiguration) {
        this.clientOrderId = clientOrderId;
        this.productId = productId;
        this.side = side;
        this.selfTradePreventionId = selfTradePreventionId;
        this.leverage = leverage;
        this.marginType = marginType;
        this.retailPortfolioId = retailPortfolioId;
        this.orderConfiguration = orderConfiguration;
    }

    public static OrderRequestBuilder builder() {
        return new OrderRequestBuilder();
    }

    public String toString() {
        return "OrderRequest(clientOrderId=" + this.getClientOrderId() + ", productId=" + this.getProductId() + ", side=" + this.getSide() + ", selfTradePreventionId=" + this.getSelfTradePreventionId() + ", leverage=" + this.getLeverage() + ", marginType=" + this.getMarginType() + ", retailPortfolioId=" + this.getRetailPortfolioId() + ", orderConfiguration=" + this.getOrderConfiguration() + ")";
    }

    public String getClientOrderId() {
        return this.clientOrderId;
    }

    public String getProductId() {
        return this.productId;
    }

    public Side getSide() {
        return this.side;
    }

    public String getSelfTradePreventionId() {
        return this.selfTradePreventionId;
    }

    public String getLeverage() {
        return this.leverage;
    }

    public MarginType getMarginType() {
        return this.marginType;
    }

    public String getRetailPortfolioId() {
        return this.retailPortfolioId;
    }

    public OrderConfiguration getOrderConfiguration() {
        return this.orderConfiguration;
    }

    @JsonProperty(value="client_order_id")
    public void setClientOrderId(String clientOrderId) {
        this.clientOrderId = clientOrderId;
    }

    @JsonProperty(value="product_id")
    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setSide(Side side) {
        this.side = side;
    }

    @JsonProperty(value="self_trade_prevention_id")
    public void setSelfTradePreventionId(String selfTradePreventionId) {
        this.selfTradePreventionId = selfTradePreventionId;
    }

    public void setLeverage(String leverage) {
        this.leverage = leverage;
    }

    @JsonProperty(value="margin_type")
    public void setMarginType(MarginType marginType) {
        this.marginType = marginType;
    }

    @JsonProperty(value="retail_portfolio_id")
    public void setRetailPortfolioId(String retailPortfolioId) {
        this.retailPortfolioId = retailPortfolioId;
    }

    @JsonProperty(value="order_configuration")
    public void setOrderConfiguration(OrderConfiguration orderConfiguration) {
        this.orderConfiguration = orderConfiguration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderRequest)) {
            return false;
        }
        OrderRequest other = (OrderRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientOrderId = this.getClientOrderId();
        String other$clientOrderId = other.getClientOrderId();
        if (this$clientOrderId == null ? other$clientOrderId != null : !this$clientOrderId.equals(other$clientOrderId)) {
            return false;
        }
        String this$productId = this.getProductId();
        String other$productId = other.getProductId();
        if (this$productId == null ? other$productId != null : !this$productId.equals(other$productId)) {
            return false;
        }
        Side this$side = this.getSide();
        Side other$side = other.getSide();
        if (this$side == null ? other$side != null : !((Object)((Object)this$side)).equals((Object)other$side)) {
            return false;
        }
        String this$selfTradePreventionId = this.getSelfTradePreventionId();
        String other$selfTradePreventionId = other.getSelfTradePreventionId();
        if (this$selfTradePreventionId == null ? other$selfTradePreventionId != null : !this$selfTradePreventionId.equals(other$selfTradePreventionId)) {
            return false;
        }
        String this$leverage = this.getLeverage();
        String other$leverage = other.getLeverage();
        if (this$leverage == null ? other$leverage != null : !this$leverage.equals(other$leverage)) {
            return false;
        }
        MarginType this$marginType = this.getMarginType();
        MarginType other$marginType = other.getMarginType();
        if (this$marginType == null ? other$marginType != null : !((Object)((Object)this$marginType)).equals((Object)other$marginType)) {
            return false;
        }
        String this$retailPortfolioId = this.getRetailPortfolioId();
        String other$retailPortfolioId = other.getRetailPortfolioId();
        if (this$retailPortfolioId == null ? other$retailPortfolioId != null : !this$retailPortfolioId.equals(other$retailPortfolioId)) {
            return false;
        }
        OrderConfiguration this$orderConfiguration = this.getOrderConfiguration();
        OrderConfiguration other$orderConfiguration = other.getOrderConfiguration();
        return !(this$orderConfiguration == null ? other$orderConfiguration != null : !((Object)this$orderConfiguration).equals(other$orderConfiguration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientOrderId = this.getClientOrderId();
        result = result * 59 + ($clientOrderId == null ? 43 : $clientOrderId.hashCode());
        String $productId = this.getProductId();
        result = result * 59 + ($productId == null ? 43 : $productId.hashCode());
        Side $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : ((Object)((Object)$side)).hashCode());
        String $selfTradePreventionId = this.getSelfTradePreventionId();
        result = result * 59 + ($selfTradePreventionId == null ? 43 : $selfTradePreventionId.hashCode());
        String $leverage = this.getLeverage();
        result = result * 59 + ($leverage == null ? 43 : $leverage.hashCode());
        MarginType $marginType = this.getMarginType();
        result = result * 59 + ($marginType == null ? 43 : ((Object)((Object)$marginType)).hashCode());
        String $retailPortfolioId = this.getRetailPortfolioId();
        result = result * 59 + ($retailPortfolioId == null ? 43 : $retailPortfolioId.hashCode());
        OrderConfiguration $orderConfiguration = this.getOrderConfiguration();
        result = result * 59 + ($orderConfiguration == null ? 43 : ((Object)$orderConfiguration).hashCode());
        return result;
    }

    public static class OrderRequestBuilder {
        private String clientOrderId;
        private String productId;
        private Side side;
        private String selfTradePreventionId;
        private String leverage;
        private MarginType marginType;
        private String retailPortfolioId;
        private OrderConfiguration orderConfiguration;

        OrderRequestBuilder() {
        }

        @JsonProperty(value="client_order_id")
        public OrderRequestBuilder clientOrderId(String clientOrderId) {
            this.clientOrderId = clientOrderId;
            return this;
        }

        @JsonProperty(value="product_id")
        public OrderRequestBuilder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public OrderRequestBuilder side(Side side) {
            this.side = side;
            return this;
        }

        @JsonProperty(value="self_trade_prevention_id")
        public OrderRequestBuilder selfTradePreventionId(String selfTradePreventionId) {
            this.selfTradePreventionId = selfTradePreventionId;
            return this;
        }

        public OrderRequestBuilder leverage(String leverage) {
            this.leverage = leverage;
            return this;
        }

        @JsonProperty(value="margin_type")
        public OrderRequestBuilder marginType(MarginType marginType) {
            this.marginType = marginType;
            return this;
        }

        @JsonProperty(value="retail_portfolio_id")
        public OrderRequestBuilder retailPortfolioId(String retailPortfolioId) {
            this.retailPortfolioId = retailPortfolioId;
            return this;
        }

        @JsonProperty(value="order_configuration")
        public OrderRequestBuilder orderConfiguration(OrderConfiguration orderConfiguration) {
            this.orderConfiguration = orderConfiguration;
            return this;
        }

        public OrderRequest build() {
            return new OrderRequest(this.clientOrderId, this.productId, this.side, this.selfTradePreventionId, this.leverage, this.marginType, this.retailPortfolioId, this.orderConfiguration);
        }

        public String toString() {
            return "OrderRequest.OrderRequestBuilder(clientOrderId=" + this.clientOrderId + ", productId=" + this.productId + ", side=" + this.side + ", selfTradePreventionId=" + this.selfTradePreventionId + ", leverage=" + this.leverage + ", marginType=" + this.marginType + ", retailPortfolioId=" + this.retailPortfolioId + ", orderConfiguration=" + this.orderConfiguration + ")";
        }
    }
}

