/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.coinbase.api.v3.domain.request;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum WindowSize {
    ONE_MINUTE(60000),
    FIVE_MINUTE(WindowSize.ONE_MINUTE.size * 5),
    FIFTEEN_MINUTE(WindowSize.FIVE_MINUTE.size * 3),
    THIRTY_MINUTE(WindowSize.FIFTEEN_MINUTE.size * 2),
    ONE_HOUR(WindowSize.THIRTY_MINUTE.size * 2),
    TWO_HOUR(WindowSize.ONE_HOUR.size * 2),
    SIX_HOUR(WindowSize.TWO_HOUR.size * 3),
    ONE_DAY(WindowSize.SIX_HOUR.size * 4);

    private static final Map<Integer, WindowSize> MAP;
    private final int size;

    public static WindowSize fromMillis(int millis) {
        return MAP.get(millis);
    }

    private WindowSize(int size) {
        this.size = size;
    }

    public int asMilli() {
        return this.size;
    }

    public int asSeconds() {
        return this.size / 1000;
    }

    public int asMinutes() {
        return this.asSeconds() / 60;
    }

    static {
        MAP = Arrays.stream(WindowSize.values()).collect(Collectors.toMap(WindowSize::asMilli, Function.identity()));
    }
}

