/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.exchanges.a.specification.domain.Order;
import estonlabs.cxtl.exchanges.a.specification.domain.SimpleOrderStatus;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.request.OrderConfiguration;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.MarginType;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.OrderPlacementSource;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.OrderStatus;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.OrderType;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.Side;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CoinbaseOrder
implements Order {
    @JsonProperty(value="order_id")
    private String orderId;
    @JsonProperty(value="product_id")
    private String symbol;
    @JsonProperty(value="user_id")
    private String userId;
    private Side side;
    @JsonProperty(value="client_order_id")
    private String clOrdId;
    private OrderStatus status;
    @JsonProperty(value="time_in_force")
    private String timeInForce;
    @JsonProperty(value="created_time")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ")
    private String createdTime;
    @JsonProperty(value="completion_percentage")
    private String completionPercentage;
    @JsonProperty(value="filled_size")
    private double cumQty;
    @JsonProperty(value="average_filled_price")
    private String averageFilledPrice;
    private String fee;
    @JsonProperty(value="number_of_fills")
    private double numberOfFills;
    @JsonProperty(value="filled_value")
    private Double lastOrAvgPx;
    @JsonProperty(value="pending_cancel")
    private boolean pendingCancel;
    @JsonProperty(value="size_in_quote")
    private boolean sizeInQuote;
    @JsonProperty(value="total_fees")
    private String totalFees;
    @JsonProperty(value="size_inclusive_of_fees")
    private boolean sizeInclusiveOfFees;
    @JsonProperty(value="total_value_after_fees")
    private String totalValueAfterFees;
    @JsonProperty(value="trigger_status")
    private String triggerStatus;
    @JsonProperty(value="order_type")
    private OrderType orderType;
    @JsonProperty(value="reject_reason")
    private String rejectReason;
    private boolean settled;
    @JsonProperty(value="product_type")
    private String productType;
    @JsonProperty(value="reject_message")
    private String rejectMessage;
    @JsonProperty(value="cancel_message")
    private String cancelMessage;
    @JsonProperty(value="order_placement_source")
    private OrderPlacementSource orderPlacementSource;
    @JsonProperty(value="outstanding_hold_amount")
    private String outstandingHoldAmount;
    @JsonProperty(value="is_liquidation")
    private boolean liquidation;
    @JsonProperty(value="last_fill_time")
    private String lastFillTime;
    @JsonProperty(value="edit_history")
    private List<?> editHistory;
    private String leverage;
    @JsonProperty(value="margin_type")
    private MarginType marginType;
    @JsonProperty(value="retail_portfolio_id")
    private String retailPortfolioId;
    @JsonProperty(value="order_configuration")
    private OrderConfiguration orderConfiguration;

    @Override
    public SimpleOrderStatus getSimpleStatus() {
        return this.status.getSimpleOrderStatus();
    }

    @Override
    public String getOrderId() {
        return this.orderId;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public String getUserId() {
        return this.userId;
    }

    public Side getSide() {
        return this.side;
    }

    @Override
    public String getClOrdId() {
        return this.clOrdId;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public String getTimeInForce() {
        return this.timeInForce;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public String getCompletionPercentage() {
        return this.completionPercentage;
    }

    @Override
    public double getCumQty() {
        return this.cumQty;
    }

    public String getAverageFilledPrice() {
        return this.averageFilledPrice;
    }

    public String getFee() {
        return this.fee;
    }

    public double getNumberOfFills() {
        return this.numberOfFills;
    }

    @Override
    public Double getLastOrAvgPx() {
        return this.lastOrAvgPx;
    }

    public boolean isPendingCancel() {
        return this.pendingCancel;
    }

    public boolean isSizeInQuote() {
        return this.sizeInQuote;
    }

    public String getTotalFees() {
        return this.totalFees;
    }

    public boolean isSizeInclusiveOfFees() {
        return this.sizeInclusiveOfFees;
    }

    public String getTotalValueAfterFees() {
        return this.totalValueAfterFees;
    }

    public String getTriggerStatus() {
        return this.triggerStatus;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public String getRejectReason() {
        return this.rejectReason;
    }

    public boolean isSettled() {
        return this.settled;
    }

    public String getProductType() {
        return this.productType;
    }

    public String getRejectMessage() {
        return this.rejectMessage;
    }

    public String getCancelMessage() {
        return this.cancelMessage;
    }

    public OrderPlacementSource getOrderPlacementSource() {
        return this.orderPlacementSource;
    }

    public String getOutstandingHoldAmount() {
        return this.outstandingHoldAmount;
    }

    public boolean isLiquidation() {
        return this.liquidation;
    }

    public String getLastFillTime() {
        return this.lastFillTime;
    }

    public List<?> getEditHistory() {
        return this.editHistory;
    }

    public String getLeverage() {
        return this.leverage;
    }

    public MarginType getMarginType() {
        return this.marginType;
    }

    public String getRetailPortfolioId() {
        return this.retailPortfolioId;
    }

    public OrderConfiguration getOrderConfiguration() {
        return this.orderConfiguration;
    }

    @JsonProperty(value="order_id")
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    @JsonProperty(value="product_id")
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @JsonProperty(value="user_id")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setSide(Side side) {
        this.side = side;
    }

    @JsonProperty(value="client_order_id")
    public void setClOrdId(String clOrdId) {
        this.clOrdId = clOrdId;
    }

    public void setStatus(OrderStatus status) {
        this.status = status;
    }

    @JsonProperty(value="time_in_force")
    public void setTimeInForce(String timeInForce) {
        this.timeInForce = timeInForce;
    }

    @JsonProperty(value="created_time")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ")
    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    @JsonProperty(value="completion_percentage")
    public void setCompletionPercentage(String completionPercentage) {
        this.completionPercentage = completionPercentage;
    }

    @JsonProperty(value="filled_size")
    public void setCumQty(double cumQty) {
        this.cumQty = cumQty;
    }

    @JsonProperty(value="average_filled_price")
    public void setAverageFilledPrice(String averageFilledPrice) {
        this.averageFilledPrice = averageFilledPrice;
    }

    public void setFee(String fee) {
        this.fee = fee;
    }

    @JsonProperty(value="number_of_fills")
    public void setNumberOfFills(double numberOfFills) {
        this.numberOfFills = numberOfFills;
    }

    @JsonProperty(value="filled_value")
    public void setLastOrAvgPx(Double lastOrAvgPx) {
        this.lastOrAvgPx = lastOrAvgPx;
    }

    @JsonProperty(value="pending_cancel")
    public void setPendingCancel(boolean pendingCancel) {
        this.pendingCancel = pendingCancel;
    }

    @JsonProperty(value="size_in_quote")
    public void setSizeInQuote(boolean sizeInQuote) {
        this.sizeInQuote = sizeInQuote;
    }

    @JsonProperty(value="total_fees")
    public void setTotalFees(String totalFees) {
        this.totalFees = totalFees;
    }

    @JsonProperty(value="size_inclusive_of_fees")
    public void setSizeInclusiveOfFees(boolean sizeInclusiveOfFees) {
        this.sizeInclusiveOfFees = sizeInclusiveOfFees;
    }

    @JsonProperty(value="total_value_after_fees")
    public void setTotalValueAfterFees(String totalValueAfterFees) {
        this.totalValueAfterFees = totalValueAfterFees;
    }

    @JsonProperty(value="trigger_status")
    public void setTriggerStatus(String triggerStatus) {
        this.triggerStatus = triggerStatus;
    }

    @JsonProperty(value="order_type")
    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
    }

    @JsonProperty(value="reject_reason")
    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public void setSettled(boolean settled) {
        this.settled = settled;
    }

    @JsonProperty(value="product_type")
    public void setProductType(String productType) {
        this.productType = productType;
    }

    @JsonProperty(value="reject_message")
    public void setRejectMessage(String rejectMessage) {
        this.rejectMessage = rejectMessage;
    }

    @JsonProperty(value="cancel_message")
    public void setCancelMessage(String cancelMessage) {
        this.cancelMessage = cancelMessage;
    }

    @JsonProperty(value="order_placement_source")
    public void setOrderPlacementSource(OrderPlacementSource orderPlacementSource) {
        this.orderPlacementSource = orderPlacementSource;
    }

    @JsonProperty(value="outstanding_hold_amount")
    public void setOutstandingHoldAmount(String outstandingHoldAmount) {
        this.outstandingHoldAmount = outstandingHoldAmount;
    }

    @JsonProperty(value="is_liquidation")
    public void setLiquidation(boolean liquidation) {
        this.liquidation = liquidation;
    }

    @JsonProperty(value="last_fill_time")
    public void setLastFillTime(String lastFillTime) {
        this.lastFillTime = lastFillTime;
    }

    @JsonProperty(value="edit_history")
    public void setEditHistory(List<?> editHistory) {
        this.editHistory = editHistory;
    }

    public void setLeverage(String leverage) {
        this.leverage = leverage;
    }

    @JsonProperty(value="margin_type")
    public void setMarginType(MarginType marginType) {
        this.marginType = marginType;
    }

    @JsonProperty(value="retail_portfolio_id")
    public void setRetailPortfolioId(String retailPortfolioId) {
        this.retailPortfolioId = retailPortfolioId;
    }

    @JsonProperty(value="order_configuration")
    public void setOrderConfiguration(OrderConfiguration orderConfiguration) {
        this.orderConfiguration = orderConfiguration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinbaseOrder)) {
            return false;
        }
        CoinbaseOrder other = (CoinbaseOrder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getCumQty(), other.getCumQty()) != 0) {
            return false;
        }
        if (Double.compare(this.getNumberOfFills(), other.getNumberOfFills()) != 0) {
            return false;
        }
        if (this.isPendingCancel() != other.isPendingCancel()) {
            return false;
        }
        if (this.isSizeInQuote() != other.isSizeInQuote()) {
            return false;
        }
        if (this.isSizeInclusiveOfFees() != other.isSizeInclusiveOfFees()) {
            return false;
        }
        if (this.isSettled() != other.isSettled()) {
            return false;
        }
        if (this.isLiquidation() != other.isLiquidation()) {
            return false;
        }
        Double this$lastOrAvgPx = this.getLastOrAvgPx();
        Double other$lastOrAvgPx = other.getLastOrAvgPx();
        if (this$lastOrAvgPx == null ? other$lastOrAvgPx != null : !((Object)this$lastOrAvgPx).equals(other$lastOrAvgPx)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        Side this$side = this.getSide();
        Side other$side = other.getSide();
        if (this$side == null ? other$side != null : !((Object)((Object)this$side)).equals((Object)other$side)) {
            return false;
        }
        String this$clOrdId = this.getClOrdId();
        String other$clOrdId = other.getClOrdId();
        if (this$clOrdId == null ? other$clOrdId != null : !this$clOrdId.equals(other$clOrdId)) {
            return false;
        }
        OrderStatus this$status = this.getStatus();
        OrderStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$timeInForce = this.getTimeInForce();
        String other$timeInForce = other.getTimeInForce();
        if (this$timeInForce == null ? other$timeInForce != null : !this$timeInForce.equals(other$timeInForce)) {
            return false;
        }
        String this$createdTime = this.getCreatedTime();
        String other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !this$createdTime.equals(other$createdTime)) {
            return false;
        }
        String this$completionPercentage = this.getCompletionPercentage();
        String other$completionPercentage = other.getCompletionPercentage();
        if (this$completionPercentage == null ? other$completionPercentage != null : !this$completionPercentage.equals(other$completionPercentage)) {
            return false;
        }
        String this$averageFilledPrice = this.getAverageFilledPrice();
        String other$averageFilledPrice = other.getAverageFilledPrice();
        if (this$averageFilledPrice == null ? other$averageFilledPrice != null : !this$averageFilledPrice.equals(other$averageFilledPrice)) {
            return false;
        }
        String this$fee = this.getFee();
        String other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !this$fee.equals(other$fee)) {
            return false;
        }
        String this$totalFees = this.getTotalFees();
        String other$totalFees = other.getTotalFees();
        if (this$totalFees == null ? other$totalFees != null : !this$totalFees.equals(other$totalFees)) {
            return false;
        }
        String this$totalValueAfterFees = this.getTotalValueAfterFees();
        String other$totalValueAfterFees = other.getTotalValueAfterFees();
        if (this$totalValueAfterFees == null ? other$totalValueAfterFees != null : !this$totalValueAfterFees.equals(other$totalValueAfterFees)) {
            return false;
        }
        String this$triggerStatus = this.getTriggerStatus();
        String other$triggerStatus = other.getTriggerStatus();
        if (this$triggerStatus == null ? other$triggerStatus != null : !this$triggerStatus.equals(other$triggerStatus)) {
            return false;
        }
        OrderType this$orderType = this.getOrderType();
        OrderType other$orderType = other.getOrderType();
        if (this$orderType == null ? other$orderType != null : !((Object)((Object)this$orderType)).equals((Object)other$orderType)) {
            return false;
        }
        String this$rejectReason = this.getRejectReason();
        String other$rejectReason = other.getRejectReason();
        if (this$rejectReason == null ? other$rejectReason != null : !this$rejectReason.equals(other$rejectReason)) {
            return false;
        }
        String this$productType = this.getProductType();
        String other$productType = other.getProductType();
        if (this$productType == null ? other$productType != null : !this$productType.equals(other$productType)) {
            return false;
        }
        String this$rejectMessage = this.getRejectMessage();
        String other$rejectMessage = other.getRejectMessage();
        if (this$rejectMessage == null ? other$rejectMessage != null : !this$rejectMessage.equals(other$rejectMessage)) {
            return false;
        }
        String this$cancelMessage = this.getCancelMessage();
        String other$cancelMessage = other.getCancelMessage();
        if (this$cancelMessage == null ? other$cancelMessage != null : !this$cancelMessage.equals(other$cancelMessage)) {
            return false;
        }
        OrderPlacementSource this$orderPlacementSource = this.getOrderPlacementSource();
        OrderPlacementSource other$orderPlacementSource = other.getOrderPlacementSource();
        if (this$orderPlacementSource == null ? other$orderPlacementSource != null : !((Object)((Object)this$orderPlacementSource)).equals((Object)other$orderPlacementSource)) {
            return false;
        }
        String this$outstandingHoldAmount = this.getOutstandingHoldAmount();
        String other$outstandingHoldAmount = other.getOutstandingHoldAmount();
        if (this$outstandingHoldAmount == null ? other$outstandingHoldAmount != null : !this$outstandingHoldAmount.equals(other$outstandingHoldAmount)) {
            return false;
        }
        String this$lastFillTime = this.getLastFillTime();
        String other$lastFillTime = other.getLastFillTime();
        if (this$lastFillTime == null ? other$lastFillTime != null : !this$lastFillTime.equals(other$lastFillTime)) {
            return false;
        }
        List<?> this$editHistory = this.getEditHistory();
        List<?> other$editHistory = other.getEditHistory();
        if (this$editHistory == null ? other$editHistory != null : !((Object)this$editHistory).equals(other$editHistory)) {
            return false;
        }
        String this$leverage = this.getLeverage();
        String other$leverage = other.getLeverage();
        if (this$leverage == null ? other$leverage != null : !this$leverage.equals(other$leverage)) {
            return false;
        }
        MarginType this$marginType = this.getMarginType();
        MarginType other$marginType = other.getMarginType();
        if (this$marginType == null ? other$marginType != null : !((Object)((Object)this$marginType)).equals((Object)other$marginType)) {
            return false;
        }
        String this$retailPortfolioId = this.getRetailPortfolioId();
        String other$retailPortfolioId = other.getRetailPortfolioId();
        if (this$retailPortfolioId == null ? other$retailPortfolioId != null : !this$retailPortfolioId.equals(other$retailPortfolioId)) {
            return false;
        }
        OrderConfiguration this$orderConfiguration = this.getOrderConfiguration();
        OrderConfiguration other$orderConfiguration = other.getOrderConfiguration();
        return !(this$orderConfiguration == null ? other$orderConfiguration != null : !((Object)this$orderConfiguration).equals(other$orderConfiguration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CoinbaseOrder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $cumQty = Double.doubleToLongBits(this.getCumQty());
        result = result * 59 + (int)($cumQty >>> 32 ^ $cumQty);
        long $numberOfFills = Double.doubleToLongBits(this.getNumberOfFills());
        result = result * 59 + (int)($numberOfFills >>> 32 ^ $numberOfFills);
        result = result * 59 + (this.isPendingCancel() ? 79 : 97);
        result = result * 59 + (this.isSizeInQuote() ? 79 : 97);
        result = result * 59 + (this.isSizeInclusiveOfFees() ? 79 : 97);
        result = result * 59 + (this.isSettled() ? 79 : 97);
        result = result * 59 + (this.isLiquidation() ? 79 : 97);
        Double $lastOrAvgPx = this.getLastOrAvgPx();
        result = result * 59 + ($lastOrAvgPx == null ? 43 : ((Object)$lastOrAvgPx).hashCode());
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        Side $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : ((Object)((Object)$side)).hashCode());
        String $clOrdId = this.getClOrdId();
        result = result * 59 + ($clOrdId == null ? 43 : $clOrdId.hashCode());
        OrderStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $timeInForce = this.getTimeInForce();
        result = result * 59 + ($timeInForce == null ? 43 : $timeInForce.hashCode());
        String $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : $createdTime.hashCode());
        String $completionPercentage = this.getCompletionPercentage();
        result = result * 59 + ($completionPercentage == null ? 43 : $completionPercentage.hashCode());
        String $averageFilledPrice = this.getAverageFilledPrice();
        result = result * 59 + ($averageFilledPrice == null ? 43 : $averageFilledPrice.hashCode());
        String $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : $fee.hashCode());
        String $totalFees = this.getTotalFees();
        result = result * 59 + ($totalFees == null ? 43 : $totalFees.hashCode());
        String $totalValueAfterFees = this.getTotalValueAfterFees();
        result = result * 59 + ($totalValueAfterFees == null ? 43 : $totalValueAfterFees.hashCode());
        String $triggerStatus = this.getTriggerStatus();
        result = result * 59 + ($triggerStatus == null ? 43 : $triggerStatus.hashCode());
        OrderType $orderType = this.getOrderType();
        result = result * 59 + ($orderType == null ? 43 : ((Object)((Object)$orderType)).hashCode());
        String $rejectReason = this.getRejectReason();
        result = result * 59 + ($rejectReason == null ? 43 : $rejectReason.hashCode());
        String $productType = this.getProductType();
        result = result * 59 + ($productType == null ? 43 : $productType.hashCode());
        String $rejectMessage = this.getRejectMessage();
        result = result * 59 + ($rejectMessage == null ? 43 : $rejectMessage.hashCode());
        String $cancelMessage = this.getCancelMessage();
        result = result * 59 + ($cancelMessage == null ? 43 : $cancelMessage.hashCode());
        OrderPlacementSource $orderPlacementSource = this.getOrderPlacementSource();
        result = result * 59 + ($orderPlacementSource == null ? 43 : ((Object)((Object)$orderPlacementSource)).hashCode());
        String $outstandingHoldAmount = this.getOutstandingHoldAmount();
        result = result * 59 + ($outstandingHoldAmount == null ? 43 : $outstandingHoldAmount.hashCode());
        String $lastFillTime = this.getLastFillTime();
        result = result * 59 + ($lastFillTime == null ? 43 : $lastFillTime.hashCode());
        List<?> $editHistory = this.getEditHistory();
        result = result * 59 + ($editHistory == null ? 43 : ((Object)$editHistory).hashCode());
        String $leverage = this.getLeverage();
        result = result * 59 + ($leverage == null ? 43 : $leverage.hashCode());
        MarginType $marginType = this.getMarginType();
        result = result * 59 + ($marginType == null ? 43 : ((Object)((Object)$marginType)).hashCode());
        String $retailPortfolioId = this.getRetailPortfolioId();
        result = result * 59 + ($retailPortfolioId == null ? 43 : $retailPortfolioId.hashCode());
        OrderConfiguration $orderConfiguration = this.getOrderConfiguration();
        result = result * 59 + ($orderConfiguration == null ? 43 : ((Object)$orderConfiguration).hashCode());
        return result;
    }

    public String toString() {
        return "CoinbaseOrder(orderId=" + this.getOrderId() + ", symbol=" + this.getSymbol() + ", userId=" + this.getUserId() + ", side=" + this.getSide() + ", clOrdId=" + this.getClOrdId() + ", status=" + this.getStatus() + ", timeInForce=" + this.getTimeInForce() + ", createdTime=" + this.getCreatedTime() + ", completionPercentage=" + this.getCompletionPercentage() + ", cumQty=" + this.getCumQty() + ", averageFilledPrice=" + this.getAverageFilledPrice() + ", fee=" + this.getFee() + ", numberOfFills=" + this.getNumberOfFills() + ", lastOrAvgPx=" + this.getLastOrAvgPx() + ", pendingCancel=" + this.isPendingCancel() + ", sizeInQuote=" + this.isSizeInQuote() + ", totalFees=" + this.getTotalFees() + ", sizeInclusiveOfFees=" + this.isSizeInclusiveOfFees() + ", totalValueAfterFees=" + this.getTotalValueAfterFees() + ", triggerStatus=" + this.getTriggerStatus() + ", orderType=" + this.getOrderType() + ", rejectReason=" + this.getRejectReason() + ", settled=" + this.isSettled() + ", productType=" + this.getProductType() + ", rejectMessage=" + this.getRejectMessage() + ", cancelMessage=" + this.getCancelMessage() + ", orderPlacementSource=" + this.getOrderPlacementSource() + ", outstandingHoldAmount=" + this.getOutstandingHoldAmount() + ", liquidation=" + this.isLiquidation() + ", lastFillTime=" + this.getLastFillTime() + ", editHistory=" + this.getEditHistory() + ", leverage=" + this.getLeverage() + ", marginType=" + this.getMarginType() + ", retailPortfolioId=" + this.getRetailPortfolioId() + ", orderConfiguration=" + this.getOrderConfiguration() + ")";
    }
}

