/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.exchanges.a.specification.domain.AckStatus;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.ApiResponse;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.CoinbaseAck;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CreateAckResponse
extends ApiResponse<CoinbaseAck> {
    @JsonProperty(value="order_id")
    private String orderId;
    private boolean success;
    @JsonProperty(value="failure_reason")
    private String failureReason;
    @JsonProperty(value="error_response")
    private ErrorResponse errorResponse;
    @JsonProperty(value="error")
    private String error;
    @JsonProperty(value="message")
    private String message;

    public AckStatus getAckStatus() {
        return this.success ? AckStatus.SUCCESS : AckStatus.FAIL;
    }

    @Override
    public CoinbaseAck getResult() {
        CoinbaseAck coinbaseAck = CoinbaseAck.builder().orderId(this.orderId).success(this.success).failureReason(this.failureReason).build();
        return coinbaseAck;
    }

    @Override
    public String getErrorCode() {
        if (this.errorResponse != null) {
            return this.errorResponse.getPreviewFailureReason();
        }
        return this.error;
    }

    @Override
    public String getErrorMessage() {
        if (this.errorResponse != null) {
            return this.errorResponse.getMessage();
        }
        return this.message;
    }

    public String getOrderId() {
        return this.orderId;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public ErrorResponse getErrorResponse() {
        return this.errorResponse;
    }

    public String getError() {
        return this.error;
    }

    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="order_id")
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @JsonProperty(value="failure_reason")
    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    @JsonProperty(value="error_response")
    public void setErrorResponse(ErrorResponse errorResponse) {
        this.errorResponse = errorResponse;
    }

    @JsonProperty(value="error")
    public void setError(String error) {
        this.error = error;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateAckResponse)) {
            return false;
        }
        CreateAckResponse other = (CreateAckResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$failureReason = this.getFailureReason();
        String other$failureReason = other.getFailureReason();
        if (this$failureReason == null ? other$failureReason != null : !this$failureReason.equals(other$failureReason)) {
            return false;
        }
        ErrorResponse this$errorResponse = this.getErrorResponse();
        ErrorResponse other$errorResponse = other.getErrorResponse();
        if (this$errorResponse == null ? other$errorResponse != null : !((Object)this$errorResponse).equals(other$errorResponse)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CreateAckResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $failureReason = this.getFailureReason();
        result = result * 59 + ($failureReason == null ? 43 : $failureReason.hashCode());
        ErrorResponse $errorResponse = this.getErrorResponse();
        result = result * 59 + ($errorResponse == null ? 43 : ((Object)$errorResponse).hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CreateAckResponse(super=" + super.toString() + ", orderId=" + this.getOrderId() + ", success=" + this.isSuccess() + ", failureReason=" + this.getFailureReason() + ", errorResponse=" + this.getErrorResponse() + ", error=" + this.getError() + ", message=" + this.getMessage() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ErrorResponse {
        private String error;
        private String message;
        @JsonProperty(value="error_details")
        private String errorDetails;
        @JsonProperty(value="preview_failure_reason")
        private String previewFailureReason;

        public String getError() {
            return this.error;
        }

        public String getMessage() {
            return this.message;
        }

        public String getErrorDetails() {
            return this.errorDetails;
        }

        public String getPreviewFailureReason() {
            return this.previewFailureReason;
        }

        public void setError(String error) {
            this.error = error;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="error_details")
        public void setErrorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
        }

        @JsonProperty(value="preview_failure_reason")
        public void setPreviewFailureReason(String previewFailureReason) {
            this.previewFailureReason = previewFailureReason;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorResponse)) {
                return false;
            }
            ErrorResponse other = (ErrorResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$errorDetails = this.getErrorDetails();
            String other$errorDetails = other.getErrorDetails();
            if (this$errorDetails == null ? other$errorDetails != null : !this$errorDetails.equals(other$errorDetails)) {
                return false;
            }
            String this$previewFailureReason = this.getPreviewFailureReason();
            String other$previewFailureReason = other.getPreviewFailureReason();
            return !(this$previewFailureReason == null ? other$previewFailureReason != null : !this$previewFailureReason.equals(other$previewFailureReason));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ErrorResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $errorDetails = this.getErrorDetails();
            result = result * 59 + ($errorDetails == null ? 43 : $errorDetails.hashCode());
            String $previewFailureReason = this.getPreviewFailureReason();
            result = result * 59 + ($previewFailureReason == null ? 43 : $previewFailureReason.hashCode());
            return result;
        }

        public String toString() {
            return "CreateAckResponse.ErrorResponse(error=" + this.getError() + ", message=" + this.getMessage() + ", errorDetails=" + this.getErrorDetails() + ", previewFailureReason=" + this.getPreviewFailureReason() + ")";
        }

        public ErrorResponse() {
        }

        public ErrorResponse(String error, String message, String errorDetails, String previewFailureReason) {
            this.error = error;
            this.message = message;
            this.errorDetails = errorDetails;
            this.previewFailureReason = previewFailureReason;
        }
    }
}

