/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.coinbase.api.v3.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.OutboundMessage;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.CoinbaseChannel;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.OutboundMessageType;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CoinbaseOutboundMessage
implements OutboundMessage {
    @JsonIgnore
    @NonNull
    protected OutboundMessage.MessageType messageType;
    private OutboundMessageType type;
    private CoinbaseChannel channel;
    private String jwt;
    @JsonProperty(value="product_ids")
    private List<String> productIds;

    public CoinbaseOutboundMessage(@NonNull OutboundMessage.MessageType messageType) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        this.messageType = messageType;
        if (messageType == OutboundMessage.MessageType.SUBSCRIPTION) {
            this.type = OutboundMessageType.subscribe;
        } else if (messageType == OutboundMessage.MessageType.UNSUBSCRIBE) {
            this.type = OutboundMessageType.unsubscribe;
        }
    }

    public static CoinbaseOutboundMessage subscribePrivate(CoinbaseChannel channel, List<String> productIds, String jwt) {
        return CoinbaseOutboundMessage.request(OutboundMessage.MessageType.SUBSCRIPTION, channel, productIds, jwt);
    }

    public static CoinbaseOutboundMessage subscribePublic(CoinbaseChannel channel, List<String> productIds) {
        return CoinbaseOutboundMessage.request(OutboundMessage.MessageType.SUBSCRIPTION, channel, productIds);
    }

    public static CoinbaseOutboundMessage unsubscribe(CoinbaseChannel channel, List<String> productIds) {
        return CoinbaseOutboundMessage.request(OutboundMessage.MessageType.UNSUBSCRIBE, channel, productIds);
    }

    private static CoinbaseOutboundMessage request(OutboundMessage.MessageType type, CoinbaseChannel channel, List<String> productIds) {
        return CoinbaseOutboundMessage.request(type, channel, productIds, null);
    }

    private static CoinbaseOutboundMessage request(OutboundMessage.MessageType type, CoinbaseChannel channel, List<String> productIds, String jwt) {
        CoinbaseOutboundMessage request = new CoinbaseOutboundMessage(type);
        request.setChannel(channel);
        request.setProductIds(productIds);
        request.setJwt(jwt);
        return request;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinbaseOutboundMessage)) {
            return false;
        }
        CoinbaseOutboundMessage other = (CoinbaseOutboundMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OutboundMessage.MessageType this$messageType = this.getMessageType();
        OutboundMessage.MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
            return false;
        }
        OutboundMessageType this$type = this.getType();
        OutboundMessageType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        CoinbaseChannel this$channel = this.getChannel();
        CoinbaseChannel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)((Object)this$channel)).equals((Object)other$channel)) {
            return false;
        }
        String this$jwt = this.getJwt();
        String other$jwt = other.getJwt();
        if (this$jwt == null ? other$jwt != null : !this$jwt.equals(other$jwt)) {
            return false;
        }
        List<String> this$productIds = this.getProductIds();
        List<String> other$productIds = other.getProductIds();
        return !(this$productIds == null ? other$productIds != null : !((Object)this$productIds).equals(other$productIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CoinbaseOutboundMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OutboundMessage.MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        OutboundMessageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        CoinbaseChannel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)((Object)$channel)).hashCode());
        String $jwt = this.getJwt();
        result = result * 59 + ($jwt == null ? 43 : $jwt.hashCode());
        List<String> $productIds = this.getProductIds();
        result = result * 59 + ($productIds == null ? 43 : ((Object)$productIds).hashCode());
        return result;
    }

    @Override
    @NonNull
    public OutboundMessage.MessageType getMessageType() {
        return this.messageType;
    }

    public OutboundMessageType getType() {
        return this.type;
    }

    public CoinbaseChannel getChannel() {
        return this.channel;
    }

    public String getJwt() {
        return this.jwt;
    }

    public List<String> getProductIds() {
        return this.productIds;
    }

    @JsonIgnore
    public void setMessageType(@NonNull OutboundMessage.MessageType messageType) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        this.messageType = messageType;
    }

    public void setType(OutboundMessageType type) {
        this.type = type;
    }

    public void setChannel(CoinbaseChannel channel) {
        this.channel = channel;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    @JsonProperty(value="product_ids")
    public void setProductIds(List<String> productIds) {
        this.productIds = productIds;
    }

    public String toString() {
        return "CoinbaseOutboundMessage(super=" + super.toString() + ", messageType=" + this.getMessageType() + ", type=" + this.getType() + ", channel=" + this.getChannel() + ", jwt=" + this.getJwt() + ", productIds=" + this.getProductIds() + ")";
    }
}

