/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.coinbase.api.v3.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.common.stream.managed.MarketData;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.stream.AbstractCoinbaseInboundMessage;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.stream.Level2MarketDataMessage;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.CoinbaseChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Level1MarketDataMessage
extends AbstractCoinbaseInboundMessage<MarketDataEvent>
implements MarketData {
    private static final Logger LOGGER = LoggerFactory.getLogger(Level2MarketDataMessage.class);
    private static final DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'");
    @JsonIgnore
    private boolean isSnapshot = true;

    public Level1MarketDataMessage() {
        this.messageType = InboundMessage.MessageType.DATA;
    }

    @Override
    public String getTopic() {
        return String.format("%s:%s", CoinbaseChannel.ticker.name(), ((MarketDataEvent)this.events.get((int)0)).tickers.get((int)0).productId);
    }

    @Override
    @JsonIgnore
    public Long getSeqNo() {
        return this.getSeqNum();
    }

    @Override
    @JsonIgnore
    public Long getTimestamp() {
        try {
            return dateformat.parse(this.getTs()).getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean hasData() {
        return this.events != null;
    }

    @Override
    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    @JsonIgnore
    public void setSnapshot(boolean isSnapshot) {
        this.isSnapshot = isSnapshot;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Level1MarketDataMessage)) {
            return false;
        }
        Level1MarketDataMessage other = (Level1MarketDataMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isSnapshot() == other.isSnapshot();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Level1MarketDataMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSnapshot() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "Level1MarketDataMessage(super=" + super.toString() + ", isSnapshot=" + this.isSnapshot() + ")";
    }

    public static class MarketDataEvent {
        private String type;
        private List<MarketData> tickers;

        public String getType() {
            return this.type;
        }

        public List<MarketData> getTickers() {
            return this.tickers;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setTickers(List<MarketData> tickers) {
            this.tickers = tickers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MarketDataEvent)) {
                return false;
            }
            MarketDataEvent other = (MarketDataEvent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            List<MarketData> this$tickers = this.getTickers();
            List<MarketData> other$tickers = other.getTickers();
            return !(this$tickers == null ? other$tickers != null : !((Object)this$tickers).equals(other$tickers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MarketDataEvent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            List<MarketData> $tickers = this.getTickers();
            result = result * 59 + ($tickers == null ? 43 : ((Object)$tickers).hashCode());
            return result;
        }

        public String toString() {
            return "Level1MarketDataMessage.MarketDataEvent(type=" + this.getType() + ", tickers=" + this.getTickers() + ")";
        }

        public static class MarketData {
            @JsonProperty(value="type")
            private String type;
            @JsonProperty(value="sequence")
            private String sequence;
            @JsonProperty(value="product_id")
            private String productId;
            @JsonProperty(value="price")
            private Double price;
            @JsonProperty(value="volume_24_h")
            private Double volume24h;
            @JsonProperty(value="low_24_h")
            private Double low24h;
            @JsonProperty(value="high_24_h")
            private Double high24h;
            @JsonProperty(value="low_52_w")
            private Double low52jh;
            @JsonProperty(value="high_52_w")
            private Double high52jh;
            @JsonProperty(value="price_percent_chg_24_h")
            private Double pricePctChg24h;
            @JsonProperty(value="best_bid")
            private Double bidPrice;
            @JsonProperty(value="best_ask")
            private Double askPrice;
            @JsonProperty(value="best_bid_quantity")
            private Double bidQty;
            @JsonProperty(value="best_ask_quantity")
            private Double askQty;

            public String getType() {
                return this.type;
            }

            public String getSequence() {
                return this.sequence;
            }

            public String getProductId() {
                return this.productId;
            }

            public Double getPrice() {
                return this.price;
            }

            public Double getVolume24h() {
                return this.volume24h;
            }

            public Double getLow24h() {
                return this.low24h;
            }

            public Double getHigh24h() {
                return this.high24h;
            }

            public Double getLow52jh() {
                return this.low52jh;
            }

            public Double getHigh52jh() {
                return this.high52jh;
            }

            public Double getPricePctChg24h() {
                return this.pricePctChg24h;
            }

            public Double getBidPrice() {
                return this.bidPrice;
            }

            public Double getAskPrice() {
                return this.askPrice;
            }

            public Double getBidQty() {
                return this.bidQty;
            }

            public Double getAskQty() {
                return this.askQty;
            }

            @JsonProperty(value="type")
            public void setType(String type) {
                this.type = type;
            }

            @JsonProperty(value="sequence")
            public void setSequence(String sequence2) {
                this.sequence = sequence2;
            }

            @JsonProperty(value="product_id")
            public void setProductId(String productId) {
                this.productId = productId;
            }

            @JsonProperty(value="price")
            public void setPrice(Double price) {
                this.price = price;
            }

            @JsonProperty(value="volume_24_h")
            public void setVolume24h(Double volume24h) {
                this.volume24h = volume24h;
            }

            @JsonProperty(value="low_24_h")
            public void setLow24h(Double low24h) {
                this.low24h = low24h;
            }

            @JsonProperty(value="high_24_h")
            public void setHigh24h(Double high24h) {
                this.high24h = high24h;
            }

            @JsonProperty(value="low_52_w")
            public void setLow52jh(Double low52jh) {
                this.low52jh = low52jh;
            }

            @JsonProperty(value="high_52_w")
            public void setHigh52jh(Double high52jh) {
                this.high52jh = high52jh;
            }

            @JsonProperty(value="price_percent_chg_24_h")
            public void setPricePctChg24h(Double pricePctChg24h) {
                this.pricePctChg24h = pricePctChg24h;
            }

            @JsonProperty(value="best_bid")
            public void setBidPrice(Double bidPrice) {
                this.bidPrice = bidPrice;
            }

            @JsonProperty(value="best_ask")
            public void setAskPrice(Double askPrice) {
                this.askPrice = askPrice;
            }

            @JsonProperty(value="best_bid_quantity")
            public void setBidQty(Double bidQty) {
                this.bidQty = bidQty;
            }

            @JsonProperty(value="best_ask_quantity")
            public void setAskQty(Double askQty) {
                this.askQty = askQty;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MarketData)) {
                    return false;
                }
                MarketData other = (MarketData)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Double this$price = this.getPrice();
                Double other$price = other.getPrice();
                if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
                    return false;
                }
                Double this$volume24h = this.getVolume24h();
                Double other$volume24h = other.getVolume24h();
                if (this$volume24h == null ? other$volume24h != null : !((Object)this$volume24h).equals(other$volume24h)) {
                    return false;
                }
                Double this$low24h = this.getLow24h();
                Double other$low24h = other.getLow24h();
                if (this$low24h == null ? other$low24h != null : !((Object)this$low24h).equals(other$low24h)) {
                    return false;
                }
                Double this$high24h = this.getHigh24h();
                Double other$high24h = other.getHigh24h();
                if (this$high24h == null ? other$high24h != null : !((Object)this$high24h).equals(other$high24h)) {
                    return false;
                }
                Double this$low52jh = this.getLow52jh();
                Double other$low52jh = other.getLow52jh();
                if (this$low52jh == null ? other$low52jh != null : !((Object)this$low52jh).equals(other$low52jh)) {
                    return false;
                }
                Double this$high52jh = this.getHigh52jh();
                Double other$high52jh = other.getHigh52jh();
                if (this$high52jh == null ? other$high52jh != null : !((Object)this$high52jh).equals(other$high52jh)) {
                    return false;
                }
                Double this$pricePctChg24h = this.getPricePctChg24h();
                Double other$pricePctChg24h = other.getPricePctChg24h();
                if (this$pricePctChg24h == null ? other$pricePctChg24h != null : !((Object)this$pricePctChg24h).equals(other$pricePctChg24h)) {
                    return false;
                }
                Double this$bidPrice = this.getBidPrice();
                Double other$bidPrice = other.getBidPrice();
                if (this$bidPrice == null ? other$bidPrice != null : !((Object)this$bidPrice).equals(other$bidPrice)) {
                    return false;
                }
                Double this$askPrice = this.getAskPrice();
                Double other$askPrice = other.getAskPrice();
                if (this$askPrice == null ? other$askPrice != null : !((Object)this$askPrice).equals(other$askPrice)) {
                    return false;
                }
                Double this$bidQty = this.getBidQty();
                Double other$bidQty = other.getBidQty();
                if (this$bidQty == null ? other$bidQty != null : !((Object)this$bidQty).equals(other$bidQty)) {
                    return false;
                }
                Double this$askQty = this.getAskQty();
                Double other$askQty = other.getAskQty();
                if (this$askQty == null ? other$askQty != null : !((Object)this$askQty).equals(other$askQty)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$sequence = this.getSequence();
                String other$sequence = other.getSequence();
                if (this$sequence == null ? other$sequence != null : !this$sequence.equals(other$sequence)) {
                    return false;
                }
                String this$productId = this.getProductId();
                String other$productId = other.getProductId();
                return !(this$productId == null ? other$productId != null : !this$productId.equals(other$productId));
            }

            protected boolean canEqual(Object other) {
                return other instanceof MarketData;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Double $price = this.getPrice();
                result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
                Double $volume24h = this.getVolume24h();
                result = result * 59 + ($volume24h == null ? 43 : ((Object)$volume24h).hashCode());
                Double $low24h = this.getLow24h();
                result = result * 59 + ($low24h == null ? 43 : ((Object)$low24h).hashCode());
                Double $high24h = this.getHigh24h();
                result = result * 59 + ($high24h == null ? 43 : ((Object)$high24h).hashCode());
                Double $low52jh = this.getLow52jh();
                result = result * 59 + ($low52jh == null ? 43 : ((Object)$low52jh).hashCode());
                Double $high52jh = this.getHigh52jh();
                result = result * 59 + ($high52jh == null ? 43 : ((Object)$high52jh).hashCode());
                Double $pricePctChg24h = this.getPricePctChg24h();
                result = result * 59 + ($pricePctChg24h == null ? 43 : ((Object)$pricePctChg24h).hashCode());
                Double $bidPrice = this.getBidPrice();
                result = result * 59 + ($bidPrice == null ? 43 : ((Object)$bidPrice).hashCode());
                Double $askPrice = this.getAskPrice();
                result = result * 59 + ($askPrice == null ? 43 : ((Object)$askPrice).hashCode());
                Double $bidQty = this.getBidQty();
                result = result * 59 + ($bidQty == null ? 43 : ((Object)$bidQty).hashCode());
                Double $askQty = this.getAskQty();
                result = result * 59 + ($askQty == null ? 43 : ((Object)$askQty).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $sequence = this.getSequence();
                result = result * 59 + ($sequence == null ? 43 : $sequence.hashCode());
                String $productId = this.getProductId();
                result = result * 59 + ($productId == null ? 43 : $productId.hashCode());
                return result;
            }

            public String toString() {
                return "Level1MarketDataMessage.MarketDataEvent.MarketData(type=" + this.getType() + ", sequence=" + this.getSequence() + ", productId=" + this.getProductId() + ", price=" + this.getPrice() + ", volume24h=" + this.getVolume24h() + ", low24h=" + this.getLow24h() + ", high24h=" + this.getHigh24h() + ", low52jh=" + this.getLow52jh() + ", high52jh=" + this.getHigh52jh() + ", pricePctChg24h=" + this.getPricePctChg24h() + ", bidPrice=" + this.getBidPrice() + ", askPrice=" + this.getAskPrice() + ", bidQty=" + this.getBidQty() + ", askQty=" + this.getAskQty() + ")";
            }
        }
    }
}

