/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.coinbase.api.v3.domain.stream;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.common.stream.managed.MarketData;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.stream.AbstractCoinbaseInboundMessage;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.CoinbaseChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Level2MarketDataMessage
extends AbstractCoinbaseInboundMessage<MarketDataEvent>
implements MarketData {
    private static final Logger LOGGER = LoggerFactory.getLogger(Level2MarketDataMessage.class);
    private static final DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'");
    @JsonIgnore
    private boolean isSnapshot;

    public Level2MarketDataMessage() {
        this.messageType = InboundMessage.MessageType.DATA;
    }

    @Override
    public String getTopic() {
        return String.format("%s:%s", CoinbaseChannel.level2.name(), ((MarketDataEvent)this.events.get((int)0)).productId);
    }

    @Override
    public Long getSeqNo() {
        return this.getSeqNum();
    }

    @Override
    public Long getTimestamp() {
        try {
            return dateformat.parse(this.getTs()).getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean hasData() {
        return this.events != null;
    }

    @Override
    public boolean isSnapshot() {
        return ((MarketDataEvent)this.events.get(0)).getType().equals("snapshot");
    }

    @JsonIgnore
    public void setSnapshot(boolean isSnapshot) {
        this.isSnapshot = isSnapshot;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Level2MarketDataMessage)) {
            return false;
        }
        Level2MarketDataMessage other = (Level2MarketDataMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isSnapshot() == other.isSnapshot();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Level2MarketDataMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSnapshot() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "Level2MarketDataMessage(super=" + super.toString() + ", isSnapshot=" + this.isSnapshot() + ")";
    }

    public static class MarketDataEvent {
        private String type;
        @JsonProperty(value="product_id")
        private String productId;
        private List<MarketData> updates;

        public String getType() {
            return this.type;
        }

        public String getProductId() {
            return this.productId;
        }

        public List<MarketData> getUpdates() {
            return this.updates;
        }

        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="product_id")
        public void setProductId(String productId) {
            this.productId = productId;
        }

        public void setUpdates(List<MarketData> updates) {
            this.updates = updates;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MarketDataEvent)) {
                return false;
            }
            MarketDataEvent other = (MarketDataEvent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$productId = this.getProductId();
            String other$productId = other.getProductId();
            if (this$productId == null ? other$productId != null : !this$productId.equals(other$productId)) {
                return false;
            }
            List<MarketData> this$updates = this.getUpdates();
            List<MarketData> other$updates = other.getUpdates();
            return !(this$updates == null ? other$updates != null : !((Object)this$updates).equals(other$updates));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MarketDataEvent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $productId = this.getProductId();
            result = result * 59 + ($productId == null ? 43 : $productId.hashCode());
            List<MarketData> $updates = this.getUpdates();
            result = result * 59 + ($updates == null ? 43 : ((Object)$updates).hashCode());
            return result;
        }

        public String toString() {
            return "Level2MarketDataMessage.MarketDataEvent(type=" + this.getType() + ", productId=" + this.getProductId() + ", updates=" + this.getUpdates() + ")";
        }

        public static class MarketData {
            private String side;
            @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'")
            @JsonProperty(value="event_time")
            private String eventTime;
            @JsonProperty(value="price_level")
            private double priceLevel;
            @JsonProperty(value="new_quantity")
            private double newQuantity;

            public String getSide() {
                return this.side;
            }

            public String getEventTime() {
                return this.eventTime;
            }

            public double getPriceLevel() {
                return this.priceLevel;
            }

            public double getNewQuantity() {
                return this.newQuantity;
            }

            public void setSide(String side) {
                this.side = side;
            }

            @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'")
            @JsonProperty(value="event_time")
            public void setEventTime(String eventTime) {
                this.eventTime = eventTime;
            }

            @JsonProperty(value="price_level")
            public void setPriceLevel(double priceLevel) {
                this.priceLevel = priceLevel;
            }

            @JsonProperty(value="new_quantity")
            public void setNewQuantity(double newQuantity) {
                this.newQuantity = newQuantity;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MarketData)) {
                    return false;
                }
                MarketData other = (MarketData)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (Double.compare(this.getPriceLevel(), other.getPriceLevel()) != 0) {
                    return false;
                }
                if (Double.compare(this.getNewQuantity(), other.getNewQuantity()) != 0) {
                    return false;
                }
                String this$side = this.getSide();
                String other$side = other.getSide();
                if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
                    return false;
                }
                String this$eventTime = this.getEventTime();
                String other$eventTime = other.getEventTime();
                return !(this$eventTime == null ? other$eventTime != null : !this$eventTime.equals(other$eventTime));
            }

            protected boolean canEqual(Object other) {
                return other instanceof MarketData;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $priceLevel = Double.doubleToLongBits(this.getPriceLevel());
                result = result * 59 + (int)($priceLevel >>> 32 ^ $priceLevel);
                long $newQuantity = Double.doubleToLongBits(this.getNewQuantity());
                result = result * 59 + (int)($newQuantity >>> 32 ^ $newQuantity);
                String $side = this.getSide();
                result = result * 59 + ($side == null ? 43 : $side.hashCode());
                String $eventTime = this.getEventTime();
                result = result * 59 + ($eventTime == null ? 43 : $eventTime.hashCode());
                return result;
            }

            public String toString() {
                return "Level2MarketDataMessage.MarketDataEvent.MarketData(side=" + this.getSide() + ", eventTime=" + this.getEventTime() + ", priceLevel=" + this.getPriceLevel() + ", newQuantity=" + this.getNewQuantity() + ")";
            }
        }
    }
}

