/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.coinbase.api.v3.lib;

import estonlabs.cxtl.common.AbstractExchangeFactory;
import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.request.CancelRequest;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.request.CandleRequest;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.request.OrderQueryRequest;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.request.OrderRequest;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.CoinbaseTicker;
import estonlabs.cxtl.exchanges.coinbase.api.v3.lib.CoinbaseRestClient;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class CoinbaseExchangeFactory
extends AbstractExchangeFactory<OrderRequest, CancelRequest, OrderQueryRequest, CandleRequest, CoinbaseTicker, CoinbaseRestClient, CoinbaseExchangeFactory> {
    public static final URI PROD = URI.create("https://api.coinbase.com");
    public static final URI TEST_NET = URI.create("https://api.coinbase.com");
    private static final Map<EnvironmentType, List<URI>> ENVIRONMENTS = Map.of(EnvironmentType.PROD, List.of(PROD), EnvironmentType.TEST_NET, List.of(TEST_NET));
    private final URI baseUri;

    public CoinbaseExchangeFactory(URI baseUri) {
        super(Exchange.COINBASE, ENVIRONMENTS);
        this.baseUri = baseUri;
    }

    @Override
    public CoinbaseRestClient buildCex() {
        return this.buildCex(this.httpProxy);
    }

    @Override
    public CoinbaseRestClient buildCex(Proxy httpProxy) {
        return new CoinbaseRestClient(this.createJsonRestClient(this.baseUri, httpProxy), this.baseUri, this.metricsLogger);
    }

    @Override
    protected CoinbaseExchangeFactory me() {
        return this;
    }

    @Override
    public CoinbaseRestClient buildEdi() {
        return this.buildCex();
    }

    @Override
    public CoinbaseRestClient buildEdi(Proxy httpProxy) {
        return this.buildCex(httpProxy);
    }
}

