/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.coinbase.api.v3.lib;

import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.exception.CxtlApiException;
import estonlabs.cxtl.common.exception.ErrorCode;
import estonlabs.cxtl.common.http.Event;
import estonlabs.cxtl.common.http.JsonRestClient;
import estonlabs.cxtl.common.http.Method;
import estonlabs.cxtl.common.http.MetricsLogger;
import estonlabs.cxtl.common.http.RestClient;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.a.specification.domain.Order;
import estonlabs.cxtl.exchanges.a.specification.domain.Trade;
import estonlabs.cxtl.exchanges.a.specification.lib.Cex;
import estonlabs.cxtl.exchanges.a.specification.lib.ExchangeDataInterface;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.request.CancelRequest;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.request.CandleRequest;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.request.OrderQueryRequest;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.request.OrderRequest;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.ApiResponse;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.Balance;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.BalanceResponse;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.CancelAckResponse;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.Candle;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.CandleResponse;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.CoinbaseAck;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.CoinbaseOrder;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.CoinbaseTicker;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.CoinbaseTrade;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.CreateAckResponse;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.GetApiPagingResponse;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.OrderListResponse;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.OrderResponse;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.PagingRequest;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.Position;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.PositionResponse;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.TickerListResponse;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.response.TradeListResponse;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.ContractExpiryType;
import estonlabs.cxtl.exchanges.coinbase.api.v3.util.CoinbaseJWTGenerator;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CoinbaseRestClient
implements Cex<OrderRequest, CancelRequest, OrderQueryRequest>,
ExchangeDataInterface<CoinbaseTicker, CandleRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoinbaseRestClient.class);
    private static final String ORDERS_URL = "/api/v3/brokerage/orders";
    private static final String PRODUCTS_URL = "/api/v3/brokerage/market/products/%s/ticker";
    private static final String PUBLIC_PRODUCTS_URL = "/api/v3/brokerage/market/products";
    private static final String CANDLES_URL = "/api/v3/brokerage/market/products/%s/candles";
    private static final String POSITION_URL = "/api/v3/brokerage/cfm/positions";
    private static final String BALANCE_URL = "/api/v3/brokerage/accounts";
    private final RestClientAdapter client;

    public CoinbaseRestClient(JsonRestClient restClient, URI baseUri, MetricsLogger metricsLogger) {
        this.client = new RestClientAdapter(restClient, baseUri, metricsLogger);
    }

    @Override
    public Proxy getProxy() {
        return this.client.client.getProxy();
    }

    @Override
    public Exchange getExchange() {
        return Exchange.COINBASE;
    }

    @Override
    public Mono<? extends List<? extends Trade>> getLatestPublicTrades(AssetClass assetClass, String symbol) {
        return this.getLatestPublicTrades(assetClass, symbol, 10);
    }

    public Mono<List<CoinbaseTrade>> getLatestPublicTrades(AssetClass assetClass, String symbol, Integer limit) {
        String url = String.format(PRODUCTS_URL, symbol);
        OrderQueryRequest orderQueryReq = new OrderQueryRequest();
        orderQueryReq.setLimit(limit);
        return this.fetchTrades(url, orderQueryReq);
    }

    private Mono<List<CoinbaseTrade>> fetchTrades(String url, OrderQueryRequest query) {
        this.mapPerpAssetClass(query);
        return this.client.get(url, query, TradeListResponse.class).switchIfEmpty(Mono.just(List.of()));
    }

    @Override
    public AssetClass[] getSupportedAssetClasses() {
        return new AssetClass[]{AssetClass.SPOT, AssetClass.PERP, AssetClass.FUTURE};
    }

    @Override
    @NotNull
    public Mono<CoinbaseAck> placeOrder(@NotNull Credentials credentials, @NotNull OrderRequest order) {
        return this.client.post(credentials, ORDERS_URL, order, CreateAckResponse.class);
    }

    @Override
    @NotNull
    public Mono<CoinbaseAck> cancelOrder(@NotNull Credentials credentials, @NotNull CancelRequest request) {
        return this.client.post(credentials, "/api/v3/brokerage/orders/batch_cancel", request, CancelAckResponse.class);
    }

    @Override
    public Mono<List<Candle>> getOlhcv(CandleRequest request) {
        String url = String.format(CANDLES_URL, request.getSymbol());
        return this.client.get(url, request, CandleResponse.class).switchIfEmpty(Mono.just(List.of()));
    }

    @Override
    @NotNull
    public Mono<List<CoinbaseOrder>> getOrders(@NotNull Credentials credentials, OrderQueryRequest orderQueryRequest) {
        this.mapPerpAssetClass(orderQueryRequest);
        return this.client.get(credentials, "/api/v3/brokerage/orders/historical/batch", orderQueryRequest, OrderListResponse.class).switchIfEmpty(Mono.just(List.of()));
    }

    @Override
    public Mono<? extends Order> getOrder(Credentials credentials, OrderQueryRequest orderQueryRequest) {
        String orderId = orderQueryRequest.getOrderId();
        this.mapPerpAssetClass(orderQueryRequest);
        return this.client.get(credentials, "/api/v3/brokerage/orders/historical/" + orderId, OrderResponse.class);
    }

    @Override
    public Mono<Map<AssetClass, List<CoinbaseTicker>>> getTickers() {
        return Mono.zip(this.getTickers(AssetClass.SPOT), this.getTickers(AssetClass.PERP), this.getTickers(AssetClass.FUTURE)).map(tuple -> Map.of(AssetClass.SPOT, (List)tuple.getT1(), AssetClass.PERP, (List)tuple.getT2(), AssetClass.FUTURE, (List)tuple.getT3()));
    }

    public Mono<List<CoinbaseTicker>> getTickers(AssetClass assetClass) {
        OrderQueryRequest req = new OrderQueryRequest();
        req.setProductType(assetClass);
        this.mapPerpAssetClass(req);
        return this.client.get(PUBLIC_PRODUCTS_URL, req, TickerListResponse.class).doOnError(e -> LOGGER.error("Error fetching tickers", (Throwable)e)).switchIfEmpty(Mono.just(List.of()));
    }

    public Mono<List<Position>> getPositions(Credentials credentials) {
        return this.client.get(credentials, POSITION_URL, null, PositionResponse.class).switchIfEmpty(Mono.just(List.of()));
    }

    public Flux<List<Balance>> getBalances(Credentials credentials) {
        PagingRequest req = new PagingRequest();
        req.setLimit(250);
        return this.client.getFlux(credentials, BALANCE_URL, req, BalanceResponse.class).switchIfEmpty(Flux.just(List.of()));
    }

    private void mapPerpAssetClass(OrderQueryRequest req) {
        if (AssetClass.PERP == req.getProductType()) {
            req.setProductType(AssetClass.FUTURE);
            req.setContractExpiryType(ContractExpiryType.PERPETUAL);
        }
    }

    private static ErrorCode errorCode(String code) {
        return switch (code) {
            case "PREVIEW_INSUFFICIENT_LEDGER_BALANCE", "PREVIEW_INSUFFICIENT_FUNDS_FOR_FUTURES", "PREVIEW_INSUFFICIENT_FUND" -> ErrorCode.INSUFFICIENT_BALANCE;
            case "PREVIEW_INVALID_PRICE_TOO_LARGE", "PREVIEW_INVALID_STOP_PRICE", "PREVIEW_INVALID_LIMIT_PRICE_POST_ONLY", "PREVIEW_INVALID_LIMIT_PRICE", "PREVIEW_INVALID_BRACKET_PRICES", "PREVIEW_INVALID_BRACKET_LIMIT_PRICE", "PREVIEW_INVALID_BRACKET_STOP_TRIGGER_PRICE", "PREVIEW_BRACKET_LIMIT_PRICE_OUT_OF_BOUNDS", "PREVIEW_STOP_TRIGGER_PRICE_OUT_OF_BOUNDS", "PREVIEW_INVALID_STOP_PRICE_PRECISION" -> ErrorCode.BAD_PX;
            case "PREVIEW_INVALID_QUOTE_SIZE_TOO_SMALL", "PREVIEW_INVALID_BASE_SIZE_TOO_SMALL", "PREVIEW_INVALID_BASE_SIZE_TOO_LARGE", "PREVIEW_INVALID_QUOTE_SIZE_PRECISION", "PREVIEW_INVALID_QUOTE_SIZE_TOO_LARGE" -> ErrorCode.INVALID_QTY;
            case "PREVIEW_UNTRADABLE_PRODUCT" -> ErrorCode.INVALID_SYMBOL;
            case "UNKNOWN_CANCEL_ORDER" -> ErrorCode.UNKNOWN_ORDER;
            case "INVALID_ARGUMENT" -> ErrorCode.INVALID_ARGUMENT;
            default -> ErrorCode.UNKNOWN_ERROR;
        };
    }

    public static class RestClientAdapter {
        private final RestClient client;
        private final MetricsLogger metricsLogger;
        private final URI baseUri;

        public RestClientAdapter(RestClient client, URI baseUri, MetricsLogger metricsLogger) {
            this.client = client;
            this.metricsLogger = metricsLogger;
            this.baseUri = baseUri;
        }

        public <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> get(String path, IN request, Class<RESPONSE> type) {
            return this.client.get(path, request, type).flatMap(this::handleResponse);
        }

        public <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> get(Credentials credentials, String path, IN request, Class<RESPONSE> type) {
            return this.client.get((Request.Builder builder, String json) -> this.addHeaders(credentials, builder, Method.GET, path), path, request, type).flatMap(this::handleResponse);
        }

        public <OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> get(Credentials credentials, String path, Class<RESPONSE> type) {
            return this.client.get((Request.Builder builder, String json) -> this.addHeaders(credentials, builder, Method.GET, path), path, type).flatMap(this::handleResponse);
        }

        public <IN extends PagingRequest, OUT, RESPONSE extends GetApiPagingResponse<OUT>> Flux<OUT> getFlux(String path, IN request, Class<RESPONSE> type) {
            return this.paging(req -> this.client.get(path, request, type).block(), request);
        }

        public <IN extends PagingRequest, OUT, RESPONSE extends GetApiPagingResponse<OUT>> Flux<OUT> getFlux(Credentials credentials, String path, IN request, Class<RESPONSE> type) {
            return this.paging(req -> this.client.get((Request.Builder builder, String json) -> this.addHeaders(credentials, builder, Method.GET, path), path, req, type).block(), request);
        }

        public <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> post(Credentials credentials, String path, IN request, Class<RESPONSE> type) {
            return this.client.postAsJson((builder, json) -> this.addHeaders(credentials, builder, Method.POST, path), path, request, type).flatMap(this::handleResponse);
        }

        public <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> delete(Credentials credentials, String path, IN request, Class<RESPONSE> type) {
            return this.client.deleteAsForm((builder, json) -> this.addHeaders(credentials, builder, Method.DELETE, path), path, request, type).flatMap(this::handleResponse);
        }

        private <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> handleResponse(Event<RESPONSE> event) {
            LOGGER.info("event resp {}", (Object)event.getResponseJson());
            ApiResponse response = (ApiResponse)event.getResponse();
            if (!response.isSuccess()) {
                this.metricsLogger.finishedError(event);
                return Mono.error(new CxtlApiException(response.getErrorMessage(), null, CoinbaseRestClient.errorCode(response.getErrorCode())));
            }
            return Mono.just(((ApiResponse)event.getResponse()).getResult()).doFinally(v -> this.metricsLogger.finishedSuccess(event));
        }

        public Request.Builder addHeaders(Credentials credentials, Request.Builder builder, Method method, String requestPath) {
            String jwt = this.generateJWT(credentials, method, requestPath);
            return builder.addHeader("Authorization", "Bearer " + jwt).addHeader("Host", this.baseUri.getHost()).addHeader("Content-Type", "application/json");
        }

        private String generateJWT(Credentials credentials, Method method, String requestPath) {
            String uri = method.name() + " " + this.baseUri.getHost() + requestPath;
            return CoinbaseJWTGenerator.generateJWT(credentials, uri);
        }

        private <IN extends PagingRequest, OUT, RESPONSE extends GetApiPagingResponse<OUT>> Flux<OUT> paging(Function<IN, Event<RESPONSE>> func, IN request) {
            return Flux.generate(() -> null, (state, sink2) -> {
                try {
                    if (state != null) {
                        request.setCursor(((GetApiPagingResponse)state.getResponse()).getCursor());
                    }
                    Event response = (Event)func.apply(request);
                    Mono result = this.handleResponse(response);
                    sink2.next(result.block());
                    if (!((GetApiPagingResponse)response.getResponse()).isHasNext()) {
                        sink2.complete();
                    }
                    return response;
                }
                catch (Exception e) {
                    sink2.error(e);
                    return null;
                }
            });
        }
    }
}

