/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.coinbase.api.v3.lib;

import estonlabs.cxtl.common.AbstractStreamFactory;
import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.codec.Codec;
import estonlabs.cxtl.common.codec.JacksonCodec;
import estonlabs.cxtl.common.stream.core.WebsocketConnection;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.stream.CoinbaseInboundContainer;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.stream.CoinbaseOutboundMessage;
import estonlabs.cxtl.exchanges.coinbase.api.v3.domain.types.CoinbaseChannel;
import estonlabs.cxtl.exchanges.coinbase.api.v3.util.CoinbaseJWTGenerator;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class CoinbaseStreamFactory
extends AbstractStreamFactory<CoinbaseOutboundMessage, CoinbaseInboundContainer, CoinbaseStreamFactory> {
    public static final URI PROD = URI.create("wss://advanced-trade-ws.coinbase.com");
    public static final URI TEST_NET = URI.create("wss://advanced-trade-ws.coinbase.com");
    public static final Map<EnvironmentType, List<URI>> ENVIRONMENTS = Map.of(EnvironmentType.PROD, List.of(PROD), EnvironmentType.TEST_NET, List.of(TEST_NET));
    private static final Codec<Object> CODEC = new JacksonCodec();
    private final URI baseUri;

    public CoinbaseStreamFactory() {
        this(PROD);
    }

    public CoinbaseStreamFactory(URI baseUri) {
        super(Exchange.COINBASE, CODEC, CoinbaseInboundContainer.class);
        this.baseUri = baseUri;
    }

    public static CoinbaseStreamFactory create(URI uri) {
        return new CoinbaseStreamFactory(uri);
    }

    public static CoinbaseStreamFactory prod() {
        return new CoinbaseStreamFactory(PROD);
    }

    @Override
    protected CoinbaseStreamFactory me() {
        return this;
    }

    public WebsocketConnection<CoinbaseOutboundMessage, CoinbaseInboundContainer> createStream() {
        String url = this.baseUri.toString();
        return this.newPublicWebsocket(URI.create(url), null);
    }

    public CoinbaseOutboundMessage subscribe(CoinbaseChannel channel, @NonNull Credentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        return this.subscribe(channel, Collections.emptyList(), credentials);
    }

    public CoinbaseOutboundMessage subscribe(CoinbaseChannel channel, List<String> productIds, @NonNull Credentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        if (channel.isPrivate()) {
            return CoinbaseOutboundMessage.subscribePrivate(channel, productIds, CoinbaseJWTGenerator.generateJWT(credentials));
        }
        return CoinbaseOutboundMessage.subscribePublic(channel, productIds);
    }

    public CoinbaseOutboundMessage unsubscribe(CoinbaseChannel channel) {
        return this.unsubscribe(channel, Collections.emptyList());
    }

    public CoinbaseOutboundMessage unsubscribe(CoinbaseChannel channel, List<String> productIds) {
        return CoinbaseOutboundMessage.unsubscribe(channel, productIds);
    }
}

