/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.coinbase.api.v3.util;

import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.security.HmacUtils;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.io.StringReader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.Date;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class CoinbaseJWTGenerator {
    public static String generateJWT(Credentials credentials) {
        return CoinbaseJWTGenerator.generateJWT(credentials, null);
    }

    public static String generateJWT(Credentials credentials, String uri) {
        SecureRandom random = new SecureRandom();
        byte[] nonceBytes = new byte[16];
        random.nextBytes(nonceBytes);
        String nonce = HmacUtils.bytesToHex(nonceBytes);
        Date now = new Date();
        Date expiration = new Date(now.getTime() + 120000L);
        try {
            PrivateKey privateKey = CoinbaseJWTGenerator.getPrivateKey(credentials.getSecretKey());
            return ((JwtBuilder)((JwtBuilder.BuilderHeader)((JwtBuilder.BuilderHeader)Jwts.builder().issuer("coinbase-cloud").notBefore(now).expiration(expiration).subject(credentials.getApiKey()).claim("uri", uri).header().add("kid", credentials.getApiKey())).add("nonce", nonce)).and()).signWith(privateKey).compact();
        }
        catch (io.jsonwebtoken.io.IOException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static PrivateKey getPrivateKey(String privateKey) throws io.jsonwebtoken.io.IOException, IOException {
        StringReader rdr = new StringReader(privateKey);
        Object parsed = new PEMParser(rdr).readObject();
        KeyPair pair = new JcaPEMKeyConverter().getKeyPair((PEMKeyPair)parsed);
        return pair.getPrivate();
    }
}

