/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.gateio.api.v4;

import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.exception.CxtlApiException;
import estonlabs.cxtl.common.exception.CxtlEventException;
import estonlabs.cxtl.common.exception.ErrorCode;
import estonlabs.cxtl.common.http.Event;
import estonlabs.cxtl.common.http.JsonRestClient;
import estonlabs.cxtl.common.http.Method;
import estonlabs.cxtl.common.http.MetricsLogger;
import estonlabs.cxtl.exchanges.a.specification.domain.Ack;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.a.specification.domain.Order;
import estonlabs.cxtl.exchanges.a.specification.domain.Ticker;
import estonlabs.cxtl.exchanges.a.specification.lib.Cex;
import estonlabs.cxtl.exchanges.a.specification.lib.ExchangeDataInterface;
import estonlabs.cxtl.exchanges.gateio.api.v4.CandleStickRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.Utils;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.AccountDetail;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.CancelRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.CandleStick;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.ErrorResponse;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.FuturesMarketTickerResponse;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.FuturesOrderResponse;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.FuturesPosition;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.GateIOTicker;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.GateIOTradeResponse;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.MarketTicker;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.MarketTickerRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.OrderBook;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.OrderBookRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.OrderQuery;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.OrderRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.delivery.DeliveryCancelRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.delivery.DeliveryCandleStick;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.delivery.DeliveryCandleStickRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.delivery.DeliveryMarketTickerRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.delivery.DeliveryOrderBookRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.delivery.DeliveryOrderQuery;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.delivery.DeliveryOrderRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.delivery.DeliveryTicker;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.DeliverySettle;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.ErrorLabel;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.PerpetualSettle;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.perpetual.PerpetualCancelRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.perpetual.PerpetualCandleStick;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.perpetual.PerpetualCandleStickRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.perpetual.PerpetualMarketTickerRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.perpetual.PerpetualOrderBookRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.perpetual.PerpetualOrderQuery;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.perpetual.PerpetualOrderRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.perpetual.PerpetualTicker;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotAccount;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotCancelRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotCandleStick;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotCandleStickRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotMarketTickerRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotMarketTickerResponse;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotOpenOrders;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotOrderBookRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotOrderQuery;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotOrderRequest;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotOrderResponse;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotTicker;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.TradeRequest;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GateIOCex
implements Cex<OrderRequest, CancelRequest, OrderQuery>,
ExchangeDataInterface<GateIOTicker, CandleStickRequest> {
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse("application/json; charset=utf-8");
    private static final String PREFIX = "/api/v4";
    private final JsonRestClient client;
    private final MetricsLogger metricsLogger;
    private final Pattern ORDER_TOO_LARGE_MSG = Pattern.compile("Your order size \\d+\\.\\d+ \\w+ is too large\\. The maximum is \\d+ \\w+");
    private final Pattern ORDER_INVALID_QTY_MSG = Pattern.compile("Invalid amount, \\d+\\.\\d+E[+-]?\\d+");
    private final Pattern ORDER_INVALID_PARAM_SIZE_MSG = Pattern.compile("Invalid request parameter `size` value: \\d+(\\.\\d+)?[eE][+-]?\\d+");

    public GateIOCex(JsonRestClient restClient, MetricsLogger metricsLogger) {
        this.client = restClient;
        this.metricsLogger = metricsLogger;
    }

    @Override
    public Proxy getProxy() {
        return this.client.getProxy();
    }

    @Override
    public Mono<List<GateIOTradeResponse>> getLatestPublicTrades(AssetClass assetClass, String symbol) {
        if (assetClass == AssetClass.SPOT) {
            TradeRequest tradeRequest = new TradeRequest().setCurrencyPair(symbol);
            return this.handleResponse(this.client.getMany("/spot/trades", tradeRequest, GateIOTradeResponse.class));
        }
        return Mono.error(new Exception("The exchange doesn't provide last trades for " + assetClass));
    }

    private <T extends Ticker, S extends Enum<S>> Mono<List<T>> getTickersForSettle(Class<S> settleClass, String path, Class<T> tickerClass) {
        Flux<Enum> settleFlux = Flux.fromArray((Enum[])settleClass.getEnumConstants());
        return settleFlux.flatMap(settle -> this.handleResponse(this.client.getMany(String.format(path, settle.name().toLowerCase()), tickerClass)).flatMapMany(Flux::fromIterable)).collectList();
    }

    @Override
    public Mono<Map<AssetClass, List<GateIOTicker>>> getTickers() {
        Mono<Map> spots = this.handleResponse(this.client.getMany("/api/v4/spot/currency_pairs", SpotTicker.class)).map(t -> Map.of(AssetClass.SPOT, t));
        Mono<Map> perps = this.getTickersForSettle(PerpetualSettle.class, "/api/v4/futures/%s/contracts", PerpetualTicker.class).map(t -> Map.of(AssetClass.PERP, t));
        Mono<Map> deliveries = this.getTickersForSettle(DeliverySettle.class, "/api/v4/delivery/%s/contracts", DeliveryTicker.class).map(t -> Map.of(AssetClass.FUTURE, t));
        return Mono.zip(spots, perps, deliveries).map(tuple -> {
            HashMap combinedMap = new HashMap();
            ((Map)tuple.getT1()).forEach((key, value) -> combinedMap.put(key, new ArrayList(value)));
            ((Map)tuple.getT2()).forEach((key, value) -> combinedMap.put(key, new ArrayList(value)));
            ((Map)tuple.getT3()).forEach((key, value) -> combinedMap.put(key, new ArrayList(value)));
            return combinedMap;
        });
    }

    public Mono<SpotTicker> getSpotTickerInfo(String currencyPair) {
        return this.handleResponse(this.client.get("/api/v4/spot/currency_pairs/" + currencyPair, SpotTicker.class));
    }

    public Mono<PerpetualTicker> getPerpetualInfo(PerpetualSettle settle, String contract) {
        return this.handleResponse(this.client.get("/api/v4/futures/" + settle.name().toLowerCase() + "contracts/" + contract, PerpetualTicker.class));
    }

    @Override
    public Mono<? extends List<? extends CandleStick>> getOlhcv(CandleStickRequest candleStickRequest) {
        Class responseType;
        Object url;
        String queryString = this.client.getCodec().toQueryString(candleStickRequest).toString();
        if (candleStickRequest instanceof SpotCandleStickRequest) {
            url = "/spot/candlesticks";
            responseType = SpotCandleStick.class;
        } else if (candleStickRequest instanceof PerpetualCandleStickRequest) {
            PerpetualCandleStickRequest perpRequest = (PerpetualCandleStickRequest)candleStickRequest;
            url = "/futures/" + perpRequest.getSettle().name().toLowerCase() + "/candlesticks";
            responseType = PerpetualCandleStick.class;
        } else if (candleStickRequest instanceof DeliveryCandleStickRequest) {
            DeliveryCandleStickRequest deliveryRequest = (DeliveryCandleStickRequest)candleStickRequest;
            url = "/delivery/" + deliveryRequest.getSettle().name().toLowerCase() + "/candlesticks";
            responseType = DeliveryCandleStick.class;
        } else {
            throw new IllegalArgumentException();
        }
        return this.handleResponse(this.client.parameterisedRequestMany(Method.GET, null, PREFIX + (String)url, queryString, null, responseType));
    }

    @Override
    public Exchange getExchange() {
        return Exchange.GATE_IO;
    }

    @Override
    public AssetClass[] getSupportedAssetClasses() {
        return new AssetClass[]{AssetClass.SPOT, AssetClass.PERP, AssetClass.FUTURE};
    }

    @Override
    public Mono<? extends Ack> placeOrder(Credentials credentials, OrderRequest order) {
        Class responseType;
        Object url;
        String payload = this.client.getCodec().toJson(order);
        if (order instanceof SpotOrderRequest) {
            url = "/spot/orders";
            responseType = SpotOrderResponse.class;
        } else if (order instanceof PerpetualOrderRequest) {
            PerpetualOrderRequest perpOrder = (PerpetualOrderRequest)order;
            url = "/futures/" + perpOrder.getSettle().name().toLowerCase() + "/orders";
            responseType = FuturesOrderResponse.class;
        } else if (order instanceof DeliveryOrderRequest) {
            DeliveryOrderRequest deliveryOrder = (DeliveryOrderRequest)order;
            url = "/delivery/" + deliveryOrder.getSettle().name().toLowerCase() + "/orders";
            responseType = FuturesOrderResponse.class;
        } else {
            throw new IllegalArgumentException();
        }
        String endpoint = PREFIX + (String)url;
        Map<String, String> signedHeaders = Utils.genSignRest(Method.POST, endpoint, null, payload, credentials);
        return this.handleResponse(this.client.parameterisedRequest(Method.POST, signedHeaders, endpoint, null, RequestBody.create(payload, JSON_MEDIA_TYPE), responseType));
    }

    @Override
    public Mono<? extends Ack> cancelOrder(Credentials credentials, CancelRequest request) {
        Class responseType;
        String url;
        String queryString = null;
        if (request instanceof SpotCancelRequest) {
            SpotCancelRequest spotCancel = (SpotCancelRequest)request;
            url = "/spot/orders/" + spotCancel.getOrderId();
            queryString = this.client.getCodec().toQueryString(request).toString();
            responseType = SpotOrderResponse.class;
        } else if (request instanceof PerpetualCancelRequest) {
            PerpetualCancelRequest perpCancel = (PerpetualCancelRequest)request;
            url = "/futures/" + perpCancel.getSettle().name().toLowerCase() + "/orders/" + perpCancel.getOrderId();
            responseType = FuturesOrderResponse.class;
        } else if (request instanceof DeliveryCancelRequest) {
            DeliveryCancelRequest deliveryCancel = (DeliveryCancelRequest)request;
            url = "/delivery/" + deliveryCancel.getSettle().name().toLowerCase() + "/orders/" + deliveryCancel.getOrderId();
            responseType = FuturesOrderResponse.class;
        } else {
            throw new IllegalArgumentException();
        }
        String endpoint = PREFIX + url;
        Map<String, String> signedHeaders = Utils.genSignRest(Method.DELETE, endpoint, queryString, null, credentials);
        return this.handleResponse(this.client.parameterisedRequest(Method.DELETE, signedHeaders, endpoint, queryString, null, responseType));
    }

    @Override
    public Mono<? extends List<? extends Order>> getOrders(Credentials credentials, OrderQuery orderQuery) {
        Object url;
        Class responseType;
        String queryString = this.client.getCodec().toQueryString(orderQuery).toString();
        if (orderQuery instanceof SpotOrderQuery) {
            responseType = SpotOrderResponse.class;
            url = "/spot/orders";
        } else {
            if (orderQuery instanceof PerpetualOrderQuery) {
                PerpetualOrderQuery perpetualQuery = (PerpetualOrderQuery)orderQuery;
                url = "/futures/" + perpetualQuery.getSettle().name().toLowerCase() + "/orders";
            } else if (orderQuery instanceof DeliveryOrderQuery) {
                DeliveryOrderQuery deliveryQuery = (DeliveryOrderQuery)orderQuery;
                url = "/futures/" + deliveryQuery.getSettle().name().toLowerCase() + "/orders";
            } else {
                throw new IllegalArgumentException();
            }
            responseType = FuturesOrderResponse.class;
        }
        String endpoint = PREFIX + (String)url;
        Map<String, String> signedHeaders = Utils.genSignRest(Method.GET, endpoint, queryString, null, credentials);
        return this.handleResponse(this.client.parameterisedRequestMany(Method.GET, signedHeaders, endpoint, queryString, null, responseType));
    }

    @Override
    public Mono<? extends Order> getOrder(Credentials credentials, OrderQuery orderQuery) {
        String url;
        Class responseType;
        String queryString = this.client.getCodec().toQueryString(orderQuery).toString();
        if (orderQuery instanceof SpotOrderQuery) {
            SpotOrderQuery spotQuery = (SpotOrderQuery)orderQuery;
            responseType = SpotOrderResponse.class;
            url = "/spot/orders/" + spotQuery.getOrderId();
        } else {
            if (orderQuery instanceof PerpetualOrderQuery) {
                PerpetualOrderQuery perpetualQuery = (PerpetualOrderQuery)orderQuery;
                url = "/futures/" + perpetualQuery.getSettle().name().toLowerCase() + "/orders/" + perpetualQuery.getOrderId();
            } else if (orderQuery instanceof DeliveryOrderQuery) {
                DeliveryOrderQuery deliveryQuery = (DeliveryOrderQuery)orderQuery;
                url = "/futures/" + deliveryQuery.getSettle().name().toLowerCase() + "/orders/" + deliveryQuery.getOrderId();
            } else {
                throw new IllegalArgumentException();
            }
            responseType = FuturesOrderResponse.class;
        }
        String endpoint = PREFIX + url;
        Map<String, String> signedHeaders = Utils.genSignRest(Method.GET, endpoint, queryString, null, credentials);
        return this.handleResponse(this.client.parameterisedRequest(Method.GET, signedHeaders, endpoint, queryString, null, responseType));
    }

    public Mono<List<SpotAccount>> getSpotAccounts(Credentials credentials) {
        String url = "/api/v4/spot/accounts";
        Map<String, String> g = Utils.genSignRest(Method.GET, url, null, null, credentials);
        return this.handleResponse(this.client.parameterisedRequestMany(Method.GET, g, url, null, null, SpotAccount.class));
    }

    public Mono<List<FuturesPosition>> getPerpetualPositions(PerpetualSettle settle, Credentials credentials) {
        String url = "/api/v4/futures/" + settle.name().toLowerCase() + "/positions";
        Map<String, String> g = Utils.genSignRest(Method.GET, url, null, null, credentials);
        return this.handleResponse(this.client.parameterisedRequestMany(Method.GET, g, url, null, null, FuturesPosition.class));
    }

    @NonNull
    private <T> Mono<T> onError(Throwable t) {
        if (t instanceof CxtlEventException) {
            CxtlEventException e = (CxtlEventException)t;
            this.metricsLogger.finishedError(e.getEvent());
            ErrorResponse response = this.client.getCodec().quietFromJson(e.getEvent().getResponseJson(), ErrorResponse.class);
            if (response != null) {
                return Mono.error(new CxtlApiException(response.getMessage(), response.getLabel().name(), this.mapErrorCode(response.getLabel(), response.getMessage())));
            }
        }
        return Mono.error(new CxtlApiException(t.getMessage(), "UNKNOWN", ErrorCode.UNKNOWN_ERROR));
    }

    private ErrorCode mapErrorCode(ErrorLabel label, String message) {
        if (label == ErrorLabel.INVALID_PARAM_VALUE && (this.ORDER_TOO_LARGE_MSG.matcher(message).matches() || this.ORDER_INVALID_QTY_MSG.matcher(message).matches() || this.ORDER_INVALID_PARAM_SIZE_MSG.matcher(message).matches())) {
            return ErrorCode.INVALID_QTY;
        }
        switch (label) {
            case INVALID_PARAM_VALUE: 
            case INVALID_PROTOCOL: 
            case INVALID_REQUEST_BODY: 
            case MISSING_REQUIRED_PARAM: 
            case INVALID_CONTENT_TYPE: 
            case NOT_ACCEPTABLE: 
            case METHOD_NOT_ALLOWED: 
            case BAD_REQUEST: 
            case NOT_FOUND: 
            case INVALID_CREDENTIALS: 
            case INVALID_KEY: 
            case IP_FORBIDDEN: 
            case READ_ONLY: 
            case INVALID_SIGNATURE: 
            case MISSING_REQUIRED_HEADER: 
            case REQUEST_EXPIRED: 
            case ACCOUNT_LOCKED: 
            case FORBIDDEN: 
            case DUPLICATE_REQUEST: 
            case ORDER_EXISTS: 
            case INVALID_CLIENT_ORDER_ID: 
            case REPEATED_CREATION: 
            case USER_NOT_FOUND: 
            case CONTRACT_NO_COUNTER: 
            case CONTRACT_NOT_FOUND: 
            case MARGIN_NOT_SUPPORTED: {
                return ErrorCode.INVALID_ARGUMENT;
            }
            case INVALID_PRECISION: 
            case PRICE_TOO_DEVIATED: 
            case PRICE_OVER_LIQUIDATION: 
            case PRICE_OVER_BANKRUPT: {
                return ErrorCode.BAD_PX;
            }
            case INSUFFICIENT_AVAILABLE: 
            case BALANCE_NOT_ENOUGH: 
            case FUTURES_BALANCE_NOT_ENOUGH: 
            case RISK_LIMIT_EXCEEDED: 
            case LIQUIDATE_IMMEDIATELY: 
            case MARGIN_BALANCE_NOT_ENOUGH: 
            case POOL_BALANCE_NOT_ENOUGH: 
            case COL_NOT_ENOUGH: 
            case ERR_BALANCE_NOT_ENOUGH: {
                return ErrorCode.INSUFFICIENT_BALANCE;
            }
            case INVALID_CURRENCY: 
            case INVALID_CURRENCY_PAIR: {
                return ErrorCode.INVALID_SYMBOL;
            }
            case ORDER_NOT_FOUND: 
            case ORDER_NOT_FOUND_FUTURES: 
            case ORDER_NOT_OWNED: 
            case ORDER_NOT_EXIST: {
                return ErrorCode.UNKNOWN_ORDER;
            }
            case QUANTITY_NOT_ENOUGH: 
            case AMOUNT_TOO_LITTLE: 
            case AMOUNT_TOO_MUCH: 
            case SIZE_TOO_LARGE: 
            case SIZE_TOO_SMALL: {
                return ErrorCode.INVALID_QTY;
            }
        }
        return ErrorCode.UNKNOWN_ERROR;
    }

    private <I> I onSuccess(Event<I> e) {
        this.metricsLogger.finishedSuccess(e);
        return e.getResponse();
    }

    private <T> Mono<T> handleResponse(Mono<Event<T>> response) {
        return response.map(this::onSuccess).onErrorResume(this::onError);
    }

    public Mono<? extends List<? extends MarketTicker>> getMarketTickers(MarketTickerRequest request) {
        Class responseType;
        Object url;
        String queryString = this.client.getCodec().toQueryString(request).toString();
        if (request instanceof SpotMarketTickerRequest) {
            url = "/spot/tickers";
            responseType = SpotMarketTickerResponse.class;
        } else if (request instanceof PerpetualMarketTickerRequest) {
            PerpetualMarketTickerRequest perpRequest = (PerpetualMarketTickerRequest)request;
            url = "/futures/" + perpRequest.getSettle().name().toLowerCase() + "/tickers";
            responseType = FuturesMarketTickerResponse.class;
        } else if (request instanceof DeliveryMarketTickerRequest) {
            DeliveryMarketTickerRequest deliveryRequest = (DeliveryMarketTickerRequest)request;
            url = "/delivery/" + deliveryRequest.getSettle().name().toLowerCase() + "/tickers";
            responseType = FuturesMarketTickerResponse.class;
        } else {
            throw new IllegalArgumentException();
        }
        return this.handleResponse(this.client.parameterisedRequestMany(Method.GET, null, PREFIX + (String)url, queryString, null, responseType));
    }

    public Mono<AccountDetail> getAccountDetail(Credentials credentials) {
        String endpoint = "/api/v4/account/detail";
        Map<String, String> signed = Utils.genSignRest(Method.GET, endpoint, null, null, credentials);
        return this.handleResponse(this.client.parameterisedRequest(Method.GET, signed, endpoint, null, null, AccountDetail.class));
    }

    public Mono<OrderBook> getOrderBook(OrderBookRequest request) {
        Object endpoint = null;
        String queryString = this.client.getCodec().toQueryString(request).toString();
        if (request instanceof SpotOrderBookRequest) {
            endpoint = "/spot/order_book";
        }
        if (request instanceof PerpetualOrderBookRequest) {
            PerpetualOrderBookRequest perpRequest = (PerpetualOrderBookRequest)request;
            endpoint = "/futures/" + perpRequest.getSettle().name().toLowerCase() + "/order_book";
        }
        if (request instanceof DeliveryOrderBookRequest) {
            DeliveryOrderBookRequest deliveryRequest = (DeliveryOrderBookRequest)request;
            endpoint = "/futures/" + deliveryRequest.getSettle().name().toLowerCase() + "/order_book";
        }
        return this.handleResponse(this.client.parameterisedRequest(Method.GET, null, PREFIX + (String)endpoint, queryString, null, OrderBook.class));
    }

    public Mono<List<SpotOpenOrders.OpenOrder>> getOpenSpotOrders(Credentials credentials) {
        String endpoint = "/api/v4/spot/open_orders";
        Map<String, String> signed = Utils.genSignRest(Method.GET, endpoint, null, null, credentials);
        return this.handleResponse(this.client.parameterisedRequestMany(Method.GET, signed, endpoint, null, null, SpotOpenOrders.class)).map(openOrdersList -> openOrdersList.stream().flatMap(openOrders -> openOrders.getOrders().stream()).collect(Collectors.toList()));
    }
}

