/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.gateio.api.v4;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import estonlabs.cxtl.common.stream.managed.AbstractInboundDeserializer;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.FuturesBalanceUpdate;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.FuturesPositionUpdate;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.FuturesUserTrade;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.FuturesWSOrder;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.GateIOInboundContainer;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.GateIOPong;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.OrderBook;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.SubscriptionConfirmation;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.UnsubscriptionConfirmation;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.WSTicker;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotBalanceUpdate;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotUserTrade;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.spot.SpotWSOrder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class GateIODeserializer
extends AbstractInboundDeserializer<GateIOInboundContainer> {
    public GateIODeserializer() {
        super(List.of(new GateIODeserializerTarget()));
    }

    @Override
    protected GateIOInboundContainer wrap(InboundMessage message) {
        return new GateIOInboundContainer(message);
    }

    static final class GateIODeserializerTarget
    implements AbstractInboundDeserializer.Target {
        private Class<? extends InboundMessage> matchedType;
        private static final Map<String, Class<? extends InboundMessage>> byChannel = Map.ofEntries(Map.entry("spot.book_ticker", WSTicker.class), Map.entry("spot.order_book_update", OrderBook.class), Map.entry("futures.book_ticker", WSTicker.class), Map.entry("futures.order_book_update", OrderBook.class), Map.entry("spot.orders", SpotWSOrder.class), Map.entry("futures.orders", FuturesWSOrder.class), Map.entry("spot.usertrades", SpotUserTrade.class), Map.entry("futures.usertrades", FuturesUserTrade.class), Map.entry("spot.balances", SpotBalanceUpdate.class), Map.entry("futures.balances", FuturesBalanceUpdate.class), Map.entry("futures.positions", FuturesPositionUpdate.class));
        private static final Map<String, Class<? extends InboundMessage>> byEvent = Map.of("subscribe", SubscriptionConfirmation.class, "unsubscribe", UnsubscriptionConfirmation.class);

        GateIODeserializerTarget() {
        }

        private boolean matchesAgainstMap(JsonNode root, String fieldName, Map<String, Class<? extends InboundMessage>> map) {
            String fieldVal = root.get(fieldName).asText();
            if (map.containsKey(fieldVal)) {
                this.matchedType = map.get(fieldVal);
                return true;
            }
            return false;
        }

        @Override
        public boolean matches(JsonNode root, ObjectMapper mapper) {
            String channel = root.get("channel").asText();
            if (channel.contains("pong")) {
                this.matchedType = GateIOPong.class;
                return true;
            }
            return this.matchesAgainstMap(root, "event", byEvent) || this.matchesAgainstMap(root, "channel", byChannel);
        }

        @Override
        @NonNull
        public Class<? extends InboundMessage> getType(JsonNode root, ObjectMapper mapper) throws IOException {
            return this.matchedType;
        }
    }
}

