/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.gateio.api.v4;

import estonlabs.cxtl.common.AbstractStreamFactory;
import estonlabs.cxtl.common.codec.Codec;
import estonlabs.cxtl.common.codec.JacksonCodec;
import estonlabs.cxtl.common.stream.core.WebsocketConnection;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.GateIOInboundContainer;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.GateIOOutboundMessage;
import java.net.URI;
import java.util.concurrent.TimeUnit;

public class GateIOStreamFactory
extends AbstractStreamFactory<GateIOOutboundMessage, GateIOInboundContainer, GateIOStreamFactory> {
    public static final URI SPOT_PROD = URI.create("wss://api.gateio.ws/ws/v4/");
    public static final URI PERP_PROD_USDT = URI.create("wss://fx-ws.gateio.ws/v4/ws/usdt");
    public static final URI PERP_PROD_BTC = URI.create("wss://fx-ws.gateio.ws/v4/ws/btc");
    public static final URI PERP_TEST_USDT = URI.create("wss://fx-ws-testnet.gateio.ws/v4/ws/usdt");
    public static final URI PERP_TEST_BTC = URI.create("wss://fx-ws-testnet.gateio.ws/v4/ws/btc");
    public static final URI DELIVERY_PROD_USDT = URI.create("wss://fx-ws.gateio.ws/v4/ws/delivery/usdt");
    public static final URI DELIVERY_TEST_USDT = URI.create("wss://fx-ws-testnet.gateio.ws/v4/ws/delivery/usdt");
    public static final URI DELIVERY_PROD_BTC = URI.create("wss://fx-ws.gateio.ws/v4/ws/delivery/btc");
    public static final URI DELIVERY_TEST_BTC = URI.create("wss://fx-ws-testnet.gateio.ws/v4/ws/delivery/btc");
    private static final Codec<Object> CODEC = new JacksonCodec();
    private final URI baseUri;
    private final AssetClass assetClass;

    public GateIOStreamFactory(URI baseUri, AssetClass assetClass) {
        super(Exchange.GATE_IO, CODEC, GateIOInboundContainer.class);
        this.baseUri = baseUri;
        this.assetClass = assetClass;
        this.ping(TimeUnit.SECONDS.toMillis(5L), () -> GateIOOutboundMessage.ping(System.currentTimeMillis() / 1000L, this.assetClass));
    }

    @Override
    protected GateIOStreamFactory me() {
        return this;
    }

    public WebsocketConnection<GateIOOutboundMessage, GateIOInboundContainer> createPublicStream() {
        return this.newPublicWebsocket(this.baseUri, null);
    }
}

