/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.gateio.api.v4;

import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.http.Method;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Utils {
    public static Map<String, String> genSignWs(String queryString, String key, String secret) {
        HashMap<String, String> headers2 = new HashMap<String, String>();
        String signature = Utils.hmacSHA512(secret, queryString);
        headers2.put("KEY", key);
        headers2.put("method", "api_key");
        headers2.put("SIGN", signature);
        return headers2;
    }

    public static Map<String, String> genSignRest(Method method, String url, String queryString, String payloadString, Credentials credentials) {
        String key = credentials.getApiKey();
        String secret = credentials.getSecretKey();
        HashMap<String, String> headers2 = new HashMap<String, String>();
        long timestamp = Instant.now().getEpochSecond();
        String hashedPayload = Utils.hashSHA512(payloadString == null ? "" : payloadString);
        String signatureString = method.name() + "\n" + url + "\n" + (queryString == null ? "" : queryString) + "\n" + hashedPayload + "\n" + timestamp;
        String signature = Utils.hmacSHA512(secret, signatureString);
        headers2.put("KEY", key);
        headers2.put("Timestamp", String.valueOf(timestamp));
        headers2.put("SIGN", signature);
        return headers2;
    }

    private static String hashSHA512(String data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        byte[] digest = md.digest(data.getBytes(StandardCharsets.UTF_8));
        return Utils.bytesToHex(digest);
    }

    private static String hmacSHA512(String key, String data) throws Exception {
        Mac mac = Mac.getInstance("HmacSHA512");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA512");
        mac.init(secretKeySpec);
        byte[] hmacData = mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
        return Utils.bytesToHex(hmacData);
    }

    private static String bytesToHex(byte[] bytes) {
        try (Formatter formatter = new Formatter();){
            for (byte b : bytes) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
    }

    public static String prefixByAssetClass(AssetClass assetClass, String channelName) {
        if (assetClass == AssetClass.SPOT) {
            return "spot." + channelName;
        }
        if (assetClass == AssetClass.FUTURE || assetClass == AssetClass.PERP) {
            return "futures." + channelName;
        }
        throw new IllegalArgumentException("Unsupported asset class " + assetClass);
    }
}

