/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.gateio.api.v4.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import estonlabs.cxtl.exchanges.a.specification.domain.AckStatus;
import estonlabs.cxtl.exchanges.a.specification.domain.SimpleOrderStatus;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.OrderResponse;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.AutoSize;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.FuturesOrderStatus;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.OrderCompletionStatus;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.StpAct;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.TimeInForce;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.deserializers.AutoSizeDeserializer;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.deserializers.FuturesOrderStatusDeserializer;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.deserializers.OrderCompletionStatusDeserializer;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.deserializers.TimeInForceDeserializer;
import java.math.BigDecimal;

public final class FuturesOrderResponse
implements OrderResponse {
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="user")
    private int user;
    @JsonProperty(value="create_time")
    private double createTime;
    @JsonProperty(value="finish_time")
    private Double finishTime;
    @JsonProperty(value="update_time")
    private Double updateTime;
    @JsonDeserialize(using=OrderCompletionStatusDeserializer.class)
    @JsonProperty(value="finish_as")
    private OrderCompletionStatus finishAs;
    @JsonDeserialize(using=FuturesOrderStatusDeserializer.class)
    @JsonProperty(value="status")
    private FuturesOrderStatus status;
    @JsonProperty(value="contract")
    private String contract;
    @JsonProperty(value="size")
    private long size;
    @JsonProperty(value="iceberg")
    private long iceberg;
    @JsonProperty(value="price")
    private String price;
    @JsonProperty(value="close")
    private boolean close;
    @JsonProperty(value="is_close")
    private boolean isClose;
    @JsonProperty(value="reduce_only")
    private boolean reduceOnly;
    @JsonProperty(value="is_reduce_only")
    private boolean isReduceOnly;
    @JsonProperty(value="is_liq")
    private boolean isLiq;
    @JsonDeserialize(using=TimeInForceDeserializer.class)
    @JsonProperty(value="tif")
    private TimeInForce tif;
    @JsonProperty(value="left")
    private long left;
    @JsonProperty(value="fill_price")
    private BigDecimal fillPrice;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="tkfr")
    private String tkfr;
    @JsonProperty(value="mkfr")
    private String mkfr;
    @JsonProperty(value="refu")
    private int refu;
    @JsonDeserialize(using=AutoSizeDeserializer.class)
    @JsonProperty(value="auto_size")
    private AutoSize autoSize;
    @JsonProperty(value="stp_id")
    private int stpId;
    @JsonProperty(value="stp_act")
    private StpAct stpAct;
    @JsonProperty(value="amend_text")
    private String amendText;
    @JsonProperty(value="biz_info")
    private String bizInfo;
    @JsonProperty(value="refr")
    private String refr;
    @JsonProperty(value="pnl")
    private String pnl;
    @JsonProperty(value="pnl_margin")
    private String pnlMargin;
    @JsonProperty(value="update_id")
    private Integer updateId;

    @Override
    public AckStatus getAckStatus() {
        return AckStatus.SUCCESS;
    }

    @Override
    public String getOrderId() {
        return String.valueOf(this.id);
    }

    @Override
    public String getClOrdId() {
        return this.text;
    }

    @Override
    public String getSymbol() {
        return this.contract;
    }

    @Override
    public double getCumQty() {
        return Math.abs(this.size) - this.left;
    }

    @Override
    public Double getLastOrAvgPx() {
        return this.fillPrice.doubleValue();
    }

    @Override
    public SimpleOrderStatus getSimpleStatus() {
        return switch (this.status) {
            default -> throw new IncompatibleClassChangeError();
            case FuturesOrderStatus.OPEN -> SimpleOrderStatus.OPEN;
            case FuturesOrderStatus.FINISHED -> SimpleOrderStatus.CLOSED;
        };
    }

    public long getId() {
        return this.id;
    }

    public int getUser() {
        return this.user;
    }

    public double getCreateTime() {
        return this.createTime;
    }

    public Double getFinishTime() {
        return this.finishTime;
    }

    public Double getUpdateTime() {
        return this.updateTime;
    }

    public OrderCompletionStatus getFinishAs() {
        return this.finishAs;
    }

    public FuturesOrderStatus getStatus() {
        return this.status;
    }

    public String getContract() {
        return this.contract;
    }

    public long getSize() {
        return this.size;
    }

    public long getIceberg() {
        return this.iceberg;
    }

    public String getPrice() {
        return this.price;
    }

    public boolean isClose() {
        return this.close;
    }

    public boolean isReduceOnly() {
        return this.reduceOnly;
    }

    public boolean isLiq() {
        return this.isLiq;
    }

    public TimeInForce getTif() {
        return this.tif;
    }

    public long getLeft() {
        return this.left;
    }

    public BigDecimal getFillPrice() {
        return this.fillPrice;
    }

    public String getText() {
        return this.text;
    }

    public String getTkfr() {
        return this.tkfr;
    }

    public String getMkfr() {
        return this.mkfr;
    }

    public int getRefu() {
        return this.refu;
    }

    public AutoSize getAutoSize() {
        return this.autoSize;
    }

    public int getStpId() {
        return this.stpId;
    }

    public StpAct getStpAct() {
        return this.stpAct;
    }

    public String getAmendText() {
        return this.amendText;
    }

    public String getBizInfo() {
        return this.bizInfo;
    }

    public String getRefr() {
        return this.refr;
    }

    public String getPnl() {
        return this.pnl;
    }

    public String getPnlMargin() {
        return this.pnlMargin;
    }

    public Integer getUpdateId() {
        return this.updateId;
    }

    @JsonProperty(value="id")
    public void setId(long id) {
        this.id = id;
    }

    @JsonProperty(value="user")
    public void setUser(int user) {
        this.user = user;
    }

    @JsonProperty(value="create_time")
    public void setCreateTime(double createTime) {
        this.createTime = createTime;
    }

    @JsonProperty(value="finish_time")
    public void setFinishTime(Double finishTime) {
        this.finishTime = finishTime;
    }

    @JsonProperty(value="update_time")
    public void setUpdateTime(Double updateTime) {
        this.updateTime = updateTime;
    }

    @JsonDeserialize(using=OrderCompletionStatusDeserializer.class)
    @JsonProperty(value="finish_as")
    public void setFinishAs(OrderCompletionStatus finishAs) {
        this.finishAs = finishAs;
    }

    @JsonDeserialize(using=FuturesOrderStatusDeserializer.class)
    @JsonProperty(value="status")
    public void setStatus(FuturesOrderStatus status) {
        this.status = status;
    }

    @JsonProperty(value="contract")
    public void setContract(String contract) {
        this.contract = contract;
    }

    @JsonProperty(value="size")
    public void setSize(long size) {
        this.size = size;
    }

    @JsonProperty(value="iceberg")
    public void setIceberg(long iceberg) {
        this.iceberg = iceberg;
    }

    @JsonProperty(value="price")
    public void setPrice(String price) {
        this.price = price;
    }

    @JsonProperty(value="close")
    public void setClose(boolean close) {
        this.close = close;
    }

    @JsonProperty(value="reduce_only")
    public void setReduceOnly(boolean reduceOnly) {
        this.reduceOnly = reduceOnly;
    }

    @JsonProperty(value="is_liq")
    public void setLiq(boolean isLiq) {
        this.isLiq = isLiq;
    }

    @JsonDeserialize(using=TimeInForceDeserializer.class)
    @JsonProperty(value="tif")
    public void setTif(TimeInForce tif) {
        this.tif = tif;
    }

    @JsonProperty(value="left")
    public void setLeft(long left) {
        this.left = left;
    }

    @JsonProperty(value="fill_price")
    public void setFillPrice(BigDecimal fillPrice) {
        this.fillPrice = fillPrice;
    }

    @JsonProperty(value="text")
    public void setText(String text) {
        this.text = text;
    }

    @JsonProperty(value="tkfr")
    public void setTkfr(String tkfr) {
        this.tkfr = tkfr;
    }

    @JsonProperty(value="mkfr")
    public void setMkfr(String mkfr) {
        this.mkfr = mkfr;
    }

    @JsonProperty(value="refu")
    public void setRefu(int refu) {
        this.refu = refu;
    }

    @JsonDeserialize(using=AutoSizeDeserializer.class)
    @JsonProperty(value="auto_size")
    public void setAutoSize(AutoSize autoSize) {
        this.autoSize = autoSize;
    }

    @JsonProperty(value="stp_id")
    public void setStpId(int stpId) {
        this.stpId = stpId;
    }

    @JsonProperty(value="stp_act")
    public void setStpAct(StpAct stpAct) {
        this.stpAct = stpAct;
    }

    @JsonProperty(value="amend_text")
    public void setAmendText(String amendText) {
        this.amendText = amendText;
    }

    @JsonProperty(value="biz_info")
    public void setBizInfo(String bizInfo) {
        this.bizInfo = bizInfo;
    }

    @JsonProperty(value="refr")
    public void setRefr(String refr) {
        this.refr = refr;
    }

    @JsonProperty(value="pnl")
    public void setPnl(String pnl) {
        this.pnl = pnl;
    }

    @JsonProperty(value="pnl_margin")
    public void setPnlMargin(String pnlMargin) {
        this.pnlMargin = pnlMargin;
    }

    @JsonProperty(value="update_id")
    public void setUpdateId(Integer updateId) {
        this.updateId = updateId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FuturesOrderResponse)) {
            return false;
        }
        FuturesOrderResponse other = (FuturesOrderResponse)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getUser() != other.getUser()) {
            return false;
        }
        if (Double.compare(this.getCreateTime(), other.getCreateTime()) != 0) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getIceberg() != other.getIceberg()) {
            return false;
        }
        if (this.isClose() != other.isClose()) {
            return false;
        }
        if (this.isClose() != other.isClose()) {
            return false;
        }
        if (this.isReduceOnly() != other.isReduceOnly()) {
            return false;
        }
        if (this.isReduceOnly() != other.isReduceOnly()) {
            return false;
        }
        if (this.isLiq() != other.isLiq()) {
            return false;
        }
        if (this.getLeft() != other.getLeft()) {
            return false;
        }
        if (this.getRefu() != other.getRefu()) {
            return false;
        }
        if (this.getStpId() != other.getStpId()) {
            return false;
        }
        Double this$finishTime = this.getFinishTime();
        Double other$finishTime = other.getFinishTime();
        if (this$finishTime == null ? other$finishTime != null : !((Object)this$finishTime).equals(other$finishTime)) {
            return false;
        }
        Double this$updateTime = this.getUpdateTime();
        Double other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Integer this$updateId = this.getUpdateId();
        Integer other$updateId = other.getUpdateId();
        if (this$updateId == null ? other$updateId != null : !((Object)this$updateId).equals(other$updateId)) {
            return false;
        }
        OrderCompletionStatus this$finishAs = this.getFinishAs();
        OrderCompletionStatus other$finishAs = other.getFinishAs();
        if (this$finishAs == null ? other$finishAs != null : !((Object)((Object)this$finishAs)).equals((Object)other$finishAs)) {
            return false;
        }
        FuturesOrderStatus this$status = this.getStatus();
        FuturesOrderStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$contract = this.getContract();
        String other$contract = other.getContract();
        if (this$contract == null ? other$contract != null : !this$contract.equals(other$contract)) {
            return false;
        }
        String this$price = this.getPrice();
        String other$price = other.getPrice();
        if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
            return false;
        }
        TimeInForce this$tif = this.getTif();
        TimeInForce other$tif = other.getTif();
        if (this$tif == null ? other$tif != null : !((Object)((Object)this$tif)).equals((Object)other$tif)) {
            return false;
        }
        BigDecimal this$fillPrice = this.getFillPrice();
        BigDecimal other$fillPrice = other.getFillPrice();
        if (this$fillPrice == null ? other$fillPrice != null : !((Object)this$fillPrice).equals(other$fillPrice)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$tkfr = this.getTkfr();
        String other$tkfr = other.getTkfr();
        if (this$tkfr == null ? other$tkfr != null : !this$tkfr.equals(other$tkfr)) {
            return false;
        }
        String this$mkfr = this.getMkfr();
        String other$mkfr = other.getMkfr();
        if (this$mkfr == null ? other$mkfr != null : !this$mkfr.equals(other$mkfr)) {
            return false;
        }
        AutoSize this$autoSize = this.getAutoSize();
        AutoSize other$autoSize = other.getAutoSize();
        if (this$autoSize == null ? other$autoSize != null : !((Object)((Object)this$autoSize)).equals((Object)other$autoSize)) {
            return false;
        }
        StpAct this$stpAct = this.getStpAct();
        StpAct other$stpAct = other.getStpAct();
        if (this$stpAct == null ? other$stpAct != null : !((Object)((Object)this$stpAct)).equals((Object)other$stpAct)) {
            return false;
        }
        String this$amendText = this.getAmendText();
        String other$amendText = other.getAmendText();
        if (this$amendText == null ? other$amendText != null : !this$amendText.equals(other$amendText)) {
            return false;
        }
        String this$bizInfo = this.getBizInfo();
        String other$bizInfo = other.getBizInfo();
        if (this$bizInfo == null ? other$bizInfo != null : !this$bizInfo.equals(other$bizInfo)) {
            return false;
        }
        String this$refr = this.getRefr();
        String other$refr = other.getRefr();
        if (this$refr == null ? other$refr != null : !this$refr.equals(other$refr)) {
            return false;
        }
        String this$pnl = this.getPnl();
        String other$pnl = other.getPnl();
        if (this$pnl == null ? other$pnl != null : !this$pnl.equals(other$pnl)) {
            return false;
        }
        String this$pnlMargin = this.getPnlMargin();
        String other$pnlMargin = other.getPnlMargin();
        return !(this$pnlMargin == null ? other$pnlMargin != null : !this$pnlMargin.equals(other$pnlMargin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + this.getUser();
        long $createTime = Double.doubleToLongBits(this.getCreateTime());
        result = result * 59 + (int)($createTime >>> 32 ^ $createTime);
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        long $iceberg = this.getIceberg();
        result = result * 59 + (int)($iceberg >>> 32 ^ $iceberg);
        result = result * 59 + (this.isClose() ? 79 : 97);
        result = result * 59 + (this.isClose() ? 79 : 97);
        result = result * 59 + (this.isReduceOnly() ? 79 : 97);
        result = result * 59 + (this.isReduceOnly() ? 79 : 97);
        result = result * 59 + (this.isLiq() ? 79 : 97);
        long $left = this.getLeft();
        result = result * 59 + (int)($left >>> 32 ^ $left);
        result = result * 59 + this.getRefu();
        result = result * 59 + this.getStpId();
        Double $finishTime = this.getFinishTime();
        result = result * 59 + ($finishTime == null ? 43 : ((Object)$finishTime).hashCode());
        Double $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Integer $updateId = this.getUpdateId();
        result = result * 59 + ($updateId == null ? 43 : ((Object)$updateId).hashCode());
        OrderCompletionStatus $finishAs = this.getFinishAs();
        result = result * 59 + ($finishAs == null ? 43 : ((Object)((Object)$finishAs)).hashCode());
        FuturesOrderStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $contract = this.getContract();
        result = result * 59 + ($contract == null ? 43 : $contract.hashCode());
        String $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : $price.hashCode());
        TimeInForce $tif = this.getTif();
        result = result * 59 + ($tif == null ? 43 : ((Object)((Object)$tif)).hashCode());
        BigDecimal $fillPrice = this.getFillPrice();
        result = result * 59 + ($fillPrice == null ? 43 : ((Object)$fillPrice).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $tkfr = this.getTkfr();
        result = result * 59 + ($tkfr == null ? 43 : $tkfr.hashCode());
        String $mkfr = this.getMkfr();
        result = result * 59 + ($mkfr == null ? 43 : $mkfr.hashCode());
        AutoSize $autoSize = this.getAutoSize();
        result = result * 59 + ($autoSize == null ? 43 : ((Object)((Object)$autoSize)).hashCode());
        StpAct $stpAct = this.getStpAct();
        result = result * 59 + ($stpAct == null ? 43 : ((Object)((Object)$stpAct)).hashCode());
        String $amendText = this.getAmendText();
        result = result * 59 + ($amendText == null ? 43 : $amendText.hashCode());
        String $bizInfo = this.getBizInfo();
        result = result * 59 + ($bizInfo == null ? 43 : $bizInfo.hashCode());
        String $refr = this.getRefr();
        result = result * 59 + ($refr == null ? 43 : $refr.hashCode());
        String $pnl = this.getPnl();
        result = result * 59 + ($pnl == null ? 43 : $pnl.hashCode());
        String $pnlMargin = this.getPnlMargin();
        result = result * 59 + ($pnlMargin == null ? 43 : $pnlMargin.hashCode());
        return result;
    }

    public String toString() {
        return "FuturesOrderResponse(id=" + this.getId() + ", user=" + this.getUser() + ", createTime=" + this.getCreateTime() + ", finishTime=" + this.getFinishTime() + ", updateTime=" + this.getUpdateTime() + ", finishAs=" + this.getFinishAs() + ", status=" + this.getStatus() + ", contract=" + this.getContract() + ", size=" + this.getSize() + ", iceberg=" + this.getIceberg() + ", price=" + this.getPrice() + ", close=" + this.isClose() + ", isClose=" + this.isClose() + ", reduceOnly=" + this.isReduceOnly() + ", isReduceOnly=" + this.isReduceOnly() + ", isLiq=" + this.isLiq() + ", tif=" + this.getTif() + ", left=" + this.getLeft() + ", fillPrice=" + this.getFillPrice() + ", text=" + this.getText() + ", tkfr=" + this.getTkfr() + ", mkfr=" + this.getMkfr() + ", refu=" + this.getRefu() + ", autoSize=" + this.getAutoSize() + ", stpId=" + this.getStpId() + ", stpAct=" + this.getStpAct() + ", amendText=" + this.getAmendText() + ", bizInfo=" + this.getBizInfo() + ", refr=" + this.getRefr() + ", pnl=" + this.getPnl() + ", pnlMargin=" + this.getPnlMargin() + ", updateId=" + this.getUpdateId() + ")";
    }
}

