/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.gateio.api.v4.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.stream.managed.OutboundMessage;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.gateio.api.v4.Utils;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.OBUpdateFrequency;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GateIOOutboundMessage
implements OutboundMessage {
    private static final String SUBSCRIBE_CMD = "subscribe";
    private static final String UNSUBSCRIBE_CMD = "unsubscribe";
    private static final String TICKER_CHANNEL = "book_ticker";
    private static final String OB_DELTA_CHANNEL = "order_book_update";
    private static final String USER_ORDERS_CHANNEL = "orders";
    private static final String USER_TRADES_CHANNEL = "usertrades";
    private static final String USER_BALANCES_CHANNEL = "balances";
    private static final String PING_CHANNEL = "ping";
    private static final String POSITION_CHANNEL = "positions";
    private static final String ALL_SYMBOLS = "!all";
    private long time;
    private Integer id;
    private String channel;
    private Map<String, String> auth;
    private String event;
    private List<String> payload;
    @JsonIgnore
    private OutboundMessage.MessageType messageType;

    public String queryString() {
        return String.format("channel=%s&event=%s&time=%d", this.channel, this.event, this.time);
    }

    public static GateIOOutboundMessage subscribeTicker(long currentTimeSec, AssetClass assetClass, String symbol) {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add(symbol);
        return new GateIOOutboundMessage().setTime(currentTimeSec).setEvent(SUBSCRIBE_CMD).setMessageType(OutboundMessage.MessageType.SUBSCRIPTION).setChannel(Utils.prefixByAssetClass(assetClass, TICKER_CHANNEL)).setPayload(payload);
    }

    public static GateIOOutboundMessage unsubscribeTicker(long currentTimeSec, AssetClass assetClass, String symbol) {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add(symbol);
        return new GateIOOutboundMessage().setTime(currentTimeSec).setEvent(UNSUBSCRIBE_CMD).setMessageType(OutboundMessage.MessageType.UNSUBSCRIBE).setChannel(Utils.prefixByAssetClass(assetClass, TICKER_CHANNEL)).setPayload(payload);
    }

    public static GateIOOutboundMessage subscribeOrderbookUpdate(long currentTimeSec, AssetClass assetClass, String symbol, OBUpdateFrequency frequency) {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add(symbol);
        payload.add(frequency.getValue());
        return new GateIOOutboundMessage().setTime(currentTimeSec).setEvent(SUBSCRIBE_CMD).setMessageType(OutboundMessage.MessageType.SUBSCRIPTION).setChannel(Utils.prefixByAssetClass(assetClass, OB_DELTA_CHANNEL)).setPayload(payload);
    }

    public static GateIOOutboundMessage unsubscribeOrderbookUpdate(long currentTimeSec, AssetClass assetClass, String symbol, OBUpdateFrequency frequency) {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add(symbol);
        payload.add(frequency.getValue());
        return new GateIOOutboundMessage().setTime(currentTimeSec).setEvent(UNSUBSCRIBE_CMD).setMessageType(OutboundMessage.MessageType.UNSUBSCRIBE).setChannel(Utils.prefixByAssetClass(assetClass, OB_DELTA_CHANNEL)).setPayload(payload);
    }

    private static GateIOOutboundMessage subscribePrivateChannel(long currentTimeSec, AssetClass assetClass, String channelName, Credentials credentials, String userId) {
        return GateIOOutboundMessage.subscribePrivateChannel(currentTimeSec, assetClass, channelName, credentials, userId, true);
    }

    private static GateIOOutboundMessage subscribePrivateChannel(long currentTimeSec, AssetClass assetClass, String channelName, Credentials credentials, String userId, Boolean withSymbols) {
        ArrayList<String> payload = new ArrayList<String>(2);
        if (userId != null) {
            payload.add(userId);
        }
        if (withSymbols.booleanValue()) {
            payload.add(ALL_SYMBOLS);
        }
        GateIOOutboundMessage msg = new GateIOOutboundMessage().setTime(currentTimeSec).setEvent(SUBSCRIBE_CMD).setMessageType(OutboundMessage.MessageType.SUBSCRIPTION).setChannel(Utils.prefixByAssetClass(assetClass, channelName)).setPayload(payload);
        Map<String, String> auth = Utils.genSignWs(msg.queryString(), credentials.getApiKey(), credentials.getSecretKey());
        return msg.setAuth(auth);
    }

    public static GateIOOutboundMessage subscribeOrders(long currentTimeSec, AssetClass assetClass, Credentials credentials, String userId) {
        return GateIOOutboundMessage.subscribePrivateChannel(currentTimeSec, assetClass, USER_ORDERS_CHANNEL, credentials, userId);
    }

    public static GateIOOutboundMessage subscribeUserTrades(long currentTimeSec, AssetClass assetClass, Credentials credentials, String userId) {
        return GateIOOutboundMessage.subscribePrivateChannel(currentTimeSec, assetClass, USER_TRADES_CHANNEL, credentials, userId);
    }

    public static GateIOOutboundMessage subscribeBalances(long currentTimeSec, AssetClass assetClass, Credentials credentials, String userId) {
        return GateIOOutboundMessage.subscribePrivateChannel(currentTimeSec, assetClass, USER_BALANCES_CHANNEL, credentials, userId, false);
    }

    public static GateIOOutboundMessage ping(long currentTimeSec, AssetClass assetClass) {
        return new GateIOOutboundMessage().setTime(currentTimeSec).setEvent(SUBSCRIBE_CMD).setMessageType(OutboundMessage.MessageType.PING).setChannel(Utils.prefixByAssetClass(assetClass, PING_CHANNEL));
    }

    public static GateIOOutboundMessage subscribePositionUpdate(long currentTimeSec, AssetClass assetClass, Credentials credentials, String userId) {
        if (assetClass != AssetClass.FUTURE && assetClass != AssetClass.PERP) {
            throw new IllegalArgumentException("Position updates ares supported by exchange only for delivery and perpetual futures");
        }
        return GateIOOutboundMessage.subscribePrivateChannel(currentTimeSec, assetClass, POSITION_CHANNEL, credentials, userId);
    }

    public long getTime() {
        return this.time;
    }

    public Integer getId() {
        return this.id;
    }

    public String getChannel() {
        return this.channel;
    }

    public Map<String, String> getAuth() {
        return this.auth;
    }

    public String getEvent() {
        return this.event;
    }

    public List<String> getPayload() {
        return this.payload;
    }

    @Override
    public OutboundMessage.MessageType getMessageType() {
        return this.messageType;
    }

    public GateIOOutboundMessage setTime(long time) {
        this.time = time;
        return this;
    }

    public GateIOOutboundMessage setId(Integer id) {
        this.id = id;
        return this;
    }

    public GateIOOutboundMessage setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public GateIOOutboundMessage setAuth(Map<String, String> auth) {
        this.auth = auth;
        return this;
    }

    public GateIOOutboundMessage setEvent(String event) {
        this.event = event;
        return this;
    }

    public GateIOOutboundMessage setPayload(List<String> payload) {
        this.payload = payload;
        return this;
    }

    @JsonIgnore
    public GateIOOutboundMessage setMessageType(OutboundMessage.MessageType messageType) {
        this.messageType = messageType;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GateIOOutboundMessage)) {
            return false;
        }
        GateIOOutboundMessage other = (GateIOOutboundMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        Map<String, String> this$auth = this.getAuth();
        Map<String, String> other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !((Object)this$auth).equals(other$auth)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        List<String> this$payload = this.getPayload();
        List<String> other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload)) {
            return false;
        }
        OutboundMessage.MessageType this$messageType = this.getMessageType();
        OutboundMessage.MessageType other$messageType = other.getMessageType();
        return !(this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GateIOOutboundMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        Map<String, String> $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : ((Object)$auth).hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        List<String> $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        OutboundMessage.MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        return result;
    }

    public String toString() {
        return "GateIOOutboundMessage(time=" + this.getTime() + ", id=" + this.getId() + ", channel=" + this.getChannel() + ", auth=" + this.getAuth() + ", event=" + this.getEvent() + ", payload=" + this.getPayload() + ", messageType=" + this.getMessageType() + ")";
    }
}

