/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.gateio.api.v4.domain;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.PriceLevel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PriceLevelDeserializer
extends JsonDeserializer<List<PriceLevel>> {
    @Override
    public List<PriceLevel> deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        JsonNode rootNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ArrayList<PriceLevel> priceLevels = new ArrayList<PriceLevel>();
        if (!rootNode.isArray()) {
            throw new JsonMappingException(jsonParser, "Expected an array");
        }
        if (rootNode.size() > 0) {
            boolean isArray = rootNode.get(0).isArray();
            if (isArray) {
                this.fillListArrays(priceLevels, rootNode);
            } else {
                this.fillListObjects(priceLevels, rootNode);
            }
        }
        return priceLevels;
    }

    private void fillListObjects(List<PriceLevel> result, JsonNode rootNode) {
        for (JsonNode node : rootNode) {
            PriceLevel priceLevel = new PriceLevel();
            priceLevel.setSize(node.get("s").decimalValue());
            priceLevel.setPrice(node.get("p").decimalValue());
            result.add(priceLevel);
        }
    }

    private void fillListArrays(List<PriceLevel> result, JsonNode rootNode) {
        for (JsonNode node : rootNode) {
            PriceLevel priceLevel = new PriceLevel();
            priceLevel.setPrice(node.get(0).decimalValue());
            priceLevel.setSize(node.get(1).decimalValue());
            result.add(priceLevel);
        }
    }
}

