/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.gateio.api.v4.domain.delivery;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.GateIOTicker;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.ContractType;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.deserializers.ContractTypeDeserializer;

public final class DeliveryTicker
implements GateIOTicker {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="underlying")
    private String underlying;
    @JsonProperty(value="cycle")
    private String cycle;
    @JsonDeserialize(using=ContractTypeDeserializer.class)
    @JsonProperty(value="type")
    private ContractType type;
    @JsonProperty(value="quanto_multiplier")
    private String quantoMultiplier;
    @JsonProperty(value="mark_type")
    private String markType;
    @JsonProperty(value="last_price")
    private String lastPrice;
    @JsonProperty(value="mark_price")
    private String markPrice;
    @JsonProperty(value="index_price")
    private String indexPrice;
    @JsonProperty(value="basis_rate")
    private String basisRate;
    @JsonProperty(value="basis_value")
    private String basisValue;
    @JsonProperty(value="basis_impact_value")
    private String basisImpactValue;
    @JsonProperty(value="settle_price")
    private String settlePrice;
    @JsonProperty(value="settle_price_interval")
    private Integer settlePriceInterval;
    @JsonProperty(value="settle_price_duration")
    private Integer settlePriceDuration;
    @JsonProperty(value="settle_fee_rate")
    private String settleFeeRate;
    @JsonProperty(value="expire_time")
    private Long expireTime;
    @JsonProperty(value="order_price_round")
    private String orderPriceRound;
    @JsonProperty(value="mark_price_round")
    private String markPriceRound;
    @JsonProperty(value="leverage_min")
    private String leverageMin;
    @JsonProperty(value="leverage_max")
    private String leverageMax;
    @JsonProperty(value="maintenance_rate")
    private String maintenanceRate;
    @JsonProperty(value="risk_limit_base")
    private String riskLimitBase;
    @JsonProperty(value="risk_limit_step")
    private String riskLimitStep;
    @JsonProperty(value="risk_limit_max")
    private String riskLimitMax;
    @JsonProperty(value="maker_fee_rate")
    private String makerFeeRate;
    @JsonProperty(value="taker_fee_rate")
    private String takerFeeRate;
    @JsonProperty(value="ref_discount_rate")
    private String refDiscountRate;
    @JsonProperty(value="ref_rebate_rate")
    private String refRebateRate;
    @JsonProperty(value="order_price_deviate")
    private String orderPriceDeviate;
    @JsonProperty(value="order_size_min")
    private Integer orderSizeMin;
    @JsonProperty(value="order_size_max")
    private Integer orderSizeMax;
    @JsonProperty(value="orders_limit")
    private Integer ordersLimit;
    @JsonProperty(value="orderbook_id")
    private Integer orderbookId;
    @JsonProperty(value="trade_id")
    private Integer tradeId;
    @JsonProperty(value="trade_size")
    private Integer tradeSize;
    @JsonProperty(value="position_size")
    private Integer positionSize;
    @JsonProperty(value="config_change_time")
    private Long configChangeTime;
    @JsonProperty(value="in_delisting")
    private Boolean inDelisting;

    @Override
    public String getSymbol() {
        return this.name;
    }

    @Override
    public String getBaseAsset() {
        String[] baseQuote = this.name.split("_");
        if (this.type == ContractType.INVERSE) {
            return baseQuote[1];
        }
        if (this.type == ContractType.DIRECT) {
            return baseQuote[0];
        }
        return null;
    }

    @Override
    public String getQuoteAsset() {
        String[] baseQuote = this.name.split("_");
        if (this.type == ContractType.INVERSE) {
            return baseQuote[0];
        }
        if (this.type == ContractType.DIRECT) {
            return baseQuote[1];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getUnderlying() {
        return this.underlying;
    }

    public String getCycle() {
        return this.cycle;
    }

    public ContractType getType() {
        return this.type;
    }

    public String getQuantoMultiplier() {
        return this.quantoMultiplier;
    }

    public String getMarkType() {
        return this.markType;
    }

    public String getLastPrice() {
        return this.lastPrice;
    }

    public String getMarkPrice() {
        return this.markPrice;
    }

    public String getIndexPrice() {
        return this.indexPrice;
    }

    public String getBasisRate() {
        return this.basisRate;
    }

    public String getBasisValue() {
        return this.basisValue;
    }

    public String getBasisImpactValue() {
        return this.basisImpactValue;
    }

    public String getSettlePrice() {
        return this.settlePrice;
    }

    public Integer getSettlePriceInterval() {
        return this.settlePriceInterval;
    }

    public Integer getSettlePriceDuration() {
        return this.settlePriceDuration;
    }

    public String getSettleFeeRate() {
        return this.settleFeeRate;
    }

    public Long getExpireTime() {
        return this.expireTime;
    }

    public String getOrderPriceRound() {
        return this.orderPriceRound;
    }

    public String getMarkPriceRound() {
        return this.markPriceRound;
    }

    public String getLeverageMin() {
        return this.leverageMin;
    }

    public String getLeverageMax() {
        return this.leverageMax;
    }

    public String getMaintenanceRate() {
        return this.maintenanceRate;
    }

    public String getRiskLimitBase() {
        return this.riskLimitBase;
    }

    public String getRiskLimitStep() {
        return this.riskLimitStep;
    }

    public String getRiskLimitMax() {
        return this.riskLimitMax;
    }

    public String getMakerFeeRate() {
        return this.makerFeeRate;
    }

    public String getTakerFeeRate() {
        return this.takerFeeRate;
    }

    public String getRefDiscountRate() {
        return this.refDiscountRate;
    }

    public String getRefRebateRate() {
        return this.refRebateRate;
    }

    public String getOrderPriceDeviate() {
        return this.orderPriceDeviate;
    }

    public Integer getOrderSizeMin() {
        return this.orderSizeMin;
    }

    public Integer getOrderSizeMax() {
        return this.orderSizeMax;
    }

    public Integer getOrdersLimit() {
        return this.ordersLimit;
    }

    public Integer getOrderbookId() {
        return this.orderbookId;
    }

    public Integer getTradeId() {
        return this.tradeId;
    }

    public Integer getTradeSize() {
        return this.tradeSize;
    }

    public Integer getPositionSize() {
        return this.positionSize;
    }

    public Long getConfigChangeTime() {
        return this.configChangeTime;
    }

    public Boolean getInDelisting() {
        return this.inDelisting;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="underlying")
    public void setUnderlying(String underlying) {
        this.underlying = underlying;
    }

    @JsonProperty(value="cycle")
    public void setCycle(String cycle) {
        this.cycle = cycle;
    }

    @JsonDeserialize(using=ContractTypeDeserializer.class)
    @JsonProperty(value="type")
    public void setType(ContractType type) {
        this.type = type;
    }

    @JsonProperty(value="quanto_multiplier")
    public void setQuantoMultiplier(String quantoMultiplier) {
        this.quantoMultiplier = quantoMultiplier;
    }

    @JsonProperty(value="mark_type")
    public void setMarkType(String markType) {
        this.markType = markType;
    }

    @JsonProperty(value="last_price")
    public void setLastPrice(String lastPrice) {
        this.lastPrice = lastPrice;
    }

    @JsonProperty(value="mark_price")
    public void setMarkPrice(String markPrice) {
        this.markPrice = markPrice;
    }

    @JsonProperty(value="index_price")
    public void setIndexPrice(String indexPrice) {
        this.indexPrice = indexPrice;
    }

    @JsonProperty(value="basis_rate")
    public void setBasisRate(String basisRate) {
        this.basisRate = basisRate;
    }

    @JsonProperty(value="basis_value")
    public void setBasisValue(String basisValue) {
        this.basisValue = basisValue;
    }

    @JsonProperty(value="basis_impact_value")
    public void setBasisImpactValue(String basisImpactValue) {
        this.basisImpactValue = basisImpactValue;
    }

    @JsonProperty(value="settle_price")
    public void setSettlePrice(String settlePrice) {
        this.settlePrice = settlePrice;
    }

    @JsonProperty(value="settle_price_interval")
    public void setSettlePriceInterval(Integer settlePriceInterval) {
        this.settlePriceInterval = settlePriceInterval;
    }

    @JsonProperty(value="settle_price_duration")
    public void setSettlePriceDuration(Integer settlePriceDuration) {
        this.settlePriceDuration = settlePriceDuration;
    }

    @JsonProperty(value="settle_fee_rate")
    public void setSettleFeeRate(String settleFeeRate) {
        this.settleFeeRate = settleFeeRate;
    }

    @JsonProperty(value="expire_time")
    public void setExpireTime(Long expireTime) {
        this.expireTime = expireTime;
    }

    @JsonProperty(value="order_price_round")
    public void setOrderPriceRound(String orderPriceRound) {
        this.orderPriceRound = orderPriceRound;
    }

    @JsonProperty(value="mark_price_round")
    public void setMarkPriceRound(String markPriceRound) {
        this.markPriceRound = markPriceRound;
    }

    @JsonProperty(value="leverage_min")
    public void setLeverageMin(String leverageMin) {
        this.leverageMin = leverageMin;
    }

    @JsonProperty(value="leverage_max")
    public void setLeverageMax(String leverageMax) {
        this.leverageMax = leverageMax;
    }

    @JsonProperty(value="maintenance_rate")
    public void setMaintenanceRate(String maintenanceRate) {
        this.maintenanceRate = maintenanceRate;
    }

    @JsonProperty(value="risk_limit_base")
    public void setRiskLimitBase(String riskLimitBase) {
        this.riskLimitBase = riskLimitBase;
    }

    @JsonProperty(value="risk_limit_step")
    public void setRiskLimitStep(String riskLimitStep) {
        this.riskLimitStep = riskLimitStep;
    }

    @JsonProperty(value="risk_limit_max")
    public void setRiskLimitMax(String riskLimitMax) {
        this.riskLimitMax = riskLimitMax;
    }

    @JsonProperty(value="maker_fee_rate")
    public void setMakerFeeRate(String makerFeeRate) {
        this.makerFeeRate = makerFeeRate;
    }

    @JsonProperty(value="taker_fee_rate")
    public void setTakerFeeRate(String takerFeeRate) {
        this.takerFeeRate = takerFeeRate;
    }

    @JsonProperty(value="ref_discount_rate")
    public void setRefDiscountRate(String refDiscountRate) {
        this.refDiscountRate = refDiscountRate;
    }

    @JsonProperty(value="ref_rebate_rate")
    public void setRefRebateRate(String refRebateRate) {
        this.refRebateRate = refRebateRate;
    }

    @JsonProperty(value="order_price_deviate")
    public void setOrderPriceDeviate(String orderPriceDeviate) {
        this.orderPriceDeviate = orderPriceDeviate;
    }

    @JsonProperty(value="order_size_min")
    public void setOrderSizeMin(Integer orderSizeMin) {
        this.orderSizeMin = orderSizeMin;
    }

    @JsonProperty(value="order_size_max")
    public void setOrderSizeMax(Integer orderSizeMax) {
        this.orderSizeMax = orderSizeMax;
    }

    @JsonProperty(value="orders_limit")
    public void setOrdersLimit(Integer ordersLimit) {
        this.ordersLimit = ordersLimit;
    }

    @JsonProperty(value="orderbook_id")
    public void setOrderbookId(Integer orderbookId) {
        this.orderbookId = orderbookId;
    }

    @JsonProperty(value="trade_id")
    public void setTradeId(Integer tradeId) {
        this.tradeId = tradeId;
    }

    @JsonProperty(value="trade_size")
    public void setTradeSize(Integer tradeSize) {
        this.tradeSize = tradeSize;
    }

    @JsonProperty(value="position_size")
    public void setPositionSize(Integer positionSize) {
        this.positionSize = positionSize;
    }

    @JsonProperty(value="config_change_time")
    public void setConfigChangeTime(Long configChangeTime) {
        this.configChangeTime = configChangeTime;
    }

    @JsonProperty(value="in_delisting")
    public void setInDelisting(Boolean inDelisting) {
        this.inDelisting = inDelisting;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeliveryTicker)) {
            return false;
        }
        DeliveryTicker other = (DeliveryTicker)o;
        Integer this$settlePriceInterval = this.getSettlePriceInterval();
        Integer other$settlePriceInterval = other.getSettlePriceInterval();
        if (this$settlePriceInterval == null ? other$settlePriceInterval != null : !((Object)this$settlePriceInterval).equals(other$settlePriceInterval)) {
            return false;
        }
        Integer this$settlePriceDuration = this.getSettlePriceDuration();
        Integer other$settlePriceDuration = other.getSettlePriceDuration();
        if (this$settlePriceDuration == null ? other$settlePriceDuration != null : !((Object)this$settlePriceDuration).equals(other$settlePriceDuration)) {
            return false;
        }
        Long this$expireTime = this.getExpireTime();
        Long other$expireTime = other.getExpireTime();
        if (this$expireTime == null ? other$expireTime != null : !((Object)this$expireTime).equals(other$expireTime)) {
            return false;
        }
        Integer this$orderSizeMin = this.getOrderSizeMin();
        Integer other$orderSizeMin = other.getOrderSizeMin();
        if (this$orderSizeMin == null ? other$orderSizeMin != null : !((Object)this$orderSizeMin).equals(other$orderSizeMin)) {
            return false;
        }
        Integer this$orderSizeMax = this.getOrderSizeMax();
        Integer other$orderSizeMax = other.getOrderSizeMax();
        if (this$orderSizeMax == null ? other$orderSizeMax != null : !((Object)this$orderSizeMax).equals(other$orderSizeMax)) {
            return false;
        }
        Integer this$ordersLimit = this.getOrdersLimit();
        Integer other$ordersLimit = other.getOrdersLimit();
        if (this$ordersLimit == null ? other$ordersLimit != null : !((Object)this$ordersLimit).equals(other$ordersLimit)) {
            return false;
        }
        Integer this$orderbookId = this.getOrderbookId();
        Integer other$orderbookId = other.getOrderbookId();
        if (this$orderbookId == null ? other$orderbookId != null : !((Object)this$orderbookId).equals(other$orderbookId)) {
            return false;
        }
        Integer this$tradeId = this.getTradeId();
        Integer other$tradeId = other.getTradeId();
        if (this$tradeId == null ? other$tradeId != null : !((Object)this$tradeId).equals(other$tradeId)) {
            return false;
        }
        Integer this$tradeSize = this.getTradeSize();
        Integer other$tradeSize = other.getTradeSize();
        if (this$tradeSize == null ? other$tradeSize != null : !((Object)this$tradeSize).equals(other$tradeSize)) {
            return false;
        }
        Integer this$positionSize = this.getPositionSize();
        Integer other$positionSize = other.getPositionSize();
        if (this$positionSize == null ? other$positionSize != null : !((Object)this$positionSize).equals(other$positionSize)) {
            return false;
        }
        Long this$configChangeTime = this.getConfigChangeTime();
        Long other$configChangeTime = other.getConfigChangeTime();
        if (this$configChangeTime == null ? other$configChangeTime != null : !((Object)this$configChangeTime).equals(other$configChangeTime)) {
            return false;
        }
        Boolean this$inDelisting = this.getInDelisting();
        Boolean other$inDelisting = other.getInDelisting();
        if (this$inDelisting == null ? other$inDelisting != null : !((Object)this$inDelisting).equals(other$inDelisting)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$underlying = this.getUnderlying();
        String other$underlying = other.getUnderlying();
        if (this$underlying == null ? other$underlying != null : !this$underlying.equals(other$underlying)) {
            return false;
        }
        String this$cycle = this.getCycle();
        String other$cycle = other.getCycle();
        if (this$cycle == null ? other$cycle != null : !this$cycle.equals(other$cycle)) {
            return false;
        }
        ContractType this$type = this.getType();
        ContractType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$quantoMultiplier = this.getQuantoMultiplier();
        String other$quantoMultiplier = other.getQuantoMultiplier();
        if (this$quantoMultiplier == null ? other$quantoMultiplier != null : !this$quantoMultiplier.equals(other$quantoMultiplier)) {
            return false;
        }
        String this$markType = this.getMarkType();
        String other$markType = other.getMarkType();
        if (this$markType == null ? other$markType != null : !this$markType.equals(other$markType)) {
            return false;
        }
        String this$lastPrice = this.getLastPrice();
        String other$lastPrice = other.getLastPrice();
        if (this$lastPrice == null ? other$lastPrice != null : !this$lastPrice.equals(other$lastPrice)) {
            return false;
        }
        String this$markPrice = this.getMarkPrice();
        String other$markPrice = other.getMarkPrice();
        if (this$markPrice == null ? other$markPrice != null : !this$markPrice.equals(other$markPrice)) {
            return false;
        }
        String this$indexPrice = this.getIndexPrice();
        String other$indexPrice = other.getIndexPrice();
        if (this$indexPrice == null ? other$indexPrice != null : !this$indexPrice.equals(other$indexPrice)) {
            return false;
        }
        String this$basisRate = this.getBasisRate();
        String other$basisRate = other.getBasisRate();
        if (this$basisRate == null ? other$basisRate != null : !this$basisRate.equals(other$basisRate)) {
            return false;
        }
        String this$basisValue = this.getBasisValue();
        String other$basisValue = other.getBasisValue();
        if (this$basisValue == null ? other$basisValue != null : !this$basisValue.equals(other$basisValue)) {
            return false;
        }
        String this$basisImpactValue = this.getBasisImpactValue();
        String other$basisImpactValue = other.getBasisImpactValue();
        if (this$basisImpactValue == null ? other$basisImpactValue != null : !this$basisImpactValue.equals(other$basisImpactValue)) {
            return false;
        }
        String this$settlePrice = this.getSettlePrice();
        String other$settlePrice = other.getSettlePrice();
        if (this$settlePrice == null ? other$settlePrice != null : !this$settlePrice.equals(other$settlePrice)) {
            return false;
        }
        String this$settleFeeRate = this.getSettleFeeRate();
        String other$settleFeeRate = other.getSettleFeeRate();
        if (this$settleFeeRate == null ? other$settleFeeRate != null : !this$settleFeeRate.equals(other$settleFeeRate)) {
            return false;
        }
        String this$orderPriceRound = this.getOrderPriceRound();
        String other$orderPriceRound = other.getOrderPriceRound();
        if (this$orderPriceRound == null ? other$orderPriceRound != null : !this$orderPriceRound.equals(other$orderPriceRound)) {
            return false;
        }
        String this$markPriceRound = this.getMarkPriceRound();
        String other$markPriceRound = other.getMarkPriceRound();
        if (this$markPriceRound == null ? other$markPriceRound != null : !this$markPriceRound.equals(other$markPriceRound)) {
            return false;
        }
        String this$leverageMin = this.getLeverageMin();
        String other$leverageMin = other.getLeverageMin();
        if (this$leverageMin == null ? other$leverageMin != null : !this$leverageMin.equals(other$leverageMin)) {
            return false;
        }
        String this$leverageMax = this.getLeverageMax();
        String other$leverageMax = other.getLeverageMax();
        if (this$leverageMax == null ? other$leverageMax != null : !this$leverageMax.equals(other$leverageMax)) {
            return false;
        }
        String this$maintenanceRate = this.getMaintenanceRate();
        String other$maintenanceRate = other.getMaintenanceRate();
        if (this$maintenanceRate == null ? other$maintenanceRate != null : !this$maintenanceRate.equals(other$maintenanceRate)) {
            return false;
        }
        String this$riskLimitBase = this.getRiskLimitBase();
        String other$riskLimitBase = other.getRiskLimitBase();
        if (this$riskLimitBase == null ? other$riskLimitBase != null : !this$riskLimitBase.equals(other$riskLimitBase)) {
            return false;
        }
        String this$riskLimitStep = this.getRiskLimitStep();
        String other$riskLimitStep = other.getRiskLimitStep();
        if (this$riskLimitStep == null ? other$riskLimitStep != null : !this$riskLimitStep.equals(other$riskLimitStep)) {
            return false;
        }
        String this$riskLimitMax = this.getRiskLimitMax();
        String other$riskLimitMax = other.getRiskLimitMax();
        if (this$riskLimitMax == null ? other$riskLimitMax != null : !this$riskLimitMax.equals(other$riskLimitMax)) {
            return false;
        }
        String this$makerFeeRate = this.getMakerFeeRate();
        String other$makerFeeRate = other.getMakerFeeRate();
        if (this$makerFeeRate == null ? other$makerFeeRate != null : !this$makerFeeRate.equals(other$makerFeeRate)) {
            return false;
        }
        String this$takerFeeRate = this.getTakerFeeRate();
        String other$takerFeeRate = other.getTakerFeeRate();
        if (this$takerFeeRate == null ? other$takerFeeRate != null : !this$takerFeeRate.equals(other$takerFeeRate)) {
            return false;
        }
        String this$refDiscountRate = this.getRefDiscountRate();
        String other$refDiscountRate = other.getRefDiscountRate();
        if (this$refDiscountRate == null ? other$refDiscountRate != null : !this$refDiscountRate.equals(other$refDiscountRate)) {
            return false;
        }
        String this$refRebateRate = this.getRefRebateRate();
        String other$refRebateRate = other.getRefRebateRate();
        if (this$refRebateRate == null ? other$refRebateRate != null : !this$refRebateRate.equals(other$refRebateRate)) {
            return false;
        }
        String this$orderPriceDeviate = this.getOrderPriceDeviate();
        String other$orderPriceDeviate = other.getOrderPriceDeviate();
        return !(this$orderPriceDeviate == null ? other$orderPriceDeviate != null : !this$orderPriceDeviate.equals(other$orderPriceDeviate));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $settlePriceInterval = this.getSettlePriceInterval();
        result = result * 59 + ($settlePriceInterval == null ? 43 : ((Object)$settlePriceInterval).hashCode());
        Integer $settlePriceDuration = this.getSettlePriceDuration();
        result = result * 59 + ($settlePriceDuration == null ? 43 : ((Object)$settlePriceDuration).hashCode());
        Long $expireTime = this.getExpireTime();
        result = result * 59 + ($expireTime == null ? 43 : ((Object)$expireTime).hashCode());
        Integer $orderSizeMin = this.getOrderSizeMin();
        result = result * 59 + ($orderSizeMin == null ? 43 : ((Object)$orderSizeMin).hashCode());
        Integer $orderSizeMax = this.getOrderSizeMax();
        result = result * 59 + ($orderSizeMax == null ? 43 : ((Object)$orderSizeMax).hashCode());
        Integer $ordersLimit = this.getOrdersLimit();
        result = result * 59 + ($ordersLimit == null ? 43 : ((Object)$ordersLimit).hashCode());
        Integer $orderbookId = this.getOrderbookId();
        result = result * 59 + ($orderbookId == null ? 43 : ((Object)$orderbookId).hashCode());
        Integer $tradeId = this.getTradeId();
        result = result * 59 + ($tradeId == null ? 43 : ((Object)$tradeId).hashCode());
        Integer $tradeSize = this.getTradeSize();
        result = result * 59 + ($tradeSize == null ? 43 : ((Object)$tradeSize).hashCode());
        Integer $positionSize = this.getPositionSize();
        result = result * 59 + ($positionSize == null ? 43 : ((Object)$positionSize).hashCode());
        Long $configChangeTime = this.getConfigChangeTime();
        result = result * 59 + ($configChangeTime == null ? 43 : ((Object)$configChangeTime).hashCode());
        Boolean $inDelisting = this.getInDelisting();
        result = result * 59 + ($inDelisting == null ? 43 : ((Object)$inDelisting).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $underlying = this.getUnderlying();
        result = result * 59 + ($underlying == null ? 43 : $underlying.hashCode());
        String $cycle = this.getCycle();
        result = result * 59 + ($cycle == null ? 43 : $cycle.hashCode());
        ContractType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $quantoMultiplier = this.getQuantoMultiplier();
        result = result * 59 + ($quantoMultiplier == null ? 43 : $quantoMultiplier.hashCode());
        String $markType = this.getMarkType();
        result = result * 59 + ($markType == null ? 43 : $markType.hashCode());
        String $lastPrice = this.getLastPrice();
        result = result * 59 + ($lastPrice == null ? 43 : $lastPrice.hashCode());
        String $markPrice = this.getMarkPrice();
        result = result * 59 + ($markPrice == null ? 43 : $markPrice.hashCode());
        String $indexPrice = this.getIndexPrice();
        result = result * 59 + ($indexPrice == null ? 43 : $indexPrice.hashCode());
        String $basisRate = this.getBasisRate();
        result = result * 59 + ($basisRate == null ? 43 : $basisRate.hashCode());
        String $basisValue = this.getBasisValue();
        result = result * 59 + ($basisValue == null ? 43 : $basisValue.hashCode());
        String $basisImpactValue = this.getBasisImpactValue();
        result = result * 59 + ($basisImpactValue == null ? 43 : $basisImpactValue.hashCode());
        String $settlePrice = this.getSettlePrice();
        result = result * 59 + ($settlePrice == null ? 43 : $settlePrice.hashCode());
        String $settleFeeRate = this.getSettleFeeRate();
        result = result * 59 + ($settleFeeRate == null ? 43 : $settleFeeRate.hashCode());
        String $orderPriceRound = this.getOrderPriceRound();
        result = result * 59 + ($orderPriceRound == null ? 43 : $orderPriceRound.hashCode());
        String $markPriceRound = this.getMarkPriceRound();
        result = result * 59 + ($markPriceRound == null ? 43 : $markPriceRound.hashCode());
        String $leverageMin = this.getLeverageMin();
        result = result * 59 + ($leverageMin == null ? 43 : $leverageMin.hashCode());
        String $leverageMax = this.getLeverageMax();
        result = result * 59 + ($leverageMax == null ? 43 : $leverageMax.hashCode());
        String $maintenanceRate = this.getMaintenanceRate();
        result = result * 59 + ($maintenanceRate == null ? 43 : $maintenanceRate.hashCode());
        String $riskLimitBase = this.getRiskLimitBase();
        result = result * 59 + ($riskLimitBase == null ? 43 : $riskLimitBase.hashCode());
        String $riskLimitStep = this.getRiskLimitStep();
        result = result * 59 + ($riskLimitStep == null ? 43 : $riskLimitStep.hashCode());
        String $riskLimitMax = this.getRiskLimitMax();
        result = result * 59 + ($riskLimitMax == null ? 43 : $riskLimitMax.hashCode());
        String $makerFeeRate = this.getMakerFeeRate();
        result = result * 59 + ($makerFeeRate == null ? 43 : $makerFeeRate.hashCode());
        String $takerFeeRate = this.getTakerFeeRate();
        result = result * 59 + ($takerFeeRate == null ? 43 : $takerFeeRate.hashCode());
        String $refDiscountRate = this.getRefDiscountRate();
        result = result * 59 + ($refDiscountRate == null ? 43 : $refDiscountRate.hashCode());
        String $refRebateRate = this.getRefRebateRate();
        result = result * 59 + ($refRebateRate == null ? 43 : $refRebateRate.hashCode());
        String $orderPriceDeviate = this.getOrderPriceDeviate();
        result = result * 59 + ($orderPriceDeviate == null ? 43 : $orderPriceDeviate.hashCode());
        return result;
    }

    public String toString() {
        return "DeliveryTicker(name=" + this.getName() + ", underlying=" + this.getUnderlying() + ", cycle=" + this.getCycle() + ", type=" + this.getType() + ", quantoMultiplier=" + this.getQuantoMultiplier() + ", markType=" + this.getMarkType() + ", lastPrice=" + this.getLastPrice() + ", markPrice=" + this.getMarkPrice() + ", indexPrice=" + this.getIndexPrice() + ", basisRate=" + this.getBasisRate() + ", basisValue=" + this.getBasisValue() + ", basisImpactValue=" + this.getBasisImpactValue() + ", settlePrice=" + this.getSettlePrice() + ", settlePriceInterval=" + this.getSettlePriceInterval() + ", settlePriceDuration=" + this.getSettlePriceDuration() + ", settleFeeRate=" + this.getSettleFeeRate() + ", expireTime=" + this.getExpireTime() + ", orderPriceRound=" + this.getOrderPriceRound() + ", markPriceRound=" + this.getMarkPriceRound() + ", leverageMin=" + this.getLeverageMin() + ", leverageMax=" + this.getLeverageMax() + ", maintenanceRate=" + this.getMaintenanceRate() + ", riskLimitBase=" + this.getRiskLimitBase() + ", riskLimitStep=" + this.getRiskLimitStep() + ", riskLimitMax=" + this.getRiskLimitMax() + ", makerFeeRate=" + this.getMakerFeeRate() + ", takerFeeRate=" + this.getTakerFeeRate() + ", refDiscountRate=" + this.getRefDiscountRate() + ", refRebateRate=" + this.getRefRebateRate() + ", orderPriceDeviate=" + this.getOrderPriceDeviate() + ", orderSizeMin=" + this.getOrderSizeMin() + ", orderSizeMax=" + this.getOrderSizeMax() + ", ordersLimit=" + this.getOrdersLimit() + ", orderbookId=" + this.getOrderbookId() + ", tradeId=" + this.getTradeId() + ", tradeSize=" + this.getTradeSize() + ", positionSize=" + this.getPositionSize() + ", configChangeTime=" + this.getConfigChangeTime() + ", inDelisting=" + this.getInDelisting() + ")";
    }
}

