/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public enum CandleStickInterval {
    SECONDS_10("10s", TimeUnit.SECONDS.toMillis(10L)),
    MINUTES_1("1m", TimeUnit.MINUTES.toMillis(1L)),
    MINUTES_5("5m", TimeUnit.MINUTES.toMillis(5L)),
    MINUTES_15("15m", TimeUnit.MINUTES.toMillis(15L)),
    MINUTES_30("30m", TimeUnit.MINUTES.toMillis(30L)),
    HOURS_1("1h", TimeUnit.HOURS.toMillis(1L)),
    HOURS_4("4h", TimeUnit.HOURS.toMillis(4L)),
    HOURS_8("8h", TimeUnit.HOURS.toMillis(8L)),
    DAYS_1("1d", TimeUnit.DAYS.toMillis(1L)),
    DAYS_7("7d", TimeUnit.DAYS.toMillis(7L)),
    DAYS_30("30d", TimeUnit.DAYS.toMillis(30L));

    private final String value;
    private final long millis;

    private CandleStickInterval(String value, long millis) {
        this.value = value;
        this.millis = millis;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public long getMillis() {
        return this.millis;
    }

    public static CandleStickInterval fromMillis(long millis) {
        return Stream.of(CandleStickInterval.values()).filter(interval -> interval.getMillis() == millis).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown interval for millis: " + millis));
    }
}

