/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum WSErrorCode {
    INVALID_REQUEST_BODY_FORMAT("Invalid request body format"),
    INVALID_ARGUMENT_PROVIDED("Invalid argument provided"),
    SERVER_SIDE_ERROR("Server side error happened");

    final String description;

    private WSErrorCode(String description) {
        this.description = description;
    }

    @JsonCreator
    public static WSErrorCode fromCode(int code) {
        return switch (code) {
            case 1 -> INVALID_REQUEST_BODY_FORMAT;
            case 2 -> INVALID_ARGUMENT_PROVIDED;
            case 3 -> SERVER_SIDE_ERROR;
            default -> throw new IllegalArgumentException("Unexpected value '" + code + "'");
        };
    }
}

