/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.gateio.api.v4.domain.perpetual;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.GateIOTicker;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.ContractType;
import estonlabs.cxtl.exchanges.gateio.api.v4.domain.enums.deserializers.ContractTypeDeserializer;

public final class PerpetualTicker
implements GateIOTicker {
    @JsonProperty(value="name")
    private String name;
    @JsonDeserialize(using=ContractTypeDeserializer.class)
    @JsonProperty(value="type")
    private ContractType type;
    @JsonProperty(value="quanto_multiplier")
    private String quantoMultiplier;
    @JsonProperty(value="ref_discount_rate")
    private String refDiscountRate;
    @JsonProperty(value="order_price_deviate")
    private String orderPriceDeviate;
    @JsonProperty(value="maintenance_rate")
    private String maintenanceRate;
    @JsonProperty(value="mark_type")
    private String markType;
    @JsonProperty(value="last_price")
    private String lastPrice;
    @JsonProperty(value="mark_price")
    private String markPrice;
    @JsonProperty(value="index_price")
    private String indexPrice;
    @JsonProperty(value="funding_rate_indicative")
    private String fundingRateIndicative;
    @JsonProperty(value="mark_price_round")
    private String markPriceRound;
    @JsonProperty(value="funding_offset")
    private Integer fundingOffset;
    @JsonProperty(value="in_delisting")
    private Boolean inDelisting;
    @JsonProperty(value="risk_limit_base")
    private String riskLimitBase;
    @JsonProperty(value="interest_rate")
    private String interestRate;
    @JsonProperty(value="order_price_round")
    private String orderPriceRound;
    @JsonProperty(value="order_size_min")
    private Integer orderSizeMin;
    @JsonProperty(value="ref_rebate_rate")
    private String refRebateRate;
    @JsonProperty(value="funding_interval")
    private Integer fundingInterval;
    @JsonProperty(value="risk_limit_step")
    private String riskLimitStep;
    @JsonProperty(value="leverage_min")
    private String leverageMin;
    @JsonProperty(value="leverage_max")
    private String leverageMax;
    @JsonProperty(value="risk_limit_max")
    private String riskLimitMax;
    @JsonProperty(value="maker_fee_rate")
    private String makerFeeRate;
    @JsonProperty(value="taker_fee_rate")
    private String takerFeeRate;
    @JsonProperty(value="funding_rate")
    private String fundingRate;
    @JsonProperty(value="order_size_max")
    private Integer orderSizeMax;
    @JsonProperty(value="funding_next_apply")
    private Long fundingNextApply;
    @JsonProperty(value="short_users")
    private Integer shortUsers;
    @JsonProperty(value="config_change_time")
    private Long configChangeTime;
    @JsonProperty(value="trade_size")
    private Long tradeSize;
    @JsonProperty(value="position_size")
    private Integer positionSize;
    @JsonProperty(value="long_users")
    private Integer longUsers;
    @JsonProperty(value="funding_impact_value")
    private String fundingImpactValue;
    @JsonProperty(value="orders_limit")
    private Integer ordersLimit;
    @JsonProperty(value="trade_id")
    private Long tradeId;
    @JsonProperty(value="orderbook_id")
    private Long orderbookId;
    @JsonProperty(value="enable_bonus")
    private Boolean enableBonus;
    @JsonProperty(value="enable_credit")
    private Boolean enableCredit;
    @JsonProperty(value="create_time")
    private Long createTime;
    @JsonProperty(value="funding_cap_ratio")
    private String fundingCapRatio;
    @JsonProperty(value="cross_leverage_default")
    private String crossLeverageDefault;
    @JsonProperty(value="voucher_leverage")
    private String voucherLeverage;

    @Override
    public String getSymbol() {
        return this.name;
    }

    @Override
    public String getBaseAsset() {
        String[] baseQuote = this.name.split("_");
        if (this.type == ContractType.INVERSE) {
            return baseQuote[1];
        }
        if (this.type == ContractType.DIRECT) {
            return baseQuote[0];
        }
        return null;
    }

    @Override
    public String getQuoteAsset() {
        String[] baseQuote = this.name.split("_");
        if (this.type == ContractType.INVERSE) {
            return baseQuote[0];
        }
        if (this.type == ContractType.DIRECT) {
            return baseQuote[1];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public ContractType getType() {
        return this.type;
    }

    public String getQuantoMultiplier() {
        return this.quantoMultiplier;
    }

    public String getRefDiscountRate() {
        return this.refDiscountRate;
    }

    public String getOrderPriceDeviate() {
        return this.orderPriceDeviate;
    }

    public String getMaintenanceRate() {
        return this.maintenanceRate;
    }

    public String getMarkType() {
        return this.markType;
    }

    public String getLastPrice() {
        return this.lastPrice;
    }

    public String getMarkPrice() {
        return this.markPrice;
    }

    public String getIndexPrice() {
        return this.indexPrice;
    }

    public String getFundingRateIndicative() {
        return this.fundingRateIndicative;
    }

    public String getMarkPriceRound() {
        return this.markPriceRound;
    }

    public Integer getFundingOffset() {
        return this.fundingOffset;
    }

    public Boolean getInDelisting() {
        return this.inDelisting;
    }

    public String getRiskLimitBase() {
        return this.riskLimitBase;
    }

    public String getInterestRate() {
        return this.interestRate;
    }

    public String getOrderPriceRound() {
        return this.orderPriceRound;
    }

    public Integer getOrderSizeMin() {
        return this.orderSizeMin;
    }

    public String getRefRebateRate() {
        return this.refRebateRate;
    }

    public Integer getFundingInterval() {
        return this.fundingInterval;
    }

    public String getRiskLimitStep() {
        return this.riskLimitStep;
    }

    public String getLeverageMin() {
        return this.leverageMin;
    }

    public String getLeverageMax() {
        return this.leverageMax;
    }

    public String getRiskLimitMax() {
        return this.riskLimitMax;
    }

    public String getMakerFeeRate() {
        return this.makerFeeRate;
    }

    public String getTakerFeeRate() {
        return this.takerFeeRate;
    }

    public String getFundingRate() {
        return this.fundingRate;
    }

    public Integer getOrderSizeMax() {
        return this.orderSizeMax;
    }

    public Long getFundingNextApply() {
        return this.fundingNextApply;
    }

    public Integer getShortUsers() {
        return this.shortUsers;
    }

    public Long getConfigChangeTime() {
        return this.configChangeTime;
    }

    public Long getTradeSize() {
        return this.tradeSize;
    }

    public Integer getPositionSize() {
        return this.positionSize;
    }

    public Integer getLongUsers() {
        return this.longUsers;
    }

    public String getFundingImpactValue() {
        return this.fundingImpactValue;
    }

    public Integer getOrdersLimit() {
        return this.ordersLimit;
    }

    public Long getTradeId() {
        return this.tradeId;
    }

    public Long getOrderbookId() {
        return this.orderbookId;
    }

    public Boolean getEnableBonus() {
        return this.enableBonus;
    }

    public Boolean getEnableCredit() {
        return this.enableCredit;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getFundingCapRatio() {
        return this.fundingCapRatio;
    }

    public String getCrossLeverageDefault() {
        return this.crossLeverageDefault;
    }

    public String getVoucherLeverage() {
        return this.voucherLeverage;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonDeserialize(using=ContractTypeDeserializer.class)
    @JsonProperty(value="type")
    public void setType(ContractType type) {
        this.type = type;
    }

    @JsonProperty(value="quanto_multiplier")
    public void setQuantoMultiplier(String quantoMultiplier) {
        this.quantoMultiplier = quantoMultiplier;
    }

    @JsonProperty(value="ref_discount_rate")
    public void setRefDiscountRate(String refDiscountRate) {
        this.refDiscountRate = refDiscountRate;
    }

    @JsonProperty(value="order_price_deviate")
    public void setOrderPriceDeviate(String orderPriceDeviate) {
        this.orderPriceDeviate = orderPriceDeviate;
    }

    @JsonProperty(value="maintenance_rate")
    public void setMaintenanceRate(String maintenanceRate) {
        this.maintenanceRate = maintenanceRate;
    }

    @JsonProperty(value="mark_type")
    public void setMarkType(String markType) {
        this.markType = markType;
    }

    @JsonProperty(value="last_price")
    public void setLastPrice(String lastPrice) {
        this.lastPrice = lastPrice;
    }

    @JsonProperty(value="mark_price")
    public void setMarkPrice(String markPrice) {
        this.markPrice = markPrice;
    }

    @JsonProperty(value="index_price")
    public void setIndexPrice(String indexPrice) {
        this.indexPrice = indexPrice;
    }

    @JsonProperty(value="funding_rate_indicative")
    public void setFundingRateIndicative(String fundingRateIndicative) {
        this.fundingRateIndicative = fundingRateIndicative;
    }

    @JsonProperty(value="mark_price_round")
    public void setMarkPriceRound(String markPriceRound) {
        this.markPriceRound = markPriceRound;
    }

    @JsonProperty(value="funding_offset")
    public void setFundingOffset(Integer fundingOffset) {
        this.fundingOffset = fundingOffset;
    }

    @JsonProperty(value="in_delisting")
    public void setInDelisting(Boolean inDelisting) {
        this.inDelisting = inDelisting;
    }

    @JsonProperty(value="risk_limit_base")
    public void setRiskLimitBase(String riskLimitBase) {
        this.riskLimitBase = riskLimitBase;
    }

    @JsonProperty(value="interest_rate")
    public void setInterestRate(String interestRate) {
        this.interestRate = interestRate;
    }

    @JsonProperty(value="order_price_round")
    public void setOrderPriceRound(String orderPriceRound) {
        this.orderPriceRound = orderPriceRound;
    }

    @JsonProperty(value="order_size_min")
    public void setOrderSizeMin(Integer orderSizeMin) {
        this.orderSizeMin = orderSizeMin;
    }

    @JsonProperty(value="ref_rebate_rate")
    public void setRefRebateRate(String refRebateRate) {
        this.refRebateRate = refRebateRate;
    }

    @JsonProperty(value="funding_interval")
    public void setFundingInterval(Integer fundingInterval) {
        this.fundingInterval = fundingInterval;
    }

    @JsonProperty(value="risk_limit_step")
    public void setRiskLimitStep(String riskLimitStep) {
        this.riskLimitStep = riskLimitStep;
    }

    @JsonProperty(value="leverage_min")
    public void setLeverageMin(String leverageMin) {
        this.leverageMin = leverageMin;
    }

    @JsonProperty(value="leverage_max")
    public void setLeverageMax(String leverageMax) {
        this.leverageMax = leverageMax;
    }

    @JsonProperty(value="risk_limit_max")
    public void setRiskLimitMax(String riskLimitMax) {
        this.riskLimitMax = riskLimitMax;
    }

    @JsonProperty(value="maker_fee_rate")
    public void setMakerFeeRate(String makerFeeRate) {
        this.makerFeeRate = makerFeeRate;
    }

    @JsonProperty(value="taker_fee_rate")
    public void setTakerFeeRate(String takerFeeRate) {
        this.takerFeeRate = takerFeeRate;
    }

    @JsonProperty(value="funding_rate")
    public void setFundingRate(String fundingRate) {
        this.fundingRate = fundingRate;
    }

    @JsonProperty(value="order_size_max")
    public void setOrderSizeMax(Integer orderSizeMax) {
        this.orderSizeMax = orderSizeMax;
    }

    @JsonProperty(value="funding_next_apply")
    public void setFundingNextApply(Long fundingNextApply) {
        this.fundingNextApply = fundingNextApply;
    }

    @JsonProperty(value="short_users")
    public void setShortUsers(Integer shortUsers) {
        this.shortUsers = shortUsers;
    }

    @JsonProperty(value="config_change_time")
    public void setConfigChangeTime(Long configChangeTime) {
        this.configChangeTime = configChangeTime;
    }

    @JsonProperty(value="trade_size")
    public void setTradeSize(Long tradeSize) {
        this.tradeSize = tradeSize;
    }

    @JsonProperty(value="position_size")
    public void setPositionSize(Integer positionSize) {
        this.positionSize = positionSize;
    }

    @JsonProperty(value="long_users")
    public void setLongUsers(Integer longUsers) {
        this.longUsers = longUsers;
    }

    @JsonProperty(value="funding_impact_value")
    public void setFundingImpactValue(String fundingImpactValue) {
        this.fundingImpactValue = fundingImpactValue;
    }

    @JsonProperty(value="orders_limit")
    public void setOrdersLimit(Integer ordersLimit) {
        this.ordersLimit = ordersLimit;
    }

    @JsonProperty(value="trade_id")
    public void setTradeId(Long tradeId) {
        this.tradeId = tradeId;
    }

    @JsonProperty(value="orderbook_id")
    public void setOrderbookId(Long orderbookId) {
        this.orderbookId = orderbookId;
    }

    @JsonProperty(value="enable_bonus")
    public void setEnableBonus(Boolean enableBonus) {
        this.enableBonus = enableBonus;
    }

    @JsonProperty(value="enable_credit")
    public void setEnableCredit(Boolean enableCredit) {
        this.enableCredit = enableCredit;
    }

    @JsonProperty(value="create_time")
    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @JsonProperty(value="funding_cap_ratio")
    public void setFundingCapRatio(String fundingCapRatio) {
        this.fundingCapRatio = fundingCapRatio;
    }

    @JsonProperty(value="cross_leverage_default")
    public void setCrossLeverageDefault(String crossLeverageDefault) {
        this.crossLeverageDefault = crossLeverageDefault;
    }

    @JsonProperty(value="voucher_leverage")
    public void setVoucherLeverage(String voucherLeverage) {
        this.voucherLeverage = voucherLeverage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PerpetualTicker)) {
            return false;
        }
        PerpetualTicker other = (PerpetualTicker)o;
        Integer this$fundingOffset = this.getFundingOffset();
        Integer other$fundingOffset = other.getFundingOffset();
        if (this$fundingOffset == null ? other$fundingOffset != null : !((Object)this$fundingOffset).equals(other$fundingOffset)) {
            return false;
        }
        Boolean this$inDelisting = this.getInDelisting();
        Boolean other$inDelisting = other.getInDelisting();
        if (this$inDelisting == null ? other$inDelisting != null : !((Object)this$inDelisting).equals(other$inDelisting)) {
            return false;
        }
        Integer this$orderSizeMin = this.getOrderSizeMin();
        Integer other$orderSizeMin = other.getOrderSizeMin();
        if (this$orderSizeMin == null ? other$orderSizeMin != null : !((Object)this$orderSizeMin).equals(other$orderSizeMin)) {
            return false;
        }
        Integer this$fundingInterval = this.getFundingInterval();
        Integer other$fundingInterval = other.getFundingInterval();
        if (this$fundingInterval == null ? other$fundingInterval != null : !((Object)this$fundingInterval).equals(other$fundingInterval)) {
            return false;
        }
        Integer this$orderSizeMax = this.getOrderSizeMax();
        Integer other$orderSizeMax = other.getOrderSizeMax();
        if (this$orderSizeMax == null ? other$orderSizeMax != null : !((Object)this$orderSizeMax).equals(other$orderSizeMax)) {
            return false;
        }
        Long this$fundingNextApply = this.getFundingNextApply();
        Long other$fundingNextApply = other.getFundingNextApply();
        if (this$fundingNextApply == null ? other$fundingNextApply != null : !((Object)this$fundingNextApply).equals(other$fundingNextApply)) {
            return false;
        }
        Integer this$shortUsers = this.getShortUsers();
        Integer other$shortUsers = other.getShortUsers();
        if (this$shortUsers == null ? other$shortUsers != null : !((Object)this$shortUsers).equals(other$shortUsers)) {
            return false;
        }
        Long this$configChangeTime = this.getConfigChangeTime();
        Long other$configChangeTime = other.getConfigChangeTime();
        if (this$configChangeTime == null ? other$configChangeTime != null : !((Object)this$configChangeTime).equals(other$configChangeTime)) {
            return false;
        }
        Long this$tradeSize = this.getTradeSize();
        Long other$tradeSize = other.getTradeSize();
        if (this$tradeSize == null ? other$tradeSize != null : !((Object)this$tradeSize).equals(other$tradeSize)) {
            return false;
        }
        Integer this$positionSize = this.getPositionSize();
        Integer other$positionSize = other.getPositionSize();
        if (this$positionSize == null ? other$positionSize != null : !((Object)this$positionSize).equals(other$positionSize)) {
            return false;
        }
        Integer this$longUsers = this.getLongUsers();
        Integer other$longUsers = other.getLongUsers();
        if (this$longUsers == null ? other$longUsers != null : !((Object)this$longUsers).equals(other$longUsers)) {
            return false;
        }
        Integer this$ordersLimit = this.getOrdersLimit();
        Integer other$ordersLimit = other.getOrdersLimit();
        if (this$ordersLimit == null ? other$ordersLimit != null : !((Object)this$ordersLimit).equals(other$ordersLimit)) {
            return false;
        }
        Long this$tradeId = this.getTradeId();
        Long other$tradeId = other.getTradeId();
        if (this$tradeId == null ? other$tradeId != null : !((Object)this$tradeId).equals(other$tradeId)) {
            return false;
        }
        Long this$orderbookId = this.getOrderbookId();
        Long other$orderbookId = other.getOrderbookId();
        if (this$orderbookId == null ? other$orderbookId != null : !((Object)this$orderbookId).equals(other$orderbookId)) {
            return false;
        }
        Boolean this$enableBonus = this.getEnableBonus();
        Boolean other$enableBonus = other.getEnableBonus();
        if (this$enableBonus == null ? other$enableBonus != null : !((Object)this$enableBonus).equals(other$enableBonus)) {
            return false;
        }
        Boolean this$enableCredit = this.getEnableCredit();
        Boolean other$enableCredit = other.getEnableCredit();
        if (this$enableCredit == null ? other$enableCredit != null : !((Object)this$enableCredit).equals(other$enableCredit)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ContractType this$type = this.getType();
        ContractType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$quantoMultiplier = this.getQuantoMultiplier();
        String other$quantoMultiplier = other.getQuantoMultiplier();
        if (this$quantoMultiplier == null ? other$quantoMultiplier != null : !this$quantoMultiplier.equals(other$quantoMultiplier)) {
            return false;
        }
        String this$refDiscountRate = this.getRefDiscountRate();
        String other$refDiscountRate = other.getRefDiscountRate();
        if (this$refDiscountRate == null ? other$refDiscountRate != null : !this$refDiscountRate.equals(other$refDiscountRate)) {
            return false;
        }
        String this$orderPriceDeviate = this.getOrderPriceDeviate();
        String other$orderPriceDeviate = other.getOrderPriceDeviate();
        if (this$orderPriceDeviate == null ? other$orderPriceDeviate != null : !this$orderPriceDeviate.equals(other$orderPriceDeviate)) {
            return false;
        }
        String this$maintenanceRate = this.getMaintenanceRate();
        String other$maintenanceRate = other.getMaintenanceRate();
        if (this$maintenanceRate == null ? other$maintenanceRate != null : !this$maintenanceRate.equals(other$maintenanceRate)) {
            return false;
        }
        String this$markType = this.getMarkType();
        String other$markType = other.getMarkType();
        if (this$markType == null ? other$markType != null : !this$markType.equals(other$markType)) {
            return false;
        }
        String this$lastPrice = this.getLastPrice();
        String other$lastPrice = other.getLastPrice();
        if (this$lastPrice == null ? other$lastPrice != null : !this$lastPrice.equals(other$lastPrice)) {
            return false;
        }
        String this$markPrice = this.getMarkPrice();
        String other$markPrice = other.getMarkPrice();
        if (this$markPrice == null ? other$markPrice != null : !this$markPrice.equals(other$markPrice)) {
            return false;
        }
        String this$indexPrice = this.getIndexPrice();
        String other$indexPrice = other.getIndexPrice();
        if (this$indexPrice == null ? other$indexPrice != null : !this$indexPrice.equals(other$indexPrice)) {
            return false;
        }
        String this$fundingRateIndicative = this.getFundingRateIndicative();
        String other$fundingRateIndicative = other.getFundingRateIndicative();
        if (this$fundingRateIndicative == null ? other$fundingRateIndicative != null : !this$fundingRateIndicative.equals(other$fundingRateIndicative)) {
            return false;
        }
        String this$markPriceRound = this.getMarkPriceRound();
        String other$markPriceRound = other.getMarkPriceRound();
        if (this$markPriceRound == null ? other$markPriceRound != null : !this$markPriceRound.equals(other$markPriceRound)) {
            return false;
        }
        String this$riskLimitBase = this.getRiskLimitBase();
        String other$riskLimitBase = other.getRiskLimitBase();
        if (this$riskLimitBase == null ? other$riskLimitBase != null : !this$riskLimitBase.equals(other$riskLimitBase)) {
            return false;
        }
        String this$interestRate = this.getInterestRate();
        String other$interestRate = other.getInterestRate();
        if (this$interestRate == null ? other$interestRate != null : !this$interestRate.equals(other$interestRate)) {
            return false;
        }
        String this$orderPriceRound = this.getOrderPriceRound();
        String other$orderPriceRound = other.getOrderPriceRound();
        if (this$orderPriceRound == null ? other$orderPriceRound != null : !this$orderPriceRound.equals(other$orderPriceRound)) {
            return false;
        }
        String this$refRebateRate = this.getRefRebateRate();
        String other$refRebateRate = other.getRefRebateRate();
        if (this$refRebateRate == null ? other$refRebateRate != null : !this$refRebateRate.equals(other$refRebateRate)) {
            return false;
        }
        String this$riskLimitStep = this.getRiskLimitStep();
        String other$riskLimitStep = other.getRiskLimitStep();
        if (this$riskLimitStep == null ? other$riskLimitStep != null : !this$riskLimitStep.equals(other$riskLimitStep)) {
            return false;
        }
        String this$leverageMin = this.getLeverageMin();
        String other$leverageMin = other.getLeverageMin();
        if (this$leverageMin == null ? other$leverageMin != null : !this$leverageMin.equals(other$leverageMin)) {
            return false;
        }
        String this$leverageMax = this.getLeverageMax();
        String other$leverageMax = other.getLeverageMax();
        if (this$leverageMax == null ? other$leverageMax != null : !this$leverageMax.equals(other$leverageMax)) {
            return false;
        }
        String this$riskLimitMax = this.getRiskLimitMax();
        String other$riskLimitMax = other.getRiskLimitMax();
        if (this$riskLimitMax == null ? other$riskLimitMax != null : !this$riskLimitMax.equals(other$riskLimitMax)) {
            return false;
        }
        String this$makerFeeRate = this.getMakerFeeRate();
        String other$makerFeeRate = other.getMakerFeeRate();
        if (this$makerFeeRate == null ? other$makerFeeRate != null : !this$makerFeeRate.equals(other$makerFeeRate)) {
            return false;
        }
        String this$takerFeeRate = this.getTakerFeeRate();
        String other$takerFeeRate = other.getTakerFeeRate();
        if (this$takerFeeRate == null ? other$takerFeeRate != null : !this$takerFeeRate.equals(other$takerFeeRate)) {
            return false;
        }
        String this$fundingRate = this.getFundingRate();
        String other$fundingRate = other.getFundingRate();
        if (this$fundingRate == null ? other$fundingRate != null : !this$fundingRate.equals(other$fundingRate)) {
            return false;
        }
        String this$fundingImpactValue = this.getFundingImpactValue();
        String other$fundingImpactValue = other.getFundingImpactValue();
        if (this$fundingImpactValue == null ? other$fundingImpactValue != null : !this$fundingImpactValue.equals(other$fundingImpactValue)) {
            return false;
        }
        String this$fundingCapRatio = this.getFundingCapRatio();
        String other$fundingCapRatio = other.getFundingCapRatio();
        if (this$fundingCapRatio == null ? other$fundingCapRatio != null : !this$fundingCapRatio.equals(other$fundingCapRatio)) {
            return false;
        }
        String this$crossLeverageDefault = this.getCrossLeverageDefault();
        String other$crossLeverageDefault = other.getCrossLeverageDefault();
        if (this$crossLeverageDefault == null ? other$crossLeverageDefault != null : !this$crossLeverageDefault.equals(other$crossLeverageDefault)) {
            return false;
        }
        String this$voucherLeverage = this.getVoucherLeverage();
        String other$voucherLeverage = other.getVoucherLeverage();
        return !(this$voucherLeverage == null ? other$voucherLeverage != null : !this$voucherLeverage.equals(other$voucherLeverage));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $fundingOffset = this.getFundingOffset();
        result = result * 59 + ($fundingOffset == null ? 43 : ((Object)$fundingOffset).hashCode());
        Boolean $inDelisting = this.getInDelisting();
        result = result * 59 + ($inDelisting == null ? 43 : ((Object)$inDelisting).hashCode());
        Integer $orderSizeMin = this.getOrderSizeMin();
        result = result * 59 + ($orderSizeMin == null ? 43 : ((Object)$orderSizeMin).hashCode());
        Integer $fundingInterval = this.getFundingInterval();
        result = result * 59 + ($fundingInterval == null ? 43 : ((Object)$fundingInterval).hashCode());
        Integer $orderSizeMax = this.getOrderSizeMax();
        result = result * 59 + ($orderSizeMax == null ? 43 : ((Object)$orderSizeMax).hashCode());
        Long $fundingNextApply = this.getFundingNextApply();
        result = result * 59 + ($fundingNextApply == null ? 43 : ((Object)$fundingNextApply).hashCode());
        Integer $shortUsers = this.getShortUsers();
        result = result * 59 + ($shortUsers == null ? 43 : ((Object)$shortUsers).hashCode());
        Long $configChangeTime = this.getConfigChangeTime();
        result = result * 59 + ($configChangeTime == null ? 43 : ((Object)$configChangeTime).hashCode());
        Long $tradeSize = this.getTradeSize();
        result = result * 59 + ($tradeSize == null ? 43 : ((Object)$tradeSize).hashCode());
        Integer $positionSize = this.getPositionSize();
        result = result * 59 + ($positionSize == null ? 43 : ((Object)$positionSize).hashCode());
        Integer $longUsers = this.getLongUsers();
        result = result * 59 + ($longUsers == null ? 43 : ((Object)$longUsers).hashCode());
        Integer $ordersLimit = this.getOrdersLimit();
        result = result * 59 + ($ordersLimit == null ? 43 : ((Object)$ordersLimit).hashCode());
        Long $tradeId = this.getTradeId();
        result = result * 59 + ($tradeId == null ? 43 : ((Object)$tradeId).hashCode());
        Long $orderbookId = this.getOrderbookId();
        result = result * 59 + ($orderbookId == null ? 43 : ((Object)$orderbookId).hashCode());
        Boolean $enableBonus = this.getEnableBonus();
        result = result * 59 + ($enableBonus == null ? 43 : ((Object)$enableBonus).hashCode());
        Boolean $enableCredit = this.getEnableCredit();
        result = result * 59 + ($enableCredit == null ? 43 : ((Object)$enableCredit).hashCode());
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ContractType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $quantoMultiplier = this.getQuantoMultiplier();
        result = result * 59 + ($quantoMultiplier == null ? 43 : $quantoMultiplier.hashCode());
        String $refDiscountRate = this.getRefDiscountRate();
        result = result * 59 + ($refDiscountRate == null ? 43 : $refDiscountRate.hashCode());
        String $orderPriceDeviate = this.getOrderPriceDeviate();
        result = result * 59 + ($orderPriceDeviate == null ? 43 : $orderPriceDeviate.hashCode());
        String $maintenanceRate = this.getMaintenanceRate();
        result = result * 59 + ($maintenanceRate == null ? 43 : $maintenanceRate.hashCode());
        String $markType = this.getMarkType();
        result = result * 59 + ($markType == null ? 43 : $markType.hashCode());
        String $lastPrice = this.getLastPrice();
        result = result * 59 + ($lastPrice == null ? 43 : $lastPrice.hashCode());
        String $markPrice = this.getMarkPrice();
        result = result * 59 + ($markPrice == null ? 43 : $markPrice.hashCode());
        String $indexPrice = this.getIndexPrice();
        result = result * 59 + ($indexPrice == null ? 43 : $indexPrice.hashCode());
        String $fundingRateIndicative = this.getFundingRateIndicative();
        result = result * 59 + ($fundingRateIndicative == null ? 43 : $fundingRateIndicative.hashCode());
        String $markPriceRound = this.getMarkPriceRound();
        result = result * 59 + ($markPriceRound == null ? 43 : $markPriceRound.hashCode());
        String $riskLimitBase = this.getRiskLimitBase();
        result = result * 59 + ($riskLimitBase == null ? 43 : $riskLimitBase.hashCode());
        String $interestRate = this.getInterestRate();
        result = result * 59 + ($interestRate == null ? 43 : $interestRate.hashCode());
        String $orderPriceRound = this.getOrderPriceRound();
        result = result * 59 + ($orderPriceRound == null ? 43 : $orderPriceRound.hashCode());
        String $refRebateRate = this.getRefRebateRate();
        result = result * 59 + ($refRebateRate == null ? 43 : $refRebateRate.hashCode());
        String $riskLimitStep = this.getRiskLimitStep();
        result = result * 59 + ($riskLimitStep == null ? 43 : $riskLimitStep.hashCode());
        String $leverageMin = this.getLeverageMin();
        result = result * 59 + ($leverageMin == null ? 43 : $leverageMin.hashCode());
        String $leverageMax = this.getLeverageMax();
        result = result * 59 + ($leverageMax == null ? 43 : $leverageMax.hashCode());
        String $riskLimitMax = this.getRiskLimitMax();
        result = result * 59 + ($riskLimitMax == null ? 43 : $riskLimitMax.hashCode());
        String $makerFeeRate = this.getMakerFeeRate();
        result = result * 59 + ($makerFeeRate == null ? 43 : $makerFeeRate.hashCode());
        String $takerFeeRate = this.getTakerFeeRate();
        result = result * 59 + ($takerFeeRate == null ? 43 : $takerFeeRate.hashCode());
        String $fundingRate = this.getFundingRate();
        result = result * 59 + ($fundingRate == null ? 43 : $fundingRate.hashCode());
        String $fundingImpactValue = this.getFundingImpactValue();
        result = result * 59 + ($fundingImpactValue == null ? 43 : $fundingImpactValue.hashCode());
        String $fundingCapRatio = this.getFundingCapRatio();
        result = result * 59 + ($fundingCapRatio == null ? 43 : $fundingCapRatio.hashCode());
        String $crossLeverageDefault = this.getCrossLeverageDefault();
        result = result * 59 + ($crossLeverageDefault == null ? 43 : $crossLeverageDefault.hashCode());
        String $voucherLeverage = this.getVoucherLeverage();
        result = result * 59 + ($voucherLeverage == null ? 43 : $voucherLeverage.hashCode());
        return result;
    }

    public String toString() {
        return "PerpetualTicker(name=" + this.getName() + ", type=" + this.getType() + ", quantoMultiplier=" + this.getQuantoMultiplier() + ", refDiscountRate=" + this.getRefDiscountRate() + ", orderPriceDeviate=" + this.getOrderPriceDeviate() + ", maintenanceRate=" + this.getMaintenanceRate() + ", markType=" + this.getMarkType() + ", lastPrice=" + this.getLastPrice() + ", markPrice=" + this.getMarkPrice() + ", indexPrice=" + this.getIndexPrice() + ", fundingRateIndicative=" + this.getFundingRateIndicative() + ", markPriceRound=" + this.getMarkPriceRound() + ", fundingOffset=" + this.getFundingOffset() + ", inDelisting=" + this.getInDelisting() + ", riskLimitBase=" + this.getRiskLimitBase() + ", interestRate=" + this.getInterestRate() + ", orderPriceRound=" + this.getOrderPriceRound() + ", orderSizeMin=" + this.getOrderSizeMin() + ", refRebateRate=" + this.getRefRebateRate() + ", fundingInterval=" + this.getFundingInterval() + ", riskLimitStep=" + this.getRiskLimitStep() + ", leverageMin=" + this.getLeverageMin() + ", leverageMax=" + this.getLeverageMax() + ", riskLimitMax=" + this.getRiskLimitMax() + ", makerFeeRate=" + this.getMakerFeeRate() + ", takerFeeRate=" + this.getTakerFeeRate() + ", fundingRate=" + this.getFundingRate() + ", orderSizeMax=" + this.getOrderSizeMax() + ", fundingNextApply=" + this.getFundingNextApply() + ", shortUsers=" + this.getShortUsers() + ", configChangeTime=" + this.getConfigChangeTime() + ", tradeSize=" + this.getTradeSize() + ", positionSize=" + this.getPositionSize() + ", longUsers=" + this.getLongUsers() + ", fundingImpactValue=" + this.getFundingImpactValue() + ", ordersLimit=" + this.getOrdersLimit() + ", tradeId=" + this.getTradeId() + ", orderbookId=" + this.getOrderbookId() + ", enableBonus=" + this.getEnableBonus() + ", enableCredit=" + this.getEnableCredit() + ", createTime=" + this.getCreateTime() + ", fundingCapRatio=" + this.getFundingCapRatio() + ", crossLeverageDefault=" + this.getCrossLeverageDefault() + ", voucherLeverage=" + this.getVoucherLeverage() + ")";
    }
}

