/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CancelOrderAction {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="cancels")
    private List<CancelOrder> cancels;

    public static CancelOrderAction cancelByOrderId(int assetId, long orderId) {
        return CancelOrderAction.builder().type("cancel").cancels(List.of(new CancelOrder(assetId, orderId, null, null))).build();
    }

    public static CancelOrderAction cancelByClientOrderId(int assetId, String clientOrderId) {
        return CancelOrderAction.builder().type("cancelByCloid").cancels(List.of(new CancelOrder(null, null, assetId, clientOrderId))).build();
    }

    CancelOrderAction(String type, List<CancelOrder> cancels) {
        this.type = type;
        this.cancels = cancels;
    }

    public static CancelOrderActionBuilder builder() {
        return new CancelOrderActionBuilder();
    }

    public String getType() {
        return this.type;
    }

    public List<CancelOrder> getCancels() {
        return this.cancels;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="cancels")
    public void setCancels(List<CancelOrder> cancels) {
        this.cancels = cancels;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CancelOrderAction)) {
            return false;
        }
        CancelOrderAction other = (CancelOrderAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<CancelOrder> this$cancels = this.getCancels();
        List<CancelOrder> other$cancels = other.getCancels();
        return !(this$cancels == null ? other$cancels != null : !((Object)this$cancels).equals(other$cancels));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CancelOrderAction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<CancelOrder> $cancels = this.getCancels();
        result = result * 59 + ($cancels == null ? 43 : ((Object)$cancels).hashCode());
        return result;
    }

    public String toString() {
        return "CancelOrderAction(type=" + this.getType() + ", cancels=" + this.getCancels() + ")";
    }

    public static class CancelOrderActionBuilder {
        private String type;
        private List<CancelOrder> cancels;

        CancelOrderActionBuilder() {
        }

        @JsonProperty(value="type")
        public CancelOrderActionBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="cancels")
        public CancelOrderActionBuilder cancels(List<CancelOrder> cancels) {
            this.cancels = cancels;
            return this;
        }

        public CancelOrderAction build() {
            return new CancelOrderAction(this.type, this.cancels);
        }

        public String toString() {
            return "CancelOrderAction.CancelOrderActionBuilder(type=" + this.type + ", cancels=" + this.cancels + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class CancelOrder {
        @JsonProperty(value="a")
        private Integer a;
        @JsonProperty(value="o")
        private Long orderId;
        @JsonProperty(value="asset")
        private Integer asset;
        @JsonProperty(value="cloid")
        private String clientOrderId;

        public Integer getA() {
            return this.a;
        }

        public Long getOrderId() {
            return this.orderId;
        }

        public Integer getAsset() {
            return this.asset;
        }

        public String getClientOrderId() {
            return this.clientOrderId;
        }

        @JsonProperty(value="a")
        public void setA(Integer a) {
            this.a = a;
        }

        @JsonProperty(value="o")
        public void setOrderId(Long orderId) {
            this.orderId = orderId;
        }

        @JsonProperty(value="asset")
        public void setAsset(Integer asset) {
            this.asset = asset;
        }

        @JsonProperty(value="cloid")
        public void setClientOrderId(String clientOrderId) {
            this.clientOrderId = clientOrderId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CancelOrder)) {
                return false;
            }
            CancelOrder other = (CancelOrder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$a = this.getA();
            Integer other$a = other.getA();
            if (this$a == null ? other$a != null : !((Object)this$a).equals(other$a)) {
                return false;
            }
            Long this$orderId = this.getOrderId();
            Long other$orderId = other.getOrderId();
            if (this$orderId == null ? other$orderId != null : !((Object)this$orderId).equals(other$orderId)) {
                return false;
            }
            Integer this$asset = this.getAsset();
            Integer other$asset = other.getAsset();
            if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
                return false;
            }
            String this$clientOrderId = this.getClientOrderId();
            String other$clientOrderId = other.getClientOrderId();
            return !(this$clientOrderId == null ? other$clientOrderId != null : !this$clientOrderId.equals(other$clientOrderId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CancelOrder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $a = this.getA();
            result = result * 59 + ($a == null ? 43 : ((Object)$a).hashCode());
            Long $orderId = this.getOrderId();
            result = result * 59 + ($orderId == null ? 43 : ((Object)$orderId).hashCode());
            Integer $asset = this.getAsset();
            result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
            String $clientOrderId = this.getClientOrderId();
            result = result * 59 + ($clientOrderId == null ? 43 : $clientOrderId.hashCode());
            return result;
        }

        public String toString() {
            return "CancelOrderAction.CancelOrder(a=" + this.getA() + ", orderId=" + this.getOrderId() + ", asset=" + this.getAsset() + ", clientOrderId=" + this.getClientOrderId() + ")";
        }

        public CancelOrder(Integer a, Long orderId, Integer asset, String clientOrderId) {
            this.a = a;
            this.orderId = orderId;
            this.asset = asset;
            this.clientOrderId = clientOrderId;
        }
    }
}

