/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.types.Tif;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"type", "orders", "grouping"})
public class CreateOrderAction {
    @JsonProperty(value="orders")
    private List<HyperliquidOrder> orders = new ArrayList<HyperliquidOrder>();
    @JsonProperty(value="grouping")
    private String grouping = "na";

    @JsonProperty(value="type")
    public String getType() {
        return "order";
    }

    public static CreateOrderAction createOrder(HyperliquidOrder order) {
        CreateOrderAction orderRequest = new CreateOrderAction();
        orderRequest.setOrders(List.of(order));
        return orderRequest;
    }

    public List<HyperliquidOrder> getOrders() {
        return this.orders;
    }

    public String getGrouping() {
        return this.grouping;
    }

    @JsonProperty(value="orders")
    public void setOrders(List<HyperliquidOrder> orders) {
        this.orders = orders;
    }

    @JsonProperty(value="grouping")
    public void setGrouping(String grouping) {
        this.grouping = grouping;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateOrderAction)) {
            return false;
        }
        CreateOrderAction other = (CreateOrderAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<HyperliquidOrder> this$orders = this.getOrders();
        List<HyperliquidOrder> other$orders = other.getOrders();
        if (this$orders == null ? other$orders != null : !((Object)this$orders).equals(other$orders)) {
            return false;
        }
        String this$grouping = this.getGrouping();
        String other$grouping = other.getGrouping();
        return !(this$grouping == null ? other$grouping != null : !this$grouping.equals(other$grouping));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateOrderAction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<HyperliquidOrder> $orders = this.getOrders();
        result = result * 59 + ($orders == null ? 43 : ((Object)$orders).hashCode());
        String $grouping = this.getGrouping();
        result = result * 59 + ($grouping == null ? 43 : $grouping.hashCode());
        return result;
    }

    public String toString() {
        return "CreateOrderAction(orders=" + this.getOrders() + ", grouping=" + this.getGrouping() + ")";
    }

    public static class Trigger {
        @JsonProperty(value="triggerPx")
        private String triggerPx;
        @JsonProperty(value="isMarket")
        private boolean isMarket;
        @JsonProperty(value="tpsl")
        private String tpsl;

        public String getTriggerPx() {
            return this.triggerPx;
        }

        public boolean isMarket() {
            return this.isMarket;
        }

        public String getTpsl() {
            return this.tpsl;
        }

        @JsonProperty(value="triggerPx")
        public void setTriggerPx(String triggerPx) {
            this.triggerPx = triggerPx;
        }

        @JsonProperty(value="isMarket")
        public void setMarket(boolean isMarket) {
            this.isMarket = isMarket;
        }

        @JsonProperty(value="tpsl")
        public void setTpsl(String tpsl) {
            this.tpsl = tpsl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Trigger)) {
                return false;
            }
            Trigger other = (Trigger)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isMarket() != other.isMarket()) {
                return false;
            }
            String this$triggerPx = this.getTriggerPx();
            String other$triggerPx = other.getTriggerPx();
            if (this$triggerPx == null ? other$triggerPx != null : !this$triggerPx.equals(other$triggerPx)) {
                return false;
            }
            String this$tpsl = this.getTpsl();
            String other$tpsl = other.getTpsl();
            return !(this$tpsl == null ? other$tpsl != null : !this$tpsl.equals(other$tpsl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Trigger;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMarket() ? 79 : 97);
            String $triggerPx = this.getTriggerPx();
            result = result * 59 + ($triggerPx == null ? 43 : $triggerPx.hashCode());
            String $tpsl = this.getTpsl();
            result = result * 59 + ($tpsl == null ? 43 : $tpsl.hashCode());
            return result;
        }

        public String toString() {
            return "CreateOrderAction.Trigger(triggerPx=" + this.getTriggerPx() + ", isMarket=" + this.isMarket() + ", tpsl=" + this.getTpsl() + ")";
        }

        public Trigger(String triggerPx, boolean isMarket, String tpsl) {
            this.triggerPx = triggerPx;
            this.isMarket = isMarket;
            this.tpsl = tpsl;
        }
    }

    public static class Limit {
        @JsonProperty(value="tif")
        private Tif tif;

        public Tif getTif() {
            return this.tif;
        }

        @JsonProperty(value="tif")
        public void setTif(Tif tif) {
            this.tif = tif;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Limit)) {
                return false;
            }
            Limit other = (Limit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Tif this$tif = this.getTif();
            Tif other$tif = other.getTif();
            return !(this$tif == null ? other$tif != null : !((Object)((Object)this$tif)).equals((Object)other$tif));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Limit;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Tif $tif = this.getTif();
            result = result * 59 + ($tif == null ? 43 : ((Object)((Object)$tif)).hashCode());
            return result;
        }

        public String toString() {
            return "CreateOrderAction.Limit(tif=" + this.getTif() + ")";
        }

        public Limit(Tif tif) {
            this.tif = tif;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class OrderType {
        @JsonProperty(value="limit")
        private Limit limit;
        @JsonProperty(value="trigger")
        private Trigger trigger;

        public Limit getLimit() {
            return this.limit;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        @JsonProperty(value="limit")
        public void setLimit(Limit limit) {
            this.limit = limit;
        }

        @JsonProperty(value="trigger")
        public void setTrigger(Trigger trigger) {
            this.trigger = trigger;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderType)) {
                return false;
            }
            OrderType other = (OrderType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Limit this$limit = this.getLimit();
            Limit other$limit = other.getLimit();
            if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
                return false;
            }
            Trigger this$trigger = this.getTrigger();
            Trigger other$trigger = other.getTrigger();
            return !(this$trigger == null ? other$trigger != null : !((Object)this$trigger).equals(other$trigger));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OrderType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Limit $limit = this.getLimit();
            result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
            Trigger $trigger = this.getTrigger();
            result = result * 59 + ($trigger == null ? 43 : ((Object)$trigger).hashCode());
            return result;
        }

        public String toString() {
            return "CreateOrderAction.OrderType(limit=" + this.getLimit() + ", trigger=" + this.getTrigger() + ")";
        }
    }

    @JsonPropertyOrder(value={"a", "b", "p", "s", "r", "t", "c"})
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class HyperliquidOrder {
        @JsonProperty(value="a")
        private int assetId;
        @JsonProperty(value="b")
        private boolean buy;
        @JsonProperty(value="p")
        private String price;
        @JsonProperty(value="s")
        private String size;
        @JsonProperty(value="r")
        private boolean reduceOnly;
        @JsonProperty(value="t")
        private OrderType orderType;
        @JsonProperty(value="c")
        private String clientOrderId;

        HyperliquidOrder(int assetId, boolean buy, String price, String size, boolean reduceOnly, OrderType orderType, String clientOrderId) {
            this.assetId = assetId;
            this.buy = buy;
            this.price = price;
            this.size = size;
            this.reduceOnly = reduceOnly;
            this.orderType = orderType;
            this.clientOrderId = clientOrderId;
        }

        public static HyperliquidOrderBuilder builder() {
            return new HyperliquidOrderBuilder();
        }

        public int getAssetId() {
            return this.assetId;
        }

        public boolean isBuy() {
            return this.buy;
        }

        public String getPrice() {
            return this.price;
        }

        public String getSize() {
            return this.size;
        }

        public boolean isReduceOnly() {
            return this.reduceOnly;
        }

        public OrderType getOrderType() {
            return this.orderType;
        }

        public String getClientOrderId() {
            return this.clientOrderId;
        }

        @JsonProperty(value="a")
        public void setAssetId(int assetId) {
            this.assetId = assetId;
        }

        @JsonProperty(value="b")
        public void setBuy(boolean buy) {
            this.buy = buy;
        }

        @JsonProperty(value="p")
        public void setPrice(String price) {
            this.price = price;
        }

        @JsonProperty(value="s")
        public void setSize(String size) {
            this.size = size;
        }

        @JsonProperty(value="r")
        public void setReduceOnly(boolean reduceOnly) {
            this.reduceOnly = reduceOnly;
        }

        @JsonProperty(value="t")
        public void setOrderType(OrderType orderType) {
            this.orderType = orderType;
        }

        @JsonProperty(value="c")
        public void setClientOrderId(String clientOrderId) {
            this.clientOrderId = clientOrderId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HyperliquidOrder)) {
                return false;
            }
            HyperliquidOrder other = (HyperliquidOrder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAssetId() != other.getAssetId()) {
                return false;
            }
            if (this.isBuy() != other.isBuy()) {
                return false;
            }
            if (this.isReduceOnly() != other.isReduceOnly()) {
                return false;
            }
            String this$price = this.getPrice();
            String other$price = other.getPrice();
            if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
                return false;
            }
            String this$size = this.getSize();
            String other$size = other.getSize();
            if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
                return false;
            }
            OrderType this$orderType = this.getOrderType();
            OrderType other$orderType = other.getOrderType();
            if (this$orderType == null ? other$orderType != null : !((Object)this$orderType).equals(other$orderType)) {
                return false;
            }
            String this$clientOrderId = this.getClientOrderId();
            String other$clientOrderId = other.getClientOrderId();
            return !(this$clientOrderId == null ? other$clientOrderId != null : !this$clientOrderId.equals(other$clientOrderId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HyperliquidOrder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAssetId();
            result = result * 59 + (this.isBuy() ? 79 : 97);
            result = result * 59 + (this.isReduceOnly() ? 79 : 97);
            String $price = this.getPrice();
            result = result * 59 + ($price == null ? 43 : $price.hashCode());
            String $size = this.getSize();
            result = result * 59 + ($size == null ? 43 : $size.hashCode());
            OrderType $orderType = this.getOrderType();
            result = result * 59 + ($orderType == null ? 43 : ((Object)$orderType).hashCode());
            String $clientOrderId = this.getClientOrderId();
            result = result * 59 + ($clientOrderId == null ? 43 : $clientOrderId.hashCode());
            return result;
        }

        public String toString() {
            return "CreateOrderAction.HyperliquidOrder(assetId=" + this.getAssetId() + ", buy=" + this.isBuy() + ", price=" + this.getPrice() + ", size=" + this.getSize() + ", reduceOnly=" + this.isReduceOnly() + ", orderType=" + this.getOrderType() + ", clientOrderId=" + this.getClientOrderId() + ")";
        }

        public static class HyperliquidOrderBuilder {
            private int assetId;
            private boolean buy;
            private String price;
            private String size;
            private boolean reduceOnly;
            private OrderType orderType;
            private String clientOrderId;

            HyperliquidOrderBuilder() {
            }

            @JsonProperty(value="a")
            public HyperliquidOrderBuilder assetId(int assetId) {
                this.assetId = assetId;
                return this;
            }

            @JsonProperty(value="b")
            public HyperliquidOrderBuilder buy(boolean buy) {
                this.buy = buy;
                return this;
            }

            @JsonProperty(value="p")
            public HyperliquidOrderBuilder price(String price) {
                this.price = price;
                return this;
            }

            @JsonProperty(value="s")
            public HyperliquidOrderBuilder size(String size) {
                this.size = size;
                return this;
            }

            @JsonProperty(value="r")
            public HyperliquidOrderBuilder reduceOnly(boolean reduceOnly) {
                this.reduceOnly = reduceOnly;
                return this;
            }

            @JsonProperty(value="t")
            public HyperliquidOrderBuilder orderType(OrderType orderType) {
                this.orderType = orderType;
                return this;
            }

            @JsonProperty(value="c")
            public HyperliquidOrderBuilder clientOrderId(String clientOrderId) {
                this.clientOrderId = clientOrderId;
                return this;
            }

            public HyperliquidOrder build() {
                return new HyperliquidOrder(this.assetId, this.buy, this.price, this.size, this.reduceOnly, this.orderType, this.clientOrderId);
            }

            public String toString() {
                return "CreateOrderAction.HyperliquidOrder.HyperliquidOrderBuilder(assetId=" + this.assetId + ", buy=" + this.buy + ", price=" + this.price + ", size=" + this.size + ", reduceOnly=" + this.reduceOnly + ", orderType=" + this.orderType + ", clientOrderId=" + this.clientOrderId + ")";
            }
        }
    }
}

