/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.types.OrderType;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.types.Tif;
import java.math.BigDecimal;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OrderRequest {
    private String symbol;
    private boolean buy;
    private BigDecimal price;
    private BigDecimal size;
    private OrderType type;
    private Tif tif;
    private String cloid;

    OrderRequest(String symbol, boolean buy, BigDecimal price, BigDecimal size, OrderType type, Tif tif, String cloid) {
        this.symbol = symbol;
        this.buy = buy;
        this.price = price;
        this.size = size;
        this.type = type;
        this.tif = tif;
        this.cloid = cloid;
    }

    public static OrderRequestBuilder builder() {
        return new OrderRequestBuilder();
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean isBuy() {
        return this.buy;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getSize() {
        return this.size;
    }

    public OrderType getType() {
        return this.type;
    }

    public Tif getTif() {
        return this.tif;
    }

    public String getCloid() {
        return this.cloid;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setBuy(boolean buy) {
        this.buy = buy;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public void setSize(BigDecimal size) {
        this.size = size;
    }

    public void setType(OrderType type) {
        this.type = type;
    }

    public void setTif(Tif tif) {
        this.tif = tif;
    }

    public void setCloid(String cloid) {
        this.cloid = cloid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderRequest)) {
            return false;
        }
        OrderRequest other = (OrderRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBuy() != other.isBuy()) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        BigDecimal this$price = this.getPrice();
        BigDecimal other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        BigDecimal this$size = this.getSize();
        BigDecimal other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        OrderType this$type = this.getType();
        OrderType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Tif this$tif = this.getTif();
        Tif other$tif = other.getTif();
        if (this$tif == null ? other$tif != null : !((Object)((Object)this$tif)).equals((Object)other$tif)) {
            return false;
        }
        String this$cloid = this.getCloid();
        String other$cloid = other.getCloid();
        return !(this$cloid == null ? other$cloid != null : !this$cloid.equals(other$cloid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBuy() ? 79 : 97);
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        BigDecimal $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        BigDecimal $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        OrderType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Tif $tif = this.getTif();
        result = result * 59 + ($tif == null ? 43 : ((Object)((Object)$tif)).hashCode());
        String $cloid = this.getCloid();
        result = result * 59 + ($cloid == null ? 43 : $cloid.hashCode());
        return result;
    }

    public String toString() {
        return "OrderRequest(symbol=" + this.getSymbol() + ", buy=" + this.isBuy() + ", price=" + this.getPrice() + ", size=" + this.getSize() + ", type=" + this.getType() + ", tif=" + this.getTif() + ", cloid=" + this.getCloid() + ")";
    }

    public static class OrderRequestBuilder {
        private String symbol;
        private boolean buy;
        private BigDecimal price;
        private BigDecimal size;
        private OrderType type;
        private Tif tif;
        private String cloid;

        OrderRequestBuilder() {
        }

        public OrderRequestBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public OrderRequestBuilder buy(boolean buy) {
            this.buy = buy;
            return this;
        }

        public OrderRequestBuilder price(BigDecimal price) {
            this.price = price;
            return this;
        }

        public OrderRequestBuilder size(BigDecimal size) {
            this.size = size;
            return this;
        }

        public OrderRequestBuilder type(OrderType type) {
            this.type = type;
            return this;
        }

        public OrderRequestBuilder tif(Tif tif) {
            this.tif = tif;
            return this;
        }

        public OrderRequestBuilder cloid(String cloid) {
            this.cloid = cloid;
            return this;
        }

        public OrderRequest build() {
            return new OrderRequest(this.symbol, this.buy, this.price, this.size, this.type, this.tif, this.cloid);
        }

        public String toString() {
            return "OrderRequest.OrderRequestBuilder(symbol=" + this.symbol + ", buy=" + this.buy + ", price=" + this.price + ", size=" + this.size + ", type=" + this.type + ", tif=" + this.tif + ", cloid=" + this.cloid + ")";
        }
    }
}

