/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.CreateAck;
import java.io.IOException;

public class CreateAckDeserializer
extends JsonDeserializer<CreateAck> {
    @Override
    public CreateAck deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        CreateAck ack = new CreateAck();
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        JsonNode rootNode = (JsonNode)mapper.readTree(p);
        JsonNode data = rootNode.get("data").get("statuses").get(0);
        if (data.has("error")) {
            ack.setOrderStatus("error");
            ack.setErrorMessage(data.get("error").asText());
        } else if (data.has("filled")) {
            JsonNode filled = data.get("filled");
            ack.setOrderStatus("filled");
            ack.setOrderId(filled.get("oid").asText());
            if (filled.has("cloid")) {
                ack.setClientOrderId(filled.get("cloid").asText());
            }
            ack.setTotalSz(filled.get("totalSz").asDouble());
            ack.setAvgPx(filled.get("avgPx").asDouble());
        } else if (data.has("resting")) {
            JsonNode resting = data.get("resting");
            ack.setOrderId(resting.get("oid").asText());
            ack.setOrderStatus("resting");
            if (resting.has("cloid")) {
                ack.setClientOrderId(resting.get("cloid").asText());
            }
        }
        return ack;
    }
}

