/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import estonlabs.cxtl.exchanges.a.specification.domain.Ack;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.ExchangeApiResponse;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ExchangeApiResponseDeserializer<T extends Ack>
extends JsonDeserializer<ExchangeApiResponse<T>> {
    private final Class<T> responseType;
    private final Class<? extends ExchangeApiResponse<T>> responseClass;

    public ExchangeApiResponseDeserializer(Class<T> responseType, Class<? extends ExchangeApiResponse<T>> responseClass) {
        this.responseType = responseType;
        this.responseClass = responseClass;
    }

    @Override
    public ExchangeApiResponse<T> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ExchangeApiResponse<Ack> response;
        block4: {
            ObjectMapper mapper = (ObjectMapper)p.getCodec();
            JsonNode rootNode = (JsonNode)mapper.readTree(p);
            String status = rootNode.get("status").asText();
            JsonNode responseNode = rootNode.get("response");
            response = null;
            try {
                response = this.createResponseObject(this.responseClass);
                response.setStatus(status);
                if ("ok".equals(status)) {
                    Ack result = (Ack)mapper.treeToValue((TreeNode)responseNode, this.responseType);
                    response.setAck(result);
                    break block4;
                }
                if ("err".equals(status)) {
                    String errorMessage = responseNode.asText();
                    response.setErrorMessage(errorMessage);
                    break block4;
                }
                throw new IllegalArgumentException("Unknown status: " + status);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Deserialization failed ", e);
            }
        }
        return response;
    }

    public ExchangeApiResponse<T> createResponseObject(Class<? extends ExchangeApiResponse<T>> responseClass) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Constructor<ExchangeApiResponse<T>> constructor = responseClass.getDeclaredConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }
}

