/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.exchanges.a.specification.domain.Order;
import estonlabs.cxtl.exchanges.a.specification.domain.SimpleOrderStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HyperliquidFilledOrder
implements Order {
    @JsonProperty(value="coin")
    private String symbol;
    @JsonProperty(value="limitPx")
    private Double lastOrAvgPx;
    @JsonProperty(value="oid")
    private String orderId;
    @JsonProperty(value="cloid")
    private String clOrdId;
    @JsonProperty(value="crossed")
    private boolean crossed;
    @JsonProperty(value="dir")
    private String dir;
    @JsonProperty(value="fee")
    private double fee;
    @JsonProperty(value="feeToken")
    private String feeToken;
    @JsonProperty(value="hash")
    private String hash;
    @JsonProperty(value="px")
    private String px;
    @JsonProperty(value="side")
    private String side;
    @JsonProperty(value="startPosition")
    private String startPosition;
    @JsonProperty(value="sz")
    private double cumQty;
    @JsonProperty(value="tid")
    private long tid;
    @JsonProperty(value="time")
    private long time;
    @JsonProperty(value="closedPnl")
    private double closedPnl;

    @Override
    public SimpleOrderStatus getSimpleStatus() {
        return SimpleOrderStatus.CLOSED;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public Double getLastOrAvgPx() {
        return this.lastOrAvgPx;
    }

    @Override
    public String getOrderId() {
        return this.orderId;
    }

    @Override
    public String getClOrdId() {
        return this.clOrdId;
    }

    public boolean isCrossed() {
        return this.crossed;
    }

    public String getDir() {
        return this.dir;
    }

    public double getFee() {
        return this.fee;
    }

    public String getFeeToken() {
        return this.feeToken;
    }

    public String getHash() {
        return this.hash;
    }

    public String getPx() {
        return this.px;
    }

    public String getSide() {
        return this.side;
    }

    public String getStartPosition() {
        return this.startPosition;
    }

    @Override
    public double getCumQty() {
        return this.cumQty;
    }

    public long getTid() {
        return this.tid;
    }

    public long getTime() {
        return this.time;
    }

    public double getClosedPnl() {
        return this.closedPnl;
    }

    @JsonProperty(value="coin")
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @JsonProperty(value="limitPx")
    public void setLastOrAvgPx(Double lastOrAvgPx) {
        this.lastOrAvgPx = lastOrAvgPx;
    }

    @JsonProperty(value="oid")
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    @JsonProperty(value="cloid")
    public void setClOrdId(String clOrdId) {
        this.clOrdId = clOrdId;
    }

    @JsonProperty(value="crossed")
    public void setCrossed(boolean crossed) {
        this.crossed = crossed;
    }

    @JsonProperty(value="dir")
    public void setDir(String dir) {
        this.dir = dir;
    }

    @JsonProperty(value="fee")
    public void setFee(double fee) {
        this.fee = fee;
    }

    @JsonProperty(value="feeToken")
    public void setFeeToken(String feeToken) {
        this.feeToken = feeToken;
    }

    @JsonProperty(value="hash")
    public void setHash(String hash) {
        this.hash = hash;
    }

    @JsonProperty(value="px")
    public void setPx(String px) {
        this.px = px;
    }

    @JsonProperty(value="side")
    public void setSide(String side) {
        this.side = side;
    }

    @JsonProperty(value="startPosition")
    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    @JsonProperty(value="sz")
    public void setCumQty(double cumQty) {
        this.cumQty = cumQty;
    }

    @JsonProperty(value="tid")
    public void setTid(long tid) {
        this.tid = tid;
    }

    @JsonProperty(value="time")
    public void setTime(long time) {
        this.time = time;
    }

    @JsonProperty(value="closedPnl")
    public void setClosedPnl(double closedPnl) {
        this.closedPnl = closedPnl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HyperliquidFilledOrder)) {
            return false;
        }
        HyperliquidFilledOrder other = (HyperliquidFilledOrder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCrossed() != other.isCrossed()) {
            return false;
        }
        if (Double.compare(this.getFee(), other.getFee()) != 0) {
            return false;
        }
        if (Double.compare(this.getCumQty(), other.getCumQty()) != 0) {
            return false;
        }
        if (this.getTid() != other.getTid()) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        if (Double.compare(this.getClosedPnl(), other.getClosedPnl()) != 0) {
            return false;
        }
        Double this$lastOrAvgPx = this.getLastOrAvgPx();
        Double other$lastOrAvgPx = other.getLastOrAvgPx();
        if (this$lastOrAvgPx == null ? other$lastOrAvgPx != null : !((Object)this$lastOrAvgPx).equals(other$lastOrAvgPx)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$clOrdId = this.getClOrdId();
        String other$clOrdId = other.getClOrdId();
        if (this$clOrdId == null ? other$clOrdId != null : !this$clOrdId.equals(other$clOrdId)) {
            return false;
        }
        String this$dir = this.getDir();
        String other$dir = other.getDir();
        if (this$dir == null ? other$dir != null : !this$dir.equals(other$dir)) {
            return false;
        }
        String this$feeToken = this.getFeeToken();
        String other$feeToken = other.getFeeToken();
        if (this$feeToken == null ? other$feeToken != null : !this$feeToken.equals(other$feeToken)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$px = this.getPx();
        String other$px = other.getPx();
        if (this$px == null ? other$px != null : !this$px.equals(other$px)) {
            return false;
        }
        String this$side = this.getSide();
        String other$side = other.getSide();
        if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
            return false;
        }
        String this$startPosition = this.getStartPosition();
        String other$startPosition = other.getStartPosition();
        return !(this$startPosition == null ? other$startPosition != null : !this$startPosition.equals(other$startPosition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HyperliquidFilledOrder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCrossed() ? 79 : 97);
        long $fee = Double.doubleToLongBits(this.getFee());
        result = result * 59 + (int)($fee >>> 32 ^ $fee);
        long $cumQty = Double.doubleToLongBits(this.getCumQty());
        result = result * 59 + (int)($cumQty >>> 32 ^ $cumQty);
        long $tid = this.getTid();
        result = result * 59 + (int)($tid >>> 32 ^ $tid);
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        long $closedPnl = Double.doubleToLongBits(this.getClosedPnl());
        result = result * 59 + (int)($closedPnl >>> 32 ^ $closedPnl);
        Double $lastOrAvgPx = this.getLastOrAvgPx();
        result = result * 59 + ($lastOrAvgPx == null ? 43 : ((Object)$lastOrAvgPx).hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $clOrdId = this.getClOrdId();
        result = result * 59 + ($clOrdId == null ? 43 : $clOrdId.hashCode());
        String $dir = this.getDir();
        result = result * 59 + ($dir == null ? 43 : $dir.hashCode());
        String $feeToken = this.getFeeToken();
        result = result * 59 + ($feeToken == null ? 43 : $feeToken.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $px = this.getPx();
        result = result * 59 + ($px == null ? 43 : $px.hashCode());
        String $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : $side.hashCode());
        String $startPosition = this.getStartPosition();
        result = result * 59 + ($startPosition == null ? 43 : $startPosition.hashCode());
        return result;
    }

    public String toString() {
        return "HyperliquidFilledOrder(symbol=" + this.getSymbol() + ", lastOrAvgPx=" + this.getLastOrAvgPx() + ", orderId=" + this.getOrderId() + ", clOrdId=" + this.getClOrdId() + ", crossed=" + this.isCrossed() + ", dir=" + this.getDir() + ", fee=" + this.getFee() + ", feeToken=" + this.getFeeToken() + ", hash=" + this.getHash() + ", px=" + this.getPx() + ", side=" + this.getSide() + ", startPosition=" + this.getStartPosition() + ", cumQty=" + this.getCumQty() + ", tid=" + this.getTid() + ", time=" + this.getTime() + ", closedPnl=" + this.getClosedPnl() + ")";
    }
}

