/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.exchanges.a.specification.domain.Order;
import estonlabs.cxtl.exchanges.a.specification.domain.SimpleOrderStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HyperliquidOpenOrder
implements Order {
    @JsonProperty(value="coin")
    private String symbol;
    @JsonProperty(value="limitPx")
    private Double lastOrAvgPx;
    @JsonProperty(value="oid")
    private String orderId;
    @JsonProperty(value="origSz")
    private double origSz;
    @JsonProperty(value="side")
    private String side;
    @JsonProperty(value="sz")
    private double sz;
    @JsonProperty(value="cloid")
    private String clOrdId;
    @JsonProperty(value="timestamp")
    private long timestamp;
    @JsonProperty(value="reduceOnly")
    private Boolean reduceOnly;

    @Override
    public double getCumQty() {
        return this.origSz - this.sz;
    }

    @Override
    public SimpleOrderStatus getSimpleStatus() {
        return SimpleOrderStatus.OPEN;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public Double getLastOrAvgPx() {
        return this.lastOrAvgPx;
    }

    @Override
    public String getOrderId() {
        return this.orderId;
    }

    public double getOrigSz() {
        return this.origSz;
    }

    public String getSide() {
        return this.side;
    }

    public double getSz() {
        return this.sz;
    }

    @Override
    public String getClOrdId() {
        return this.clOrdId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Boolean getReduceOnly() {
        return this.reduceOnly;
    }

    @JsonProperty(value="coin")
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @JsonProperty(value="limitPx")
    public void setLastOrAvgPx(Double lastOrAvgPx) {
        this.lastOrAvgPx = lastOrAvgPx;
    }

    @JsonProperty(value="oid")
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    @JsonProperty(value="origSz")
    public void setOrigSz(double origSz) {
        this.origSz = origSz;
    }

    @JsonProperty(value="side")
    public void setSide(String side) {
        this.side = side;
    }

    @JsonProperty(value="sz")
    public void setSz(double sz) {
        this.sz = sz;
    }

    @JsonProperty(value="cloid")
    public void setClOrdId(String clOrdId) {
        this.clOrdId = clOrdId;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="reduceOnly")
    public void setReduceOnly(Boolean reduceOnly) {
        this.reduceOnly = reduceOnly;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HyperliquidOpenOrder)) {
            return false;
        }
        HyperliquidOpenOrder other = (HyperliquidOpenOrder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getOrigSz(), other.getOrigSz()) != 0) {
            return false;
        }
        if (Double.compare(this.getSz(), other.getSz()) != 0) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        Double this$lastOrAvgPx = this.getLastOrAvgPx();
        Double other$lastOrAvgPx = other.getLastOrAvgPx();
        if (this$lastOrAvgPx == null ? other$lastOrAvgPx != null : !((Object)this$lastOrAvgPx).equals(other$lastOrAvgPx)) {
            return false;
        }
        Boolean this$reduceOnly = this.getReduceOnly();
        Boolean other$reduceOnly = other.getReduceOnly();
        if (this$reduceOnly == null ? other$reduceOnly != null : !((Object)this$reduceOnly).equals(other$reduceOnly)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$side = this.getSide();
        String other$side = other.getSide();
        if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
            return false;
        }
        String this$clOrdId = this.getClOrdId();
        String other$clOrdId = other.getClOrdId();
        return !(this$clOrdId == null ? other$clOrdId != null : !this$clOrdId.equals(other$clOrdId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HyperliquidOpenOrder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $origSz = Double.doubleToLongBits(this.getOrigSz());
        result = result * 59 + (int)($origSz >>> 32 ^ $origSz);
        long $sz = Double.doubleToLongBits(this.getSz());
        result = result * 59 + (int)($sz >>> 32 ^ $sz);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        Double $lastOrAvgPx = this.getLastOrAvgPx();
        result = result * 59 + ($lastOrAvgPx == null ? 43 : ((Object)$lastOrAvgPx).hashCode());
        Boolean $reduceOnly = this.getReduceOnly();
        result = result * 59 + ($reduceOnly == null ? 43 : ((Object)$reduceOnly).hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : $side.hashCode());
        String $clOrdId = this.getClOrdId();
        result = result * 59 + ($clOrdId == null ? 43 : $clOrdId.hashCode());
        return result;
    }

    public String toString() {
        return "HyperliquidOpenOrder(symbol=" + this.getSymbol() + ", lastOrAvgPx=" + this.getLastOrAvgPx() + ", orderId=" + this.getOrderId() + ", origSz=" + this.getOrigSz() + ", side=" + this.getSide() + ", sz=" + this.getSz() + ", clOrdId=" + this.getClOrdId() + ", timestamp=" + this.getTimestamp() + ", reduceOnly=" + this.getReduceOnly() + ")";
    }
}

