/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.exchanges.a.specification.domain.Order;
import estonlabs.cxtl.exchanges.a.specification.domain.SimpleOrderStatus;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.types.OrderStatus;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HyperliquidOrder
implements Order {
    @JsonProperty(value="order")
    private OrderDetails orderDetails;
    @JsonProperty(value="status")
    private OrderStatus status;
    @JsonProperty(value="statusTimestamp")
    private long statusTimestamp;

    @Override
    public String getSymbol() {
        return this.orderDetails.getSymbol();
    }

    @Override
    public double getCumQty() {
        return this.orderDetails.getOrigSz() - this.orderDetails.getSz();
    }

    @Override
    public Double getLastOrAvgPx() {
        return this.orderDetails.getLastOrAvgPx();
    }

    @Override
    public SimpleOrderStatus getSimpleStatus() {
        return this.status.getSimpleOrderStatus();
    }

    @Override
    public String getOrderId() {
        return this.orderDetails.getOrderId();
    }

    @Override
    public String getClOrdId() {
        return this.orderDetails.getClOrdId();
    }

    public OrderDetails getOrderDetails() {
        return this.orderDetails;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public long getStatusTimestamp() {
        return this.statusTimestamp;
    }

    @JsonProperty(value="order")
    public void setOrderDetails(OrderDetails orderDetails) {
        this.orderDetails = orderDetails;
    }

    @JsonProperty(value="status")
    public void setStatus(OrderStatus status) {
        this.status = status;
    }

    @JsonProperty(value="statusTimestamp")
    public void setStatusTimestamp(long statusTimestamp) {
        this.statusTimestamp = statusTimestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HyperliquidOrder)) {
            return false;
        }
        HyperliquidOrder other = (HyperliquidOrder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatusTimestamp() != other.getStatusTimestamp()) {
            return false;
        }
        OrderDetails this$orderDetails = this.getOrderDetails();
        OrderDetails other$orderDetails = other.getOrderDetails();
        if (this$orderDetails == null ? other$orderDetails != null : !((Object)this$orderDetails).equals(other$orderDetails)) {
            return false;
        }
        OrderStatus this$status = this.getStatus();
        OrderStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HyperliquidOrder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $statusTimestamp = this.getStatusTimestamp();
        result = result * 59 + (int)($statusTimestamp >>> 32 ^ $statusTimestamp);
        OrderDetails $orderDetails = this.getOrderDetails();
        result = result * 59 + ($orderDetails == null ? 43 : ((Object)$orderDetails).hashCode());
        OrderStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "HyperliquidOrder(orderDetails=" + this.getOrderDetails() + ", status=" + this.getStatus() + ", statusTimestamp=" + this.getStatusTimestamp() + ")";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class OrderDetails {
        @JsonProperty(value="oid")
        private String orderId;
        @JsonProperty(value="cloid")
        private String clOrdId;
        @JsonProperty(value="coin")
        private String symbol;
        @JsonProperty(value="isPositionTpsl")
        private boolean isPositionTpsl;
        @JsonProperty(value="isTrigger")
        private boolean isTrigger;
        @JsonProperty(value="limitPx")
        private Double lastOrAvgPx;
        @JsonProperty(value="orderType")
        private String orderType;
        @JsonProperty(value="origSz")
        private double origSz;
        @JsonProperty(value="reduceOnly")
        private boolean reduceOnly;
        @JsonProperty(value="side")
        private String side;
        @JsonProperty(value="sz")
        private double sz;
        @JsonProperty(value="tif")
        private String tif;
        @JsonProperty(value="timestamp")
        private long timestamp;
        @JsonProperty(value="triggerCondition")
        private String triggerCondition;
        @JsonProperty(value="triggerPx")
        private String triggerPx;
        @JsonProperty(value="children")
        private List<Object> children;

        public String getOrderId() {
            return this.orderId;
        }

        public String getClOrdId() {
            return this.clOrdId;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public boolean isPositionTpsl() {
            return this.isPositionTpsl;
        }

        public boolean isTrigger() {
            return this.isTrigger;
        }

        public Double getLastOrAvgPx() {
            return this.lastOrAvgPx;
        }

        public String getOrderType() {
            return this.orderType;
        }

        public double getOrigSz() {
            return this.origSz;
        }

        public boolean isReduceOnly() {
            return this.reduceOnly;
        }

        public String getSide() {
            return this.side;
        }

        public double getSz() {
            return this.sz;
        }

        public String getTif() {
            return this.tif;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getTriggerCondition() {
            return this.triggerCondition;
        }

        public String getTriggerPx() {
            return this.triggerPx;
        }

        public List<Object> getChildren() {
            return this.children;
        }

        @JsonProperty(value="oid")
        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        @JsonProperty(value="cloid")
        public void setClOrdId(String clOrdId) {
            this.clOrdId = clOrdId;
        }

        @JsonProperty(value="coin")
        public void setSymbol(String symbol) {
            this.symbol = symbol;
        }

        @JsonProperty(value="isPositionTpsl")
        public void setPositionTpsl(boolean isPositionTpsl) {
            this.isPositionTpsl = isPositionTpsl;
        }

        @JsonProperty(value="isTrigger")
        public void setTrigger(boolean isTrigger) {
            this.isTrigger = isTrigger;
        }

        @JsonProperty(value="limitPx")
        public void setLastOrAvgPx(Double lastOrAvgPx) {
            this.lastOrAvgPx = lastOrAvgPx;
        }

        @JsonProperty(value="orderType")
        public void setOrderType(String orderType) {
            this.orderType = orderType;
        }

        @JsonProperty(value="origSz")
        public void setOrigSz(double origSz) {
            this.origSz = origSz;
        }

        @JsonProperty(value="reduceOnly")
        public void setReduceOnly(boolean reduceOnly) {
            this.reduceOnly = reduceOnly;
        }

        @JsonProperty(value="side")
        public void setSide(String side) {
            this.side = side;
        }

        @JsonProperty(value="sz")
        public void setSz(double sz) {
            this.sz = sz;
        }

        @JsonProperty(value="tif")
        public void setTif(String tif) {
            this.tif = tif;
        }

        @JsonProperty(value="timestamp")
        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        @JsonProperty(value="triggerCondition")
        public void setTriggerCondition(String triggerCondition) {
            this.triggerCondition = triggerCondition;
        }

        @JsonProperty(value="triggerPx")
        public void setTriggerPx(String triggerPx) {
            this.triggerPx = triggerPx;
        }

        @JsonProperty(value="children")
        public void setChildren(List<Object> children) {
            this.children = children;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderDetails)) {
                return false;
            }
            OrderDetails other = (OrderDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPositionTpsl() != other.isPositionTpsl()) {
                return false;
            }
            if (this.isTrigger() != other.isTrigger()) {
                return false;
            }
            if (Double.compare(this.getOrigSz(), other.getOrigSz()) != 0) {
                return false;
            }
            if (this.isReduceOnly() != other.isReduceOnly()) {
                return false;
            }
            if (Double.compare(this.getSz(), other.getSz()) != 0) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            Double this$lastOrAvgPx = this.getLastOrAvgPx();
            Double other$lastOrAvgPx = other.getLastOrAvgPx();
            if (this$lastOrAvgPx == null ? other$lastOrAvgPx != null : !((Object)this$lastOrAvgPx).equals(other$lastOrAvgPx)) {
                return false;
            }
            String this$orderId = this.getOrderId();
            String other$orderId = other.getOrderId();
            if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
                return false;
            }
            String this$clOrdId = this.getClOrdId();
            String other$clOrdId = other.getClOrdId();
            if (this$clOrdId == null ? other$clOrdId != null : !this$clOrdId.equals(other$clOrdId)) {
                return false;
            }
            String this$symbol = this.getSymbol();
            String other$symbol = other.getSymbol();
            if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
                return false;
            }
            String this$orderType = this.getOrderType();
            String other$orderType = other.getOrderType();
            if (this$orderType == null ? other$orderType != null : !this$orderType.equals(other$orderType)) {
                return false;
            }
            String this$side = this.getSide();
            String other$side = other.getSide();
            if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
                return false;
            }
            String this$tif = this.getTif();
            String other$tif = other.getTif();
            if (this$tif == null ? other$tif != null : !this$tif.equals(other$tif)) {
                return false;
            }
            String this$triggerCondition = this.getTriggerCondition();
            String other$triggerCondition = other.getTriggerCondition();
            if (this$triggerCondition == null ? other$triggerCondition != null : !this$triggerCondition.equals(other$triggerCondition)) {
                return false;
            }
            String this$triggerPx = this.getTriggerPx();
            String other$triggerPx = other.getTriggerPx();
            if (this$triggerPx == null ? other$triggerPx != null : !this$triggerPx.equals(other$triggerPx)) {
                return false;
            }
            List<Object> this$children = this.getChildren();
            List<Object> other$children = other.getChildren();
            return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OrderDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPositionTpsl() ? 79 : 97);
            result = result * 59 + (this.isTrigger() ? 79 : 97);
            long $origSz = Double.doubleToLongBits(this.getOrigSz());
            result = result * 59 + (int)($origSz >>> 32 ^ $origSz);
            result = result * 59 + (this.isReduceOnly() ? 79 : 97);
            long $sz = Double.doubleToLongBits(this.getSz());
            result = result * 59 + (int)($sz >>> 32 ^ $sz);
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            Double $lastOrAvgPx = this.getLastOrAvgPx();
            result = result * 59 + ($lastOrAvgPx == null ? 43 : ((Object)$lastOrAvgPx).hashCode());
            String $orderId = this.getOrderId();
            result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
            String $clOrdId = this.getClOrdId();
            result = result * 59 + ($clOrdId == null ? 43 : $clOrdId.hashCode());
            String $symbol = this.getSymbol();
            result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
            String $orderType = this.getOrderType();
            result = result * 59 + ($orderType == null ? 43 : $orderType.hashCode());
            String $side = this.getSide();
            result = result * 59 + ($side == null ? 43 : $side.hashCode());
            String $tif = this.getTif();
            result = result * 59 + ($tif == null ? 43 : $tif.hashCode());
            String $triggerCondition = this.getTriggerCondition();
            result = result * 59 + ($triggerCondition == null ? 43 : $triggerCondition.hashCode());
            String $triggerPx = this.getTriggerPx();
            result = result * 59 + ($triggerPx == null ? 43 : $triggerPx.hashCode());
            List<Object> $children = this.getChildren();
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            return result;
        }

        public String toString() {
            return "HyperliquidOrder.OrderDetails(orderId=" + this.getOrderId() + ", clOrdId=" + this.getClOrdId() + ", symbol=" + this.getSymbol() + ", isPositionTpsl=" + this.isPositionTpsl() + ", isTrigger=" + this.isTrigger() + ", lastOrAvgPx=" + this.getLastOrAvgPx() + ", orderType=" + this.getOrderType() + ", origSz=" + this.getOrigSz() + ", reduceOnly=" + this.isReduceOnly() + ", side=" + this.getSide() + ", sz=" + this.getSz() + ", tif=" + this.getTif() + ", timestamp=" + this.getTimestamp() + ", triggerCondition=" + this.getTriggerCondition() + ", triggerPx=" + this.getTriggerPx() + ", children=" + this.getChildren() + ")";
        }
    }
}

