/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.exchanges.a.specification.domain.Trade;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HyperliquidTrade
implements Trade {
    @JsonProperty(value="symbol")
    private String symbol;
    @JsonProperty(value="price")
    private double price;
    @JsonProperty(value="quantity")
    private double quantity;
    @JsonProperty(value="side")
    private String side;

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public double getPrice() {
        return this.price;
    }

    @Override
    public double getQuantity() {
        return this.quantity;
    }

    @Override
    public String getSide() {
        return this.side;
    }

    @JsonProperty(value="symbol")
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @JsonProperty(value="price")
    public void setPrice(double price) {
        this.price = price;
    }

    @JsonProperty(value="quantity")
    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    @JsonProperty(value="side")
    public void setSide(String side) {
        this.side = side;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HyperliquidTrade)) {
            return false;
        }
        HyperliquidTrade other = (HyperliquidTrade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getPrice(), other.getPrice()) != 0) {
            return false;
        }
        if (Double.compare(this.getQuantity(), other.getQuantity()) != 0) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$side = this.getSide();
        String other$side = other.getSide();
        return !(this$side == null ? other$side != null : !this$side.equals(other$side));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HyperliquidTrade;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $price = Double.doubleToLongBits(this.getPrice());
        result = result * 59 + (int)($price >>> 32 ^ $price);
        long $quantity = Double.doubleToLongBits(this.getQuantity());
        result = result * 59 + (int)($quantity >>> 32 ^ $quantity);
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : $side.hashCode());
        return result;
    }

    public String toString() {
        return "HyperliquidTrade(symbol=" + this.getSymbol() + ", price=" + this.getPrice() + ", quantity=" + this.getQuantity() + ", side=" + this.getSide() + ")";
    }

    public HyperliquidTrade() {
    }

    public HyperliquidTrade(String symbol, double price, double quantity, String side) {
        this.symbol = symbol;
        this.price = price;
        this.quantity = quantity;
        this.side = side;
    }
}

