/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.common.stream.managed.OutboundMessage;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.types.OutboundMethod;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.types.SubscriptionType;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HyperliquidOutboundMessage
implements OutboundMessage {
    @JsonIgnore
    @NonNull
    protected OutboundMessage.MessageType messageType;
    private OutboundMethod method;
    private Subscription subscription;

    public HyperliquidOutboundMessage(@NonNull OutboundMessage.MessageType messageType) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        this.messageType = messageType;
        if (messageType == OutboundMessage.MessageType.SUBSCRIPTION) {
            this.method = OutboundMethod.subscribe;
        } else if (messageType == OutboundMessage.MessageType.UNSUBSCRIBE) {
            this.method = OutboundMethod.unsubscribe;
        } else if (messageType == OutboundMessage.MessageType.PING) {
            this.method = OutboundMethod.ping;
        }
    }

    public static HyperliquidOutboundMessage subscribeByCoin(SubscriptionType type, String coin) {
        return HyperliquidOutboundMessage.subscribe(type, coin, null);
    }

    public static HyperliquidOutboundMessage subscribeByUser(SubscriptionType type, String user) {
        return HyperliquidOutboundMessage.subscribe(type, null, user);
    }

    public static HyperliquidOutboundMessage unsubscribeByCoin(SubscriptionType type, String coin) {
        return HyperliquidOutboundMessage.unsubscribe(type, coin, null);
    }

    public static HyperliquidOutboundMessage unsubscribeByUser(SubscriptionType type, String user) {
        return HyperliquidOutboundMessage.unsubscribe(type, null, user);
    }

    public static HyperliquidOutboundMessage ping() {
        return new HyperliquidOutboundMessage(OutboundMessage.MessageType.PING);
    }

    private static HyperliquidOutboundMessage subscribe(SubscriptionType type, String coin, String user) {
        HyperliquidOutboundMessage request = new HyperliquidOutboundMessage(OutboundMessage.MessageType.SUBSCRIPTION);
        request.setSubscription(new Subscription(type.getType(), coin, user));
        return request;
    }

    private static HyperliquidOutboundMessage unsubscribe(SubscriptionType type, String coin, String user) {
        HyperliquidOutboundMessage request = new HyperliquidOutboundMessage(OutboundMessage.MessageType.UNSUBSCRIBE);
        request.setSubscription(new Subscription(type.getType(), coin, user));
        return request;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HyperliquidOutboundMessage)) {
            return false;
        }
        HyperliquidOutboundMessage other = (HyperliquidOutboundMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OutboundMessage.MessageType this$messageType = this.getMessageType();
        OutboundMessage.MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
            return false;
        }
        OutboundMethod this$method = this.getMethod();
        OutboundMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        Subscription this$subscription = this.getSubscription();
        Subscription other$subscription = other.getSubscription();
        return !(this$subscription == null ? other$subscription != null : !((Object)this$subscription).equals(other$subscription));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HyperliquidOutboundMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OutboundMessage.MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        OutboundMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        Subscription $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : ((Object)$subscription).hashCode());
        return result;
    }

    @Override
    @NonNull
    public OutboundMessage.MessageType getMessageType() {
        return this.messageType;
    }

    public OutboundMethod getMethod() {
        return this.method;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    @JsonIgnore
    public void setMessageType(@NonNull OutboundMessage.MessageType messageType) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        this.messageType = messageType;
    }

    public void setMethod(OutboundMethod method) {
        this.method = method;
    }

    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public String toString() {
        return "HyperliquidOutboundMessage(super=" + super.toString() + ", messageType=" + this.getMessageType() + ", method=" + this.getMethod() + ", subscription=" + this.getSubscription() + ")";
    }

    private static class Subscription {
        private String type;
        private String coin;
        private String user;

        public String getType() {
            return this.type;
        }

        public String getCoin() {
            return this.coin;
        }

        public String getUser() {
            return this.user;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setCoin(String coin) {
            this.coin = coin;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Subscription)) {
                return false;
            }
            Subscription other = (Subscription)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$coin = this.getCoin();
            String other$coin = other.getCoin();
            if (this$coin == null ? other$coin != null : !this$coin.equals(other$coin)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            return !(this$user == null ? other$user != null : !this$user.equals(other$user));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Subscription;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $coin = this.getCoin();
            result = result * 59 + ($coin == null ? 43 : $coin.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            return result;
        }

        public String toString() {
            return "HyperliquidOutboundMessage.Subscription(type=" + this.getType() + ", coin=" + this.getCoin() + ", user=" + this.getUser() + ")";
        }

        public Subscription(String type, String coin, String user) {
            this.type = type;
            this.coin = coin;
            this.user = user;
        }
    }
}

