/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.stream.AbstractHyperliquidInboundMessage;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.types.SubscriptionType;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Level1MarketDataMessage
extends AbstractHyperliquidInboundMessage<List<MarketData>>
implements estonlabs.cxtl.common.stream.managed.MarketData {
    public Level1MarketDataMessage() {
        this.messageType = InboundMessage.MessageType.DATA;
    }

    @Override
    public String getTopic() {
        return String.format("%s:%s", SubscriptionType.L1.getType(), ((MarketData)((List)this.data).get(0)).getTid());
    }

    @Override
    @JsonIgnore
    public Long getSeqNo() {
        return null;
    }

    @Override
    @JsonIgnore
    public Long getTimestamp() {
        return ((MarketData)((List)this.data).get(0)).getTime();
    }

    @Override
    public boolean hasData() {
        return this.data != null;
    }

    @Override
    @JsonIgnore
    public boolean isSnapshot() {
        return ((List)this.data).size() > 1;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Level1MarketDataMessage)) {
            return false;
        }
        Level1MarketDataMessage other = (Level1MarketDataMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Level1MarketDataMessage;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "Level1MarketDataMessage(super=" + super.toString() + ")";
    }

    public static class MarketData {
        private String coin;
        private String side;
        private Double px;
        private Double sz;
        private Long time;
        private String hash;
        private Long tid;

        public String getCoin() {
            return this.coin;
        }

        public String getSide() {
            return this.side;
        }

        public Double getPx() {
            return this.px;
        }

        public Double getSz() {
            return this.sz;
        }

        public Long getTime() {
            return this.time;
        }

        public String getHash() {
            return this.hash;
        }

        public Long getTid() {
            return this.tid;
        }

        public void setCoin(String coin) {
            this.coin = coin;
        }

        public void setSide(String side) {
            this.side = side;
        }

        public void setPx(Double px) {
            this.px = px;
        }

        public void setSz(Double sz) {
            this.sz = sz;
        }

        public void setTime(Long time) {
            this.time = time;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public void setTid(Long tid) {
            this.tid = tid;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MarketData)) {
                return false;
            }
            MarketData other = (MarketData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$px = this.getPx();
            Double other$px = other.getPx();
            if (this$px == null ? other$px != null : !((Object)this$px).equals(other$px)) {
                return false;
            }
            Double this$sz = this.getSz();
            Double other$sz = other.getSz();
            if (this$sz == null ? other$sz != null : !((Object)this$sz).equals(other$sz)) {
                return false;
            }
            Long this$time = this.getTime();
            Long other$time = other.getTime();
            if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
                return false;
            }
            Long this$tid = this.getTid();
            Long other$tid = other.getTid();
            if (this$tid == null ? other$tid != null : !((Object)this$tid).equals(other$tid)) {
                return false;
            }
            String this$coin = this.getCoin();
            String other$coin = other.getCoin();
            if (this$coin == null ? other$coin != null : !this$coin.equals(other$coin)) {
                return false;
            }
            String this$side = this.getSide();
            String other$side = other.getSide();
            if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
                return false;
            }
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MarketData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $px = this.getPx();
            result = result * 59 + ($px == null ? 43 : ((Object)$px).hashCode());
            Double $sz = this.getSz();
            result = result * 59 + ($sz == null ? 43 : ((Object)$sz).hashCode());
            Long $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            Long $tid = this.getTid();
            result = result * 59 + ($tid == null ? 43 : ((Object)$tid).hashCode());
            String $coin = this.getCoin();
            result = result * 59 + ($coin == null ? 43 : $coin.hashCode());
            String $side = this.getSide();
            result = result * 59 + ($side == null ? 43 : $side.hashCode());
            String $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            return result;
        }

        public String toString() {
            return "Level1MarketDataMessage.MarketData(coin=" + this.getCoin() + ", side=" + this.getSide() + ", px=" + this.getPx() + ", sz=" + this.getSz() + ", time=" + this.getTime() + ", hash=" + this.getHash() + ", tid=" + this.getTid() + ")";
        }
    }
}

