/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.stream.AbstractHyperliquidInboundMessage;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.types.SubscriptionType;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Level2MarketDataMessage
extends AbstractHyperliquidInboundMessage<MarketData>
implements estonlabs.cxtl.common.stream.managed.MarketData {
    @JsonIgnore
    private boolean isSnapshot = false;

    public Level2MarketDataMessage() {
        this.messageType = InboundMessage.MessageType.DATA;
    }

    @Override
    public String getTopic() {
        return String.format("%s:%s", SubscriptionType.L2.getType(), ((MarketData)this.data).getCoin());
    }

    @Override
    public Long getSeqNo() {
        return null;
    }

    @Override
    public Long getTimestamp() {
        return ((MarketData)this.data).getTime();
    }

    @Override
    public boolean hasData() {
        return this.data != null;
    }

    @Override
    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    @JsonIgnore
    public void setSnapshot(boolean isSnapshot) {
        this.isSnapshot = isSnapshot;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Level2MarketDataMessage)) {
            return false;
        }
        Level2MarketDataMessage other = (Level2MarketDataMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isSnapshot() == other.isSnapshot();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Level2MarketDataMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSnapshot() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "Level2MarketDataMessage(super=" + super.toString() + ", isSnapshot=" + this.isSnapshot() + ")";
    }

    public static class MarketData {
        private String coin;
        private Long time;
        private List<List<Level>> levels;

        public List<Level> getBidLevel() {
            return this.levels.get(0);
        }

        public List<Level> getAskLevel() {
            return this.levels.get(1);
        }

        public String getCoin() {
            return this.coin;
        }

        public Long getTime() {
            return this.time;
        }

        public List<List<Level>> getLevels() {
            return this.levels;
        }

        public void setCoin(String coin) {
            this.coin = coin;
        }

        public void setTime(Long time) {
            this.time = time;
        }

        public void setLevels(List<List<Level>> levels) {
            this.levels = levels;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MarketData)) {
                return false;
            }
            MarketData other = (MarketData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$time = this.getTime();
            Long other$time = other.getTime();
            if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
                return false;
            }
            String this$coin = this.getCoin();
            String other$coin = other.getCoin();
            if (this$coin == null ? other$coin != null : !this$coin.equals(other$coin)) {
                return false;
            }
            List<List<Level>> this$levels = this.getLevels();
            List<List<Level>> other$levels = other.getLevels();
            return !(this$levels == null ? other$levels != null : !((Object)this$levels).equals(other$levels));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MarketData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            String $coin = this.getCoin();
            result = result * 59 + ($coin == null ? 43 : $coin.hashCode());
            List<List<Level>> $levels = this.getLevels();
            result = result * 59 + ($levels == null ? 43 : ((Object)$levels).hashCode());
            return result;
        }

        public String toString() {
            return "Level2MarketDataMessage.MarketData(coin=" + this.getCoin() + ", time=" + this.getTime() + ", levels=" + this.getLevels() + ")";
        }
    }

    public static class Level {
        @JsonProperty(value="px")
        private Double price;
        @JsonProperty(value="sz")
        private Double size;
        @JsonProperty(value="n")
        private int noOfOrder;
    }
}

