/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.lib;

import estonlabs.cxtl.common.AbstractExchangeFactory;
import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.request.CancelRequest;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.request.OrderQueryRequest;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.request.OrderRequest;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.HyperliquidTicker;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.lib.HyperliquidRestClient;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class HyperliquidExchangeFactory
extends AbstractExchangeFactory<OrderRequest, CancelRequest, OrderQueryRequest, Object, HyperliquidTicker, HyperliquidRestClient, HyperliquidExchangeFactory> {
    public static final URI PROD = URI.create("https://api.hyperliquid.xyz");
    public static final URI TEST_NET = URI.create("https://api.hyperliquid.xyz");
    private static final Map<EnvironmentType, List<URI>> ENVIRONMENTS = Map.of(EnvironmentType.PROD, List.of(PROD), EnvironmentType.TEST_NET, List.of(TEST_NET));
    private final URI baseUri;

    public HyperliquidExchangeFactory(URI baseUri) {
        super(Exchange.HYPERLIQUID, ENVIRONMENTS);
        this.baseUri = baseUri;
    }

    @Override
    public HyperliquidRestClient buildCex() {
        return this.buildCex(this.httpProxy);
    }

    @Override
    public HyperliquidRestClient buildCex(Proxy httpProxy) {
        return new HyperliquidRestClient(this.createJsonRestClient(this.baseUri, httpProxy), this.baseUri, this.metricsLogger);
    }

    @Override
    protected HyperliquidExchangeFactory me() {
        return this;
    }

    @Override
    public HyperliquidRestClient buildEdi() {
        return this.buildCex();
    }

    @Override
    public HyperliquidRestClient buildEdi(Proxy httpProxy) {
        return this.buildCex(httpProxy);
    }
}

