/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.lib;

import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.exception.CxtlApiException;
import estonlabs.cxtl.common.exception.ErrorCode;
import estonlabs.cxtl.common.http.Event;
import estonlabs.cxtl.common.http.JsonRestClient;
import estonlabs.cxtl.common.http.MetricsLogger;
import estonlabs.cxtl.common.http.RestClient;
import estonlabs.cxtl.exchanges.a.specification.domain.Ack;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.a.specification.domain.Olhcv;
import estonlabs.cxtl.exchanges.a.specification.domain.Order;
import estonlabs.cxtl.exchanges.a.specification.domain.Trade;
import estonlabs.cxtl.exchanges.a.specification.lib.Cex;
import estonlabs.cxtl.exchanges.a.specification.lib.ExchangeDataInterface;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.request.CancelOrderAction;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.request.CancelRequest;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.request.CreateOrderAction;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.request.ExchApiRequest;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.request.InfoApiRequest;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.request.OrderQueryRequest;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.request.OrderRequest;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.ApiResponse;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.CancelAck;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.CancelAckResponse;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.CreateAck;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.CreateAckResponse;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.ExchangeApiResponse;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.HyperliquidFilledOrderList;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.HyperliquidOpenOrderList;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.HyperliquidTicker;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.ListResponse;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.OrderResponse;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.TickerListResponse;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.response.TradeListResponse;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.types.OrderStatus;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.types.RequestType;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.util.HyperliquidSignature;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.util.HyperliquidSigner;
import java.math.BigDecimal;
import java.net.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class HyperliquidRestClient
implements Cex<OrderRequest, CancelRequest, OrderQueryRequest>,
ExchangeDataInterface<HyperliquidTicker, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HyperliquidRestClient.class);
    private static final String INFO_ENDPOINT_URL = "/info";
    private static final String EXCHANGE_ENDPOINT_URL = "/exchange";
    private static final BigDecimal SYS_MIN_ORDER_SIZE = new BigDecimal("0.00000001");
    private static final BigDecimal SYS_MAX_ORDER_SIZE = new BigDecimal("99999999999");
    private final RestClientAdapter client;

    public HyperliquidRestClient(JsonRestClient restClient, URI baseUri, MetricsLogger metricsLogger) {
        this.client = new RestClientAdapter(restClient, baseUri, metricsLogger);
    }

    @Override
    public Proxy getProxy() {
        return this.client.client.getProxy();
    }

    @Override
    public Exchange getExchange() {
        return Exchange.HYPERLIQUID;
    }

    @Override
    public AssetClass[] getSupportedAssetClasses() {
        return new AssetClass[]{AssetClass.PERP};
    }

    @Override
    public Mono<? extends List<? extends Olhcv>> getOlhcv(Object request) {
        return Mono.empty();
    }

    @Override
    @NotNull
    public Mono<CreateAck> placeOrder(@NotNull Credentials credentials, @NotNull OrderRequest order) {
        if (order.getSize().doubleValue() == 0.0) {
            return Mono.error(new CxtlApiException("Order has zero size", null, ErrorCode.INVALID_QTY));
        }
        if (order.getSize().compareTo(SYS_MAX_ORDER_SIZE) > 0) {
            return Mono.error(new CxtlApiException("Order size too big", null, ErrorCode.INVALID_QTY));
        }
        if (order.getSize().compareTo(SYS_MIN_ORDER_SIZE) < 0) {
            return Mono.error(new CxtlApiException("Order size too small", null, ErrorCode.INVALID_QTY));
        }
        Mono<CreateOrderAction> mono = this.createOrder(order);
        CreateOrderAction action = mono.block();
        try {
            long nonce = System.currentTimeMillis();
            HyperliquidSignature signature = HyperliquidSigner.signL1Action(credentials.getSecretKey(), action, null, System.currentTimeMillis(), true);
            ExchApiRequest<CreateOrderAction> apiRequest = new ExchApiRequest<CreateOrderAction>(action, nonce, signature);
            return this.client.postExchange(apiRequest, CreateAckResponse.class);
        }
        catch (Exception e) {
            return Mono.error(new CxtlApiException("Unable to create order", "SYMBOL_NOT_FOUND", ErrorCode.UNKNOWN_ERROR));
        }
    }

    @Override
    @NotNull
    public Mono<CancelAck> cancelOrder(@NotNull Credentials credentials, @NotNull CancelRequest request) {
        Mono<CancelOrderAction> mono = this.cancelOrder(request);
        CancelOrderAction action = mono.block();
        try {
            long nonce = System.currentTimeMillis();
            HyperliquidSignature signature = HyperliquidSigner.signL1Action(credentials.getSecretKey(), action, null, System.currentTimeMillis(), true);
            ExchApiRequest<CancelOrderAction> apiRequest = new ExchApiRequest<CancelOrderAction>(action, nonce, signature);
            return this.client.postExchange(apiRequest, CancelAckResponse.class);
        }
        catch (Exception e) {
            return Mono.error(new CxtlApiException("Unable to cancel order", "SYMBOL_NOT_FOUND", ErrorCode.UNKNOWN_ERROR));
        }
    }

    @Override
    @NotNull
    public Mono<List<? extends Order>> getOrders(@NotNull Credentials credentials, OrderQueryRequest orderQueryRequest) {
        InfoApiRequest request;
        Mono<List<Object>> openOrders = Mono.just(List.of());
        Mono<List<Object>> fillOrders = Mono.just(List.of());
        if (orderQueryRequest.getStatus() == OrderStatus.open || orderQueryRequest.getStatus() == null) {
            request = InfoApiRequest.builder().type(RequestType.openOrders).user(credentials.getApiKey()).build();
            openOrders = this.client.postInfoForList(request, HyperliquidOpenOrderList.class);
        }
        if (orderQueryRequest.getStatus() == OrderStatus.filled || orderQueryRequest.getStatus() == null) {
            request = InfoApiRequest.builder().type(RequestType.userFills).user(credentials.getApiKey()).build();
            fillOrders = this.client.postInfoForList(request, HyperliquidFilledOrderList.class);
        }
        return Mono.zip(openOrders, fillOrders).flatMap(tuple -> {
            ArrayList combinedList = new ArrayList();
            combinedList.addAll((Collection)tuple.getT1());
            combinedList.addAll((Collection)tuple.getT2());
            return Mono.just(combinedList);
        });
    }

    @Override
    public Mono<? extends Order> getOrder(Credentials credentials, OrderQueryRequest orderQueryRequest) {
        InfoApiRequest request = InfoApiRequest.builder().type(RequestType.orderStatus).user(credentials.getApiKey()).oid(orderQueryRequest.getOid() != null ? Long.valueOf(orderQueryRequest.getOid()) : orderQueryRequest.getClOid()).build();
        return this.client.postInfo(request, OrderResponse.class);
    }

    @Override
    public Mono<Map<AssetClass, List<HyperliquidTicker>>> getTickers() {
        return this.getTickers(AssetClass.PERP).map(tickers -> {
            HashMap<AssetClass, List> tickerMap = new HashMap<AssetClass, List>();
            tickerMap.put(AssetClass.PERP, (List)tickers);
            return tickerMap;
        });
    }

    public Mono<List<HyperliquidTicker>> getTickers(AssetClass assetClass) {
        if (Arrays.stream(this.getSupportedAssetClasses()).noneMatch(ac -> ac == assetClass)) {
            return Mono.error(new CxtlApiException("Asset class not supported", "ASSET_CLASS_NOT_SUPPORTED", ErrorCode.INVALID_SYMBOL));
        }
        InfoApiRequest req = new InfoApiRequest();
        if (assetClass == AssetClass.PERP) {
            req.setType(RequestType.meta);
        }
        return this.client.postInfo(req, TickerListResponse.class).switchIfEmpty(Mono.just(List.of()));
    }

    @Override
    public Mono<? extends List<? extends Trade>> getLatestPublicTrades(AssetClass assetClass, String symbol) {
        InfoApiRequest request = InfoApiRequest.builder().type(RequestType.allMids).build();
        return this.client.postInfo(request, TradeListResponse.class).flatMapIterable(trades -> trades).filter(trade -> trade.getSymbol().equals(symbol)).collectList().flatMap(filteredTrades -> {
            if (filteredTrades.isEmpty()) {
                return Mono.error(new CxtlApiException("Symbol not found in tickers", "SYMBOL_NOT_FOUND", ErrorCode.INVALID_SYMBOL));
            }
            return Mono.just(filteredTrades);
        });
    }

    private Mono<CreateOrderAction> createOrder(OrderRequest request) {
        String symbol = request.getSymbol();
        return this.getTickers(AssetClass.PERP).flatMap(tickers -> {
            int index = -1;
            for (int i = 0; i < tickers.size(); ++i) {
                if (!((HyperliquidTicker)tickers.get(i)).getSymbol().equals(symbol)) continue;
                index = i;
                break;
            }
            if (index == -1) {
                return Mono.error(new CxtlApiException("Symbol not found in tickers", "SYMBOL_NOT_FOUND", ErrorCode.INVALID_SYMBOL));
            }
            CreateOrderAction.OrderType type = new CreateOrderAction.OrderType();
            type.setLimit(new CreateOrderAction.Limit(request.getTif()));
            CreateOrderAction.HyperliquidOrder order = CreateOrderAction.HyperliquidOrder.builder().assetId(index).buy(request.isBuy()).price(request.getPrice().toPlainString()).reduceOnly(false).orderType(type).size(request.getSize().stripTrailingZeros().toPlainString()).clientOrderId(request.getCloid()).build();
            return Mono.just(CreateOrderAction.createOrder(order));
        });
    }

    private Mono<CancelOrderAction> cancelOrder(CancelRequest request) {
        String symbol = request.getSymbol();
        return this.getTickers(request.getAssetClass()).flatMap(tickers -> {
            int index = -1;
            for (int i = 0; i < tickers.size(); ++i) {
                if (!((HyperliquidTicker)tickers.get(i)).getSymbol().equals(symbol)) continue;
                index = i;
                break;
            }
            if (index == -1) {
                return Mono.error(new CxtlApiException("Symbol not found in tickers", "SYMBOL_NOT_FOUND", ErrorCode.INVALID_SYMBOL));
            }
            CancelOrderAction action = null;
            action = request.getCloid() != null ? CancelOrderAction.cancelByClientOrderId(index, request.getCloid()) : CancelOrderAction.cancelByOrderId(index, Long.valueOf(request.getOrderId()));
            return Mono.just(action);
        });
    }

    private static ErrorCode errorCode(String message) {
        if (message.contains("Order must have minimum value of $10") || message.contains("Order has invalid size") || message.contains("Order value too large. Max is $10000000.")) {
            return ErrorCode.INVALID_QTY;
        }
        if (message.contains("Insufficient margin to place order")) {
            return ErrorCode.INSUFFICIENT_BALANCE;
        }
        if (message.contains("Price must be divisible by tick size") || message.contains("Invalid TP/SL price")) {
            return ErrorCode.BAD_PX;
        }
        if (message.contains("Order was never placed, already canceled, or filled") || message.contains("Order could not immediately match against any resting orders.")) {
            return ErrorCode.UNKNOWN_ORDER;
        }
        return ErrorCode.UNKNOWN_ERROR;
    }

    public static class RestClientAdapter {
        private final RestClient client;
        private final MetricsLogger metricsLogger;

        public RestClientAdapter(RestClient client, URI baseUri, MetricsLogger metricsLogger) {
            this.client = client;
            this.metricsLogger = metricsLogger;
        }

        public <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> postInfo(IN request, Class<RESPONSE> type) {
            return this.client.postAsJson(HyperliquidRestClient.INFO_ENDPOINT_URL, request, type).flatMap(this::handleInfoResponse);
        }

        public <IN, OUT extends Order, RESPONSE extends ListResponse<OUT>> Mono<List<OUT>> postInfoForList(IN request, Class<RESPONSE> type) {
            return this.client.postAsJson(HyperliquidRestClient.INFO_ENDPOINT_URL, request, type).flatMap(this::handleResponseList);
        }

        public <IN, OUT extends Ack, RESPONSE extends ExchangeApiResponse<OUT>> Mono<OUT> postExchange(IN request, Class<RESPONSE> type) {
            return this.client.postAsJson(HyperliquidRestClient.EXCHANGE_ENDPOINT_URL, request, type).flatMap(this::handleExchangeApiResponse);
        }

        private <OUT extends Order, RESPONSE extends ListResponse<OUT>> Mono<List<OUT>> handleResponseList(Event<RESPONSE> event) {
            List orders = (List)event.getResponse();
            return Mono.just(orders).doFinally(v -> this.metricsLogger.finishedSuccess(event));
        }

        private <IN, OUT extends Ack, RESPONSE extends ExchangeApiResponse<OUT>> Mono<OUT> handleExchangeApiResponse(Event<RESPONSE> event) {
            LOGGER.info("event resp {}", (Object)event.getResponseJson());
            ExchangeApiResponse output = (ExchangeApiResponse)event.getResponse();
            if (!output.isSuccess().booleanValue()) {
                this.metricsLogger.finishedError(event);
                String errorMessage = output.getErrorMessage();
                return Mono.error(new CxtlApiException(errorMessage, null, HyperliquidRestClient.errorCode(errorMessage)));
            }
            return Mono.just(((ExchangeApiResponse)event.getResponse()).getAck()).doFinally(v -> this.metricsLogger.finishedSuccess(event));
        }

        private <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> handleInfoResponse(Event<RESPONSE> event) {
            ApiResponse response = (ApiResponse)event.getResponse();
            if (!response.isSuccess()) {
                this.metricsLogger.finishedError(event);
                return Mono.error(new CxtlApiException(response.getErrorMessage(), null, null));
            }
            return Mono.just(((ApiResponse)event.getResponse()).getResult()).doFinally(v -> this.metricsLogger.finishedSuccess(event));
        }
    }
}

