/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.hyperliquid.api.v0.lib;

import estonlabs.cxtl.common.AbstractStreamFactory;
import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.common.codec.Codec;
import estonlabs.cxtl.common.codec.JacksonCodec;
import estonlabs.cxtl.common.stream.core.WebsocketConnection;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.stream.HyperliquidInboundContainer;
import estonlabs.cxtl.exchanges.hyperliquid.api.v0.domain.stream.HyperliquidOutboundMessage;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class HyperliquidStreamFactory
extends AbstractStreamFactory<HyperliquidOutboundMessage, HyperliquidInboundContainer, HyperliquidStreamFactory> {
    private static final String webSocketUrl = "wss://api.hyperliquid.xyz/ws";
    public static final URI PROD = URI.create("wss://api.hyperliquid.xyz/ws");
    public static final URI TEST_NET = URI.create("wss://api.hyperliquid.xyz/ws");
    public static final Map<EnvironmentType, List<URI>> ENVIRONMENTS = Map.of(EnvironmentType.PROD, List.of(PROD), EnvironmentType.TEST_NET, List.of(TEST_NET));
    private static final Codec<Object> CODEC = new JacksonCodec();
    private final URI baseUri;

    public HyperliquidStreamFactory() {
        this(PROD);
    }

    public HyperliquidStreamFactory(URI baseUri) {
        super(Exchange.HYPERLIQUID, CODEC, HyperliquidInboundContainer.class);
        this.baseUri = baseUri;
    }

    public static HyperliquidStreamFactory create(URI uri) {
        return new HyperliquidStreamFactory(uri);
    }

    public static HyperliquidStreamFactory prod() {
        return new HyperliquidStreamFactory(PROD);
    }

    @Override
    protected HyperliquidStreamFactory me() {
        return this;
    }

    public WebsocketConnection<HyperliquidOutboundMessage, HyperliquidInboundContainer> createStream() {
        String url = this.baseUri.toString();
        return this.newPublicWebsocket(URI.create(url), null);
    }
}

