/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.mexc.spot.v3;

import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.exception.CxtlApiException;
import estonlabs.cxtl.common.exception.CxtlEventException;
import estonlabs.cxtl.common.exception.ErrorCode;
import estonlabs.cxtl.common.http.Event;
import estonlabs.cxtl.common.http.JsonRestClient;
import estonlabs.cxtl.common.http.Method;
import estonlabs.cxtl.common.http.MetricsLogger;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.a.specification.lib.Cex;
import estonlabs.cxtl.exchanges.a.specification.lib.ExchangeDataInterface;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.CancelRequest;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.CancelResponse;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.ErrorResponse;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.ExchangeInfo;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.Kline;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.KlineRequest;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.MEXCTrade;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.NewOrderRequest;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.NewOrderResponse;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.OrderBookRequest;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.OrderBookSnapshot;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.OrderQueryRequest;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.OrderQueryResponse;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.SpotSymbol;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.TradeRequest;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.WSListenKey;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.WSListenKeyRequest;
import java.net.Proxy;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import reactor.core.publisher.Mono;

public class MEXCCex
implements Cex<NewOrderRequest, CancelRequest, OrderQueryRequest>,
ExchangeDataInterface<SpotSymbol, KlineRequest> {
    private static final String API_KEY_HEADER = "X-MEXC-APIKEY";
    private static final MediaType FORM_MEDIA_TYPE = MediaType.parse("application/x-www-form-urlencoded");
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse("application/json; charset=utf-8");
    private final JsonRestClient client;
    private final MetricsLogger metricsLogger;

    public MEXCCex(JsonRestClient restClient, MetricsLogger metricsLogger) {
        this.client = restClient;
        this.metricsLogger = metricsLogger;
    }

    @Override
    public Proxy getProxy() {
        return this.client.getProxy();
    }

    public Mono<OrderBookSnapshot> getOrderBook(String symbol, int limit) {
        return this.handleResponse(this.client.get("/depth", new OrderBookRequest().setSymbol(symbol).setLimit(limit), OrderBookSnapshot.class));
    }

    @Override
    public Mono<List<MEXCTrade>> getLatestPublicTrades(AssetClass assetClass, String symbol) {
        return this.handleResponse(this.client.getMany("/trades", new TradeRequest().setSymbol(symbol), MEXCTrade.class));
    }

    @Override
    public Mono<Map<AssetClass, List<SpotSymbol>>> getTickers() {
        return this.handleResponse(this.client.get("/exchangeInfo", ExchangeInfo.class)).map(r -> Map.of(AssetClass.SPOT, r.getSymbols()));
    }

    @Override
    public Mono<List<Kline>> getOlhcv(KlineRequest klineRequest) {
        return this.handleResponse(this.client.getMany("/klines", klineRequest, Kline.class));
    }

    @Override
    public Exchange getExchange() {
        return Exchange.MEXC;
    }

    @Override
    public AssetClass[] getSupportedAssetClasses() {
        return new AssetClass[]{AssetClass.SPOT};
    }

    private Map<String, String> accessKeyHeader(Credentials credentials) {
        return Map.of(API_KEY_HEADER, credentials.getApiKey());
    }

    @Override
    public Mono<NewOrderResponse> placeOrder(Credentials credentials, NewOrderRequest order) {
        return this.handleResponse(this.client.parameterisedRequest(Method.POST, this.accessKeyHeader(credentials), "/order", null, RequestBody.create(order.queryString(credentials), JSON_MEDIA_TYPE), NewOrderResponse.class));
    }

    @Override
    public Mono<CancelResponse> cancelOrder(Credentials credentials, CancelRequest request) {
        return this.handleResponse(this.client.parameterisedRequest(Method.DELETE, this.accessKeyHeader(credentials), "/order", request.queryString(credentials), RequestBody.create("", JSON_MEDIA_TYPE), CancelResponse.class));
    }

    @Override
    public Mono<List<OrderQueryResponse>> getOrders(Credentials credentials, OrderQueryRequest request) {
        return this.handleResponse(this.client.parameterisedRequestMany(Method.GET, this.accessKeyHeader(credentials), "/order", request.queryString(credentials), null, OrderQueryResponse.class));
    }

    @Override
    public Mono<OrderQueryResponse> getOrder(Credentials credentials, OrderQueryRequest request) {
        return this.handleResponse(this.client.parameterisedRequest(Method.GET, this.accessKeyHeader(credentials), "/order", request.queryString(credentials), null, OrderQueryResponse.class));
    }

    public Mono<WSListenKey> createListenKey(Credentials credentials, long timestamp) {
        WSListenKeyRequest request = new WSListenKeyRequest().setTimestamp(timestamp);
        return this.handleResponse(this.client.parameterisedRequest(Method.POST, this.accessKeyHeader(credentials), "/userDataStream", null, RequestBody.create(request.queryString(credentials), JSON_MEDIA_TYPE), WSListenKey.class));
    }

    public Mono<WSListenKey> refreshListenKey(Credentials credentials, WSListenKeyRequest listenKey) {
        return this.handleResponse(this.client.parameterisedRequest(Method.PUT, this.accessKeyHeader(credentials), "/userDataStream", null, RequestBody.create(listenKey.queryString(credentials), JSON_MEDIA_TYPE), WSListenKey.class));
    }

    public Mono<List<OrderQueryResponse>> getOpenOrders(Credentials credentials, long timestamp, String symbol) {
        OrderQueryRequest request = new OrderQueryRequest().setTimestamp(timestamp).setSymbol(symbol);
        return this.handleResponse(this.client.parameterisedRequestMany(Method.GET, this.accessKeyHeader(credentials), "/openOrders", request.queryString(credentials), null, OrderQueryResponse.class));
    }

    private <I> I onSuccess(Event<I> e) {
        this.metricsLogger.finishedSuccess(e);
        return e.getResponse();
    }

    @NonNull
    private <T> Mono<T> onError(Throwable t) {
        if (t instanceof CxtlEventException) {
            CxtlEventException e = (CxtlEventException)t;
            this.metricsLogger.finishedError(e.getEvent());
            ErrorResponse response = this.client.getCodec().quietFromJson(e.getEvent().getResponseJson(), ErrorResponse.class);
            if (response != null) {
                return Mono.error(new CxtlApiException(response.toString(), response.getMsg(), this.mapErrorCode(response.getCode(), response.getMsg())));
            }
        }
        return Mono.error(new CxtlApiException(t.getMessage(), "UNKNOWN", ErrorCode.UNKNOWN_ERROR, t));
    }

    private ErrorCode mapErrorCode(int mexcErrorCode, String msg) {
        if (mexcErrorCode == 400 && msg.equals("price and quantity must be positive")) {
            return ErrorCode.INVALID_QTY;
        }
        return switch (mexcErrorCode) {
            case 10101, 30004 -> ErrorCode.INSUFFICIENT_BALANCE;
            case 10095, 10096, 10097, 10102, 30029, 30032 -> ErrorCode.INVALID_QTY;
            case 30010, 30026, 700004 -> ErrorCode.BAD_PX;
            case 10007, 30014, 30016, 30021 -> ErrorCode.INVALID_SYMBOL;
            case -2011 -> ErrorCode.UNKNOWN_ORDER;
            default -> ErrorCode.UNKNOWN_ERROR;
        };
    }

    private <T> Mono<T> handleResponse(Mono<Event<T>> response) {
        return response.map(this::onSuccess).onErrorResume(this::onError);
    }
}

