/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.mexc.spot.v3;

import estonlabs.cxtl.common.AbstractStreamFactory;
import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.codec.Codec;
import estonlabs.cxtl.common.codec.JacksonCodec;
import estonlabs.cxtl.common.stream.core.WebsocketConnection;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.mexc.spot.v3.MEXCCex;
import estonlabs.cxtl.exchanges.mexc.spot.v3.MEXCInboundContainer;
import estonlabs.cxtl.exchanges.mexc.spot.v3.MEXCOutboundMessage;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.WSListenKey;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.enums.WSMethod;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class MEXCStreamFactory
extends AbstractStreamFactory<MEXCOutboundMessage, MEXCInboundContainer, MEXCStreamFactory> {
    public static final URI PROD = URI.create("wss://wbs.mexc.com/ws");
    public static final MEXCOutboundMessage PING = new MEXCOutboundMessage().setMethod(WSMethod.PING);
    private static final Codec<Object> CODEC = new JacksonCodec();
    private URI baseUri;
    private MEXCCex cex;

    public MEXCStreamFactory(URI baseUri) {
        super(Exchange.MEXC, CODEC, MEXCInboundContainer.class);
        this.baseUri = baseUri;
        this.staleWindow(TimeUnit.SECONDS.toMillis(30L));
        this.ping(TimeUnit.MINUTES.toMillis(1L), () -> PING);
    }

    @Override
    protected MEXCStreamFactory me() {
        return this;
    }

    public MEXCStreamFactory cex(MEXCCex cex) {
        this.cex = cex;
        return this;
    }

    public WebsocketConnection<MEXCOutboundMessage, MEXCInboundContainer> createPublicStream() {
        return this.newPublicWebsocket(this.baseUri, null);
    }

    public WebsocketConnection<MEXCOutboundMessage, MEXCInboundContainer> createPrivateStream(@NonNull Credentials credentials, long timestamp) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        if (this.cex == null) {
            throw new IllegalStateException("A MEXCCex must be set to create a private websocket for MEXC");
        }
        WSListenKey listenKey = this.cex.createListenKey(credentials, timestamp).block();
        if (listenKey == null || listenKey.getListenKey() == null) {
            throw new IllegalStateException("Could not get a listen key for MEXC");
        }
        URI uriWithKey = new URI(this.baseUri.getScheme(), this.baseUri.getUserInfo(), this.baseUri.getHost(), this.baseUri.getPort(), this.baseUri.getPath(), "listenKey=" + listenKey.getListenKey(), this.baseUri.getFragment());
        return this.newPrivateWebsocket(uriWithKey, null);
    }
}

