/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.mexc.spot.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.security.HmacUtils;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.Signed;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CancelRequest
implements Signed {
    private String symbol;
    private String orderId;
    private String origClientOrderId;
    private String newClientOrderId;
    private Long recvWindow;
    private Long timestamp;

    @Override
    public String queryString(Credentials credentials) {
        StringJoiner joiner = new StringJoiner("&");
        if (this.symbol != null) {
            joiner.add("symbol=" + URLEncoder.encode(this.symbol, StandardCharsets.UTF_8));
        }
        if (this.orderId != null) {
            joiner.add("orderId=" + URLEncoder.encode(this.orderId, StandardCharsets.UTF_8));
        }
        if (this.origClientOrderId != null) {
            joiner.add("origClientOrderId=" + URLEncoder.encode(this.origClientOrderId, StandardCharsets.UTF_8));
        }
        if (this.newClientOrderId != null) {
            joiner.add("newClientOrderId=" + URLEncoder.encode(this.newClientOrderId, StandardCharsets.UTF_8));
        }
        if (this.recvWindow != null) {
            joiner.add("recvWindow=" + this.recvWindow);
        }
        if (this.timestamp != null) {
            joiner.add("timestamp=" + this.timestamp);
        }
        String content = joiner.toString();
        String signature = HmacUtils.sign(credentials, content);
        return content + "&signature=" + signature;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getOrigClientOrderId() {
        return this.origClientOrderId;
    }

    public String getNewClientOrderId() {
        return this.newClientOrderId;
    }

    public Long getRecvWindow() {
        return this.recvWindow;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public CancelRequest setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public CancelRequest setOrderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public CancelRequest setOrigClientOrderId(String origClientOrderId) {
        this.origClientOrderId = origClientOrderId;
        return this;
    }

    public CancelRequest setNewClientOrderId(String newClientOrderId) {
        this.newClientOrderId = newClientOrderId;
        return this;
    }

    public CancelRequest setRecvWindow(Long recvWindow) {
        this.recvWindow = recvWindow;
        return this;
    }

    public CancelRequest setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CancelRequest)) {
            return false;
        }
        CancelRequest other = (CancelRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$recvWindow = this.getRecvWindow();
        Long other$recvWindow = other.getRecvWindow();
        if (this$recvWindow == null ? other$recvWindow != null : !((Object)this$recvWindow).equals(other$recvWindow)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$origClientOrderId = this.getOrigClientOrderId();
        String other$origClientOrderId = other.getOrigClientOrderId();
        if (this$origClientOrderId == null ? other$origClientOrderId != null : !this$origClientOrderId.equals(other$origClientOrderId)) {
            return false;
        }
        String this$newClientOrderId = this.getNewClientOrderId();
        String other$newClientOrderId = other.getNewClientOrderId();
        return !(this$newClientOrderId == null ? other$newClientOrderId != null : !this$newClientOrderId.equals(other$newClientOrderId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CancelRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $recvWindow = this.getRecvWindow();
        result = result * 59 + ($recvWindow == null ? 43 : ((Object)$recvWindow).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $origClientOrderId = this.getOrigClientOrderId();
        result = result * 59 + ($origClientOrderId == null ? 43 : $origClientOrderId.hashCode());
        String $newClientOrderId = this.getNewClientOrderId();
        result = result * 59 + ($newClientOrderId == null ? 43 : $newClientOrderId.hashCode());
        return result;
    }

    public String toString() {
        return "CancelRequest(symbol=" + this.getSymbol() + ", orderId=" + this.getOrderId() + ", origClientOrderId=" + this.getOrigClientOrderId() + ", newClientOrderId=" + this.getNewClientOrderId() + ", recvWindow=" + this.getRecvWindow() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

