/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.mexc.spot.v3.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum KlineInterval {
    ONE_MINUTE("1m", TimeUnit.MINUTES.toMillis(1L)),
    FIVE_MINUTES("5m", TimeUnit.MINUTES.toMillis(5L)),
    FIFTEEN_MINUTES("15m", TimeUnit.MINUTES.toMillis(15L)),
    THIRTY_MINUTES("30m", TimeUnit.MINUTES.toMillis(30L)),
    SIXTY_MINUTES("60m", TimeUnit.HOURS.toMillis(1L)),
    FOUR_HOURS("4h", TimeUnit.HOURS.toMillis(4L)),
    ONE_DAY("1d", TimeUnit.DAYS.toMillis(1L)),
    ONE_WEEK("1W", TimeUnit.DAYS.toMillis(7L)),
    ONE_MONTH("1M", TimeUnit.DAYS.toMillis(30L));

    private final String code;
    private final long millis;
    private static final Map<String, KlineInterval> CODE_MAP;

    private KlineInterval(String code, long millis) {
        this.code = code;
        this.millis = millis;
    }

    @JsonValue
    public String getCode() {
        return this.code;
    }

    public long getMillis() {
        return this.millis;
    }

    @JsonCreator
    public static KlineInterval fromCode(String code) {
        KlineInterval interval = CODE_MAP.get(code);
        if (interval == null) {
            throw new IllegalArgumentException("Unknown interval code: " + code);
        }
        return interval;
    }

    public static KlineInterval fromMillis(long millis) {
        return Stream.of(KlineInterval.values()).filter(interval -> interval.getMillis() == millis).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown interval for millis: " + millis));
    }

    static {
        CODE_MAP = Stream.of(KlineInterval.values()).collect(Collectors.toMap(KlineInterval::getCode, Function.identity()));
    }
}

