/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.mexc.spot.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.common.stream.managed.MarketDataWithSymbol;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MEXCOrderBook
implements InboundMessage,
MarketDataWithSymbol {
    @JsonProperty(value="c")
    private String channel;
    @JsonProperty(value="d")
    private DepthData depthData;
    @JsonProperty(value="s")
    private String symbol;
    @JsonProperty(value="t")
    private long eventTime;

    @Override
    public InboundMessage.MessageType getMessageType() {
        return InboundMessage.MessageType.DATA;
    }

    @Override
    public boolean isSnapshot() {
        return false;
    }

    @Override
    public String getTopic() {
        return this.channel;
    }

    @Override
    public Long getSeqNo() {
        return Long.parseLong(this.depthData.version);
    }

    @Override
    public Long getTimestamp() {
        return this.eventTime;
    }

    @Override
    public boolean hasData() {
        return this.depthData != null;
    }

    public String getChannel() {
        return this.channel;
    }

    public DepthData getDepthData() {
        return this.depthData;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    @JsonProperty(value="c")
    public void setChannel(String channel) {
        this.channel = channel;
    }

    @JsonProperty(value="d")
    public void setDepthData(DepthData depthData) {
        this.depthData = depthData;
    }

    @JsonProperty(value="s")
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @JsonProperty(value="t")
    public void setEventTime(long eventTime) {
        this.eventTime = eventTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MEXCOrderBook)) {
            return false;
        }
        MEXCOrderBook other = (MEXCOrderBook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEventTime() != other.getEventTime()) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        DepthData this$depthData = this.getDepthData();
        DepthData other$depthData = other.getDepthData();
        if (this$depthData == null ? other$depthData != null : !((Object)this$depthData).equals(other$depthData)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        return !(this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MEXCOrderBook;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $eventTime = this.getEventTime();
        result = result * 59 + (int)($eventTime >>> 32 ^ $eventTime);
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        DepthData $depthData = this.getDepthData();
        result = result * 59 + ($depthData == null ? 43 : ((Object)$depthData).hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        return result;
    }

    public String toString() {
        return "MEXCOrderBook(channel=" + this.getChannel() + ", depthData=" + this.getDepthData() + ", symbol=" + this.getSymbol() + ", eventTime=" + this.getEventTime() + ")";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DepthData {
        @JsonProperty(value="asks")
        private List<Level> asks;
        @JsonProperty(value="bids")
        private List<Level> bids;
        @JsonProperty(value="e")
        private String eventType;
        @JsonProperty(value="r")
        private String version;

        public List<Level> getAsks() {
            return this.asks;
        }

        public List<Level> getBids() {
            return this.bids;
        }

        public String getEventType() {
            return this.eventType;
        }

        public String getVersion() {
            return this.version;
        }

        @JsonProperty(value="asks")
        public void setAsks(List<Level> asks) {
            this.asks = asks;
        }

        @JsonProperty(value="bids")
        public void setBids(List<Level> bids) {
            this.bids = bids;
        }

        @JsonProperty(value="e")
        public void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @JsonProperty(value="r")
        public void setVersion(String version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DepthData)) {
                return false;
            }
            DepthData other = (DepthData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Level> this$asks = this.getAsks();
            List<Level> other$asks = other.getAsks();
            if (this$asks == null ? other$asks != null : !((Object)this$asks).equals(other$asks)) {
                return false;
            }
            List<Level> this$bids = this.getBids();
            List<Level> other$bids = other.getBids();
            if (this$bids == null ? other$bids != null : !((Object)this$bids).equals(other$bids)) {
                return false;
            }
            String this$eventType = this.getEventType();
            String other$eventType = other.getEventType();
            if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DepthData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Level> $asks = this.getAsks();
            result = result * 59 + ($asks == null ? 43 : ((Object)$asks).hashCode());
            List<Level> $bids = this.getBids();
            result = result * 59 + ($bids == null ? 43 : ((Object)$bids).hashCode());
            String $eventType = this.getEventType();
            result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "MEXCOrderBook.DepthData(asks=" + this.getAsks() + ", bids=" + this.getBids() + ", eventType=" + this.getEventType() + ", version=" + this.getVersion() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Level {
        @JsonProperty(value="p")
        private String price;
        @JsonProperty(value="v")
        private String quantity;

        public String getPrice() {
            return this.price;
        }

        public String getQuantity() {
            return this.quantity;
        }

        @JsonProperty(value="p")
        public void setPrice(String price) {
            this.price = price;
        }

        @JsonProperty(value="v")
        public void setQuantity(String quantity) {
            this.quantity = quantity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Level)) {
                return false;
            }
            Level other = (Level)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$price = this.getPrice();
            String other$price = other.getPrice();
            if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
                return false;
            }
            String this$quantity = this.getQuantity();
            String other$quantity = other.getQuantity();
            return !(this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Level;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $price = this.getPrice();
            result = result * 59 + ($price == null ? 43 : $price.hashCode());
            String $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : $quantity.hashCode());
            return result;
        }

        public String toString() {
            return "MEXCOrderBook.Level(price=" + this.getPrice() + ", quantity=" + this.getQuantity() + ")";
        }
    }
}

