/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.mexc.spot.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.exchanges.a.specification.domain.Trade;
import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MEXCTrade
implements Trade {
    private Long id;
    private BigDecimal price;
    private BigDecimal qty;
    private String quoteQty;
    private Long time;
    private Boolean isBuyerMaker;
    private Boolean isBestMatch;

    @Override
    public double getQuantity() {
        return this.qty.doubleValue();
    }

    @Override
    public double getPrice() {
        return this.price.doubleValue();
    }

    public BigDecimal getBDPrice() {
        return this.price;
    }

    @Override
    public String getSide() {
        if (this.isBuyerMaker != null) {
            return this.isBuyerMaker != false ? "SELL" : "BUY";
        }
        return null;
    }

    @Override
    public String getSymbol() {
        return null;
    }

    public Long getId() {
        return this.id;
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public String getQuoteQty() {
        return this.quoteQty;
    }

    public Long getTime() {
        return this.time;
    }

    public Boolean getIsBuyerMaker() {
        return this.isBuyerMaker;
    }

    public Boolean getIsBestMatch() {
        return this.isBestMatch;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public void setQuoteQty(String quoteQty) {
        this.quoteQty = quoteQty;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public void setIsBuyerMaker(Boolean isBuyerMaker) {
        this.isBuyerMaker = isBuyerMaker;
    }

    public void setIsBestMatch(Boolean isBestMatch) {
        this.isBestMatch = isBestMatch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MEXCTrade)) {
            return false;
        }
        MEXCTrade other = (MEXCTrade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$time = this.getTime();
        Long other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        Boolean this$isBuyerMaker = this.getIsBuyerMaker();
        Boolean other$isBuyerMaker = other.getIsBuyerMaker();
        if (this$isBuyerMaker == null ? other$isBuyerMaker != null : !((Object)this$isBuyerMaker).equals(other$isBuyerMaker)) {
            return false;
        }
        Boolean this$isBestMatch = this.getIsBestMatch();
        Boolean other$isBestMatch = other.getIsBestMatch();
        if (this$isBestMatch == null ? other$isBestMatch != null : !((Object)this$isBestMatch).equals(other$isBestMatch)) {
            return false;
        }
        if (Double.compare(this.getPrice(), other.getPrice()) != 0) {
            return false;
        }
        BigDecimal this$qty = this.getQty();
        BigDecimal other$qty = other.getQty();
        if (this$qty == null ? other$qty != null : !((Object)this$qty).equals(other$qty)) {
            return false;
        }
        String this$quoteQty = this.getQuoteQty();
        String other$quoteQty = other.getQuoteQty();
        return !(this$quoteQty == null ? other$quoteQty != null : !this$quoteQty.equals(other$quoteQty));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MEXCTrade;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        Boolean $isBuyerMaker = this.getIsBuyerMaker();
        result = result * 59 + ($isBuyerMaker == null ? 43 : ((Object)$isBuyerMaker).hashCode());
        Boolean $isBestMatch = this.getIsBestMatch();
        result = result * 59 + ($isBestMatch == null ? 43 : ((Object)$isBestMatch).hashCode());
        long $price = Double.doubleToLongBits(this.getPrice());
        result = result * 59 + (int)($price >>> 32 ^ $price);
        BigDecimal $qty = this.getQty();
        result = result * 59 + ($qty == null ? 43 : ((Object)$qty).hashCode());
        String $quoteQty = this.getQuoteQty();
        result = result * 59 + ($quoteQty == null ? 43 : $quoteQty.hashCode());
        return result;
    }

    public String toString() {
        return "MEXCTrade(id=" + this.getId() + ", price=" + this.getPrice() + ", qty=" + this.getQty() + ", quoteQty=" + this.getQuoteQty() + ", time=" + this.getTime() + ", isBuyerMaker=" + this.getIsBuyerMaker() + ", isBestMatch=" + this.getIsBestMatch() + ")";
    }
}

