/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.mexc.spot.v3.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.security.HmacUtils;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.Signed;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.enums.OrderSide;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.enums.OrderType;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NewOrderRequest
implements Signed {
    private String symbol;
    private OrderSide side;
    private OrderType type;
    private BigDecimal quantity;
    private String quoteOrderQty;
    private BigDecimal price;
    private String newClientOrderId;
    private Long recvWindow;
    private Long timestamp;

    @Override
    public String queryString(Credentials credentials) {
        StringJoiner joiner = new StringJoiner("&");
        if (this.symbol != null) {
            joiner.add("symbol=" + URLEncoder.encode(this.symbol, StandardCharsets.UTF_8));
        }
        if (this.side != null) {
            joiner.add("side=" + URLEncoder.encode(this.side.name(), StandardCharsets.UTF_8));
        }
        if (this.type != null) {
            joiner.add("type=" + URLEncoder.encode(this.type.name(), StandardCharsets.UTF_8));
        }
        if (this.quantity != null) {
            joiner.add("quantity=" + this.quantity.toPlainString());
        }
        if (this.quoteOrderQty != null) {
            joiner.add("quoteOrderQty=" + URLEncoder.encode(this.quoteOrderQty, StandardCharsets.UTF_8));
        }
        if (this.price != null) {
            joiner.add("price=" + this.price.toPlainString());
        }
        if (this.newClientOrderId != null) {
            joiner.add("newClientOrderId=" + URLEncoder.encode(this.newClientOrderId, StandardCharsets.UTF_8));
        }
        if (this.recvWindow != null) {
            joiner.add("recvWindow=" + this.recvWindow);
        }
        if (this.timestamp != null) {
            joiner.add("timestamp=" + this.timestamp);
        }
        String content = joiner.toString();
        String signature = HmacUtils.sign(credentials, content);
        return content + "&signature=" + signature;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public OrderSide getSide() {
        return this.side;
    }

    public OrderType getType() {
        return this.type;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public String getQuoteOrderQty() {
        return this.quoteOrderQty;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public String getNewClientOrderId() {
        return this.newClientOrderId;
    }

    public Long getRecvWindow() {
        return this.recvWindow;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public NewOrderRequest setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public NewOrderRequest setSide(OrderSide side) {
        this.side = side;
        return this;
    }

    public NewOrderRequest setType(OrderType type) {
        this.type = type;
        return this;
    }

    public NewOrderRequest setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    public NewOrderRequest setQuoteOrderQty(String quoteOrderQty) {
        this.quoteOrderQty = quoteOrderQty;
        return this;
    }

    public NewOrderRequest setPrice(BigDecimal price) {
        this.price = price;
        return this;
    }

    public NewOrderRequest setNewClientOrderId(String newClientOrderId) {
        this.newClientOrderId = newClientOrderId;
        return this;
    }

    public NewOrderRequest setRecvWindow(Long recvWindow) {
        this.recvWindow = recvWindow;
        return this;
    }

    public NewOrderRequest setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewOrderRequest)) {
            return false;
        }
        NewOrderRequest other = (NewOrderRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$recvWindow = this.getRecvWindow();
        Long other$recvWindow = other.getRecvWindow();
        if (this$recvWindow == null ? other$recvWindow != null : !((Object)this$recvWindow).equals(other$recvWindow)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        OrderSide this$side = this.getSide();
        OrderSide other$side = other.getSide();
        if (this$side == null ? other$side != null : !((Object)((Object)this$side)).equals((Object)other$side)) {
            return false;
        }
        OrderType this$type = this.getType();
        OrderType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        BigDecimal this$quantity = this.getQuantity();
        BigDecimal other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        String this$quoteOrderQty = this.getQuoteOrderQty();
        String other$quoteOrderQty = other.getQuoteOrderQty();
        if (this$quoteOrderQty == null ? other$quoteOrderQty != null : !this$quoteOrderQty.equals(other$quoteOrderQty)) {
            return false;
        }
        BigDecimal this$price = this.getPrice();
        BigDecimal other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        String this$newClientOrderId = this.getNewClientOrderId();
        String other$newClientOrderId = other.getNewClientOrderId();
        return !(this$newClientOrderId == null ? other$newClientOrderId != null : !this$newClientOrderId.equals(other$newClientOrderId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NewOrderRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $recvWindow = this.getRecvWindow();
        result = result * 59 + ($recvWindow == null ? 43 : ((Object)$recvWindow).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        OrderSide $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : ((Object)((Object)$side)).hashCode());
        OrderType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        BigDecimal $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        String $quoteOrderQty = this.getQuoteOrderQty();
        result = result * 59 + ($quoteOrderQty == null ? 43 : $quoteOrderQty.hashCode());
        BigDecimal $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        String $newClientOrderId = this.getNewClientOrderId();
        result = result * 59 + ($newClientOrderId == null ? 43 : $newClientOrderId.hashCode());
        return result;
    }

    public String toString() {
        return "NewOrderRequest(symbol=" + this.getSymbol() + ", side=" + this.getSide() + ", type=" + this.getType() + ", quantity=" + this.getQuantity() + ", quoteOrderQty=" + this.getQuoteOrderQty() + ", price=" + this.getPrice() + ", newClientOrderId=" + this.getNewClientOrderId() + ", recvWindow=" + this.getRecvWindow() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

