/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.mexc.spot.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.security.HmacUtils;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.Signed;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OrderQueryRequest
implements Signed {
    private String symbol;
    private String origClientOrderId;
    private String orderId;
    private Long recvWindow;
    private Long timestamp;
    private String signature;
    private Long startTime;
    private Long endTime;

    @Override
    public String queryString(Credentials credentials) {
        StringJoiner joiner = new StringJoiner("&");
        if (this.symbol != null) {
            joiner.add("symbol=" + URLEncoder.encode(this.symbol, StandardCharsets.UTF_8));
        }
        if (this.origClientOrderId != null) {
            joiner.add("origClientOrderId=" + URLEncoder.encode(this.origClientOrderId, StandardCharsets.UTF_8));
        }
        if (this.orderId != null) {
            joiner.add("orderId=" + this.orderId);
        }
        if (this.recvWindow != null) {
            joiner.add("recvWindow=" + this.recvWindow);
        }
        if (this.timestamp != null) {
            joiner.add("timestamp=" + this.timestamp);
        }
        if (this.startTime != null) {
            joiner.add("startTime=" + this.startTime);
        }
        if (this.endTime != null) {
            joiner.add("endTime=" + this.endTime);
        }
        String content = joiner.toString();
        String signature = HmacUtils.sign(credentials, content);
        return content + "&signature=" + signature;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getOrigClientOrderId() {
        return this.origClientOrderId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public Long getRecvWindow() {
        return this.recvWindow;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getSignature() {
        return this.signature;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public OrderQueryRequest setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public OrderQueryRequest setOrigClientOrderId(String origClientOrderId) {
        this.origClientOrderId = origClientOrderId;
        return this;
    }

    public OrderQueryRequest setOrderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public OrderQueryRequest setRecvWindow(Long recvWindow) {
        this.recvWindow = recvWindow;
        return this;
    }

    public OrderQueryRequest setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public OrderQueryRequest setSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public OrderQueryRequest setStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    public OrderQueryRequest setEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderQueryRequest)) {
            return false;
        }
        OrderQueryRequest other = (OrderQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$recvWindow = this.getRecvWindow();
        Long other$recvWindow = other.getRecvWindow();
        if (this$recvWindow == null ? other$recvWindow != null : !((Object)this$recvWindow).equals(other$recvWindow)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Long this$startTime = this.getStartTime();
        Long other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Long this$endTime = this.getEndTime();
        Long other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$origClientOrderId = this.getOrigClientOrderId();
        String other$origClientOrderId = other.getOrigClientOrderId();
        if (this$origClientOrderId == null ? other$origClientOrderId != null : !this$origClientOrderId.equals(other$origClientOrderId)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderQueryRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $recvWindow = this.getRecvWindow();
        result = result * 59 + ($recvWindow == null ? 43 : ((Object)$recvWindow).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Long $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Long $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $origClientOrderId = this.getOrigClientOrderId();
        result = result * 59 + ($origClientOrderId == null ? 43 : $origClientOrderId.hashCode());
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        return result;
    }

    public String toString() {
        return "OrderQueryRequest(symbol=" + this.getSymbol() + ", origClientOrderId=" + this.getOrigClientOrderId() + ", orderId=" + this.getOrderId() + ", recvWindow=" + this.getRecvWindow() + ", timestamp=" + this.getTimestamp() + ", signature=" + this.getSignature() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }
}

