/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.mexc.spot.v3.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.security.HmacUtils;
import estonlabs.cxtl.exchanges.mexc.spot.v3.domain.Signed;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WSListenKeyRequest
implements Signed {
    private String listenKey;
    private Long recvWindow;
    private Long timestamp;

    @Override
    public String queryString(Credentials credentials) {
        StringJoiner joiner = new StringJoiner("&");
        if (this.listenKey != null) {
            joiner.add("listenKey=" + URLEncoder.encode(this.listenKey, StandardCharsets.UTF_8));
        }
        if (this.recvWindow != null) {
            joiner.add("recvWindow=" + this.recvWindow);
        }
        if (this.timestamp != null) {
            joiner.add("timestamp=" + this.timestamp);
        }
        String content = joiner.toString();
        String signature = HmacUtils.sign(credentials, content);
        return content + "&signature=" + signature;
    }

    public String getListenKey() {
        return this.listenKey;
    }

    public Long getRecvWindow() {
        return this.recvWindow;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public WSListenKeyRequest setListenKey(String listenKey) {
        this.listenKey = listenKey;
        return this;
    }

    public WSListenKeyRequest setRecvWindow(Long recvWindow) {
        this.recvWindow = recvWindow;
        return this;
    }

    public WSListenKeyRequest setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WSListenKeyRequest)) {
            return false;
        }
        WSListenKeyRequest other = (WSListenKeyRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$recvWindow = this.getRecvWindow();
        Long other$recvWindow = other.getRecvWindow();
        if (this$recvWindow == null ? other$recvWindow != null : !((Object)this$recvWindow).equals(other$recvWindow)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$listenKey = this.getListenKey();
        String other$listenKey = other.getListenKey();
        return !(this$listenKey == null ? other$listenKey != null : !this$listenKey.equals(other$listenKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WSListenKeyRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $recvWindow = this.getRecvWindow();
        result = result * 59 + ($recvWindow == null ? 43 : ((Object)$recvWindow).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $listenKey = this.getListenKey();
        result = result * 59 + ($listenKey == null ? 43 : $listenKey.hashCode());
        return result;
    }

    public String toString() {
        return "WSListenKeyRequest(listenKey=" + this.getListenKey() + ", recvWindow=" + this.getRecvWindow() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

