/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.okx.api.v5.domain.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CandleRequest {
    @JsonProperty(value="instId")
    @NonNull
    private final String symbol;
    @JsonIgnore
    private String bar;
    private long after;
    private long before;
    private Integer limit;

    public CandleRequest(String symbol, long windowSize, long start, long end) {
        this.symbol = symbol;
        this.bar = this.convertMillisToBarSize(windowSize);
        this.after = end;
        this.before = start;
    }

    public CandleRequest(String symbol, long windowSize, long start, long end, int limit) {
        this.symbol = symbol;
        this.bar = this.convertMillisToBarSize(windowSize);
        this.after = end;
        this.before = start;
        this.limit = limit;
    }

    private String convertMillisToBarSize(long milliseconds) {
        long minutes = TimeUnit.MILLISECONDS.toMinutes(milliseconds);
        long hours = TimeUnit.MILLISECONDS.toHours(milliseconds);
        long days = TimeUnit.MILLISECONDS.toDays(milliseconds);
        long months = days / 30L;
        if (minutes < 60L) {
            return minutes + "m";
        }
        if (hours < 24L) {
            return hours + "H";
        }
        if (days < 30L) {
            return days + "D";
        }
        return months + "M";
    }

    @NonNull
    public String getSymbol() {
        return this.symbol;
    }

    public String getBar() {
        return this.bar;
    }

    public long getAfter() {
        return this.after;
    }

    public long getBefore() {
        return this.before;
    }

    public Integer getLimit() {
        return this.limit;
    }

    @JsonIgnore
    public void setBar(String bar) {
        this.bar = bar;
    }

    public void setAfter(long after) {
        this.after = after;
    }

    public void setBefore(long before) {
        this.before = before;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CandleRequest)) {
            return false;
        }
        CandleRequest other = (CandleRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAfter() != other.getAfter()) {
            return false;
        }
        if (this.getBefore() != other.getBefore()) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$bar = this.getBar();
        String other$bar = other.getBar();
        return !(this$bar == null ? other$bar != null : !this$bar.equals(other$bar));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CandleRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $after = this.getAfter();
        result = result * 59 + (int)($after >>> 32 ^ $after);
        long $before = this.getBefore();
        result = result * 59 + (int)($before >>> 32 ^ $before);
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $bar = this.getBar();
        result = result * 59 + ($bar == null ? 43 : $bar.hashCode());
        return result;
    }

    public String toString() {
        return "CandleRequest(symbol=" + this.getSymbol() + ", bar=" + this.getBar() + ", after=" + this.getAfter() + ", before=" + this.getBefore() + ", limit=" + this.getLimit() + ")";
    }
}

