/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.okx.api.v5.domain.stream;

import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.types.InstrumentType;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.types.OkxChannel;
import estonlabs.cxtl.exchanges.okx.api.v5.util.Util;

public class Argument {
    OkxChannel channel;
    String instId;
    String apiKey;
    String passphrase;
    Long timestamp;
    String sign;
    InstrumentType instType;
    String instFamily;
    String uid;

    public static Argument createLoginArgument(String apiKey, String passphrase, Long timestamp, String sign) {
        Argument arg = new Argument();
        arg.setApiKey(apiKey);
        arg.setPassphrase(passphrase);
        arg.setTimestamp(timestamp);
        arg.setSign(sign);
        return arg;
    }

    public static Argument createOrderBookArgument(String symbol) {
        Argument arg = new Argument();
        arg.setChannel(OkxChannel.books);
        arg.setInstId(symbol);
        return arg;
    }

    public static Argument createTickerArgument(String symbol) {
        Argument arg = new Argument();
        arg.setChannel(OkxChannel.tickers);
        arg.setInstId(symbol);
        return arg;
    }

    public static Argument createPrivateOrderArgument(AssetClass assetClass) {
        Argument arg = new Argument();
        arg.setChannel(OkxChannel.orders);
        arg.setInstType(Util.toInstrumentType(assetClass));
        return arg;
    }

    public static Argument createPrivateOrderArgument() {
        Argument arg = new Argument();
        arg.setChannel(OkxChannel.orders);
        arg.setInstType(InstrumentType.ANY);
        return arg;
    }

    public static Argument createPrivatePositionArgument(AssetClass assetClass) {
        Argument arg = new Argument();
        arg.setChannel(OkxChannel.positions);
        if (AssetClass.SPOT.equals((Object)assetClass)) {
            arg.setInstType(InstrumentType.ANY);
        } else {
            arg.setInstType(Util.toInstrumentType(assetClass));
        }
        return arg;
    }

    public static Argument createPrivatePositionArgument() {
        Argument arg = new Argument();
        arg.setChannel(OkxChannel.positions);
        arg.setInstType(InstrumentType.ANY);
        return arg;
    }

    public static Argument createPrivateBalanceArgument() {
        Argument arg = new Argument();
        arg.setChannel(OkxChannel.balance_and_position);
        return arg;
    }

    public OkxChannel getChannel() {
        return this.channel;
    }

    public String getInstId() {
        return this.instId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getSign() {
        return this.sign;
    }

    public InstrumentType getInstType() {
        return this.instType;
    }

    public String getInstFamily() {
        return this.instFamily;
    }

    public String getUid() {
        return this.uid;
    }

    public void setChannel(OkxChannel channel) {
        this.channel = channel;
    }

    public void setInstId(String instId) {
        this.instId = instId;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setInstType(InstrumentType instType) {
        this.instType = instType;
    }

    public void setInstFamily(String instFamily) {
        this.instFamily = instFamily;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Argument)) {
            return false;
        }
        Argument other = (Argument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        OkxChannel this$channel = this.getChannel();
        OkxChannel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)((Object)this$channel)).equals((Object)other$channel)) {
            return false;
        }
        String this$instId = this.getInstId();
        String other$instId = other.getInstId();
        if (this$instId == null ? other$instId != null : !this$instId.equals(other$instId)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$passphrase = this.getPassphrase();
        String other$passphrase = other.getPassphrase();
        if (this$passphrase == null ? other$passphrase != null : !this$passphrase.equals(other$passphrase)) {
            return false;
        }
        String this$sign = this.getSign();
        String other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
            return false;
        }
        InstrumentType this$instType = this.getInstType();
        InstrumentType other$instType = other.getInstType();
        if (this$instType == null ? other$instType != null : !((Object)((Object)this$instType)).equals((Object)other$instType)) {
            return false;
        }
        String this$instFamily = this.getInstFamily();
        String other$instFamily = other.getInstFamily();
        if (this$instFamily == null ? other$instFamily != null : !this$instFamily.equals(other$instFamily)) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        return !(this$uid == null ? other$uid != null : !this$uid.equals(other$uid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Argument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        OkxChannel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)((Object)$channel)).hashCode());
        String $instId = this.getInstId();
        result = result * 59 + ($instId == null ? 43 : $instId.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $passphrase = this.getPassphrase();
        result = result * 59 + ($passphrase == null ? 43 : $passphrase.hashCode());
        String $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
        InstrumentType $instType = this.getInstType();
        result = result * 59 + ($instType == null ? 43 : ((Object)((Object)$instType)).hashCode());
        String $instFamily = this.getInstFamily();
        result = result * 59 + ($instFamily == null ? 43 : $instFamily.hashCode());
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        return result;
    }

    public String toString() {
        return "Argument(channel=" + this.getChannel() + ", instId=" + this.getInstId() + ", apiKey=" + this.getApiKey() + ", passphrase=" + this.getPassphrase() + ", timestamp=" + this.getTimestamp() + ", sign=" + this.getSign() + ", instType=" + this.getInstType() + ", instFamily=" + this.getInstFamily() + ", uid=" + this.getUid() + ")";
    }

    public Argument(OkxChannel channel, String instId, String apiKey, String passphrase, Long timestamp, String sign, InstrumentType instType, String instFamily, String uid) {
        this.channel = channel;
        this.instId = instId;
        this.apiKey = apiKey;
        this.passphrase = passphrase;
        this.timestamp = timestamp;
        this.sign = sign;
        this.instType = instType;
        this.instFamily = instFamily;
        this.uid = uid;
    }

    public Argument() {
    }
}

