/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.okx.api.v5.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.common.stream.managed.MarketDataWithSymbol;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.stream.OkxInboundMessage;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OkxOrderBookMessage
extends OkxInboundMessage<OkxOrderBook>
implements MarketDataWithSymbol {
    public OkxOrderBookMessage() {
        this.messageType = InboundMessage.MessageType.DATA;
    }

    @Override
    public String getTopic() {
        return this.getArg().getChannel().name();
    }

    @Override
    public boolean isSnapshot() {
        return super.getAction().equals("snapshot");
    }

    @Override
    public Long getSeqNo() {
        return ((OkxOrderBook)this.getData().get(0)).getSeqId();
    }

    @Override
    public Long getTimestamp() {
        if (!super.getData().isEmpty()) {
            return Long.valueOf(((OkxOrderBook)super.getData().get(0)).getTs());
        }
        return null;
    }

    @Override
    public boolean hasData() {
        return !super.getData().isEmpty();
    }

    @Override
    public String getSymbol() {
        return this.getArg().instId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OkxOrderBookMessage)) {
            return false;
        }
        OkxOrderBookMessage other = (OkxOrderBookMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OkxOrderBookMessage;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "OkxOrderBookMessage(super=" + super.toString() + ")";
    }

    public static class OkxOrderBook {
        private List<List<String>> asks;
        private List<List<String>> bids;
        private String instId;
        private String ts;
        private long seqId;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String checksum;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private long prevSeqId;

        public List<List<String>> getAsks() {
            return this.asks;
        }

        public List<List<String>> getBids() {
            return this.bids;
        }

        public String getInstId() {
            return this.instId;
        }

        public String getTs() {
            return this.ts;
        }

        public long getSeqId() {
            return this.seqId;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public long getPrevSeqId() {
            return this.prevSeqId;
        }

        public void setAsks(List<List<String>> asks) {
            this.asks = asks;
        }

        public void setBids(List<List<String>> bids) {
            this.bids = bids;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public void setTs(String ts) {
            this.ts = ts;
        }

        public void setSeqId(long seqId) {
            this.seqId = seqId;
        }

        public void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public void setPrevSeqId(long prevSeqId) {
            this.prevSeqId = prevSeqId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OkxOrderBook)) {
                return false;
            }
            OkxOrderBook other = (OkxOrderBook)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSeqId() != other.getSeqId()) {
                return false;
            }
            if (this.getPrevSeqId() != other.getPrevSeqId()) {
                return false;
            }
            List<List<String>> this$asks = this.getAsks();
            List<List<String>> other$asks = other.getAsks();
            if (this$asks == null ? other$asks != null : !((Object)this$asks).equals(other$asks)) {
                return false;
            }
            List<List<String>> this$bids = this.getBids();
            List<List<String>> other$bids = other.getBids();
            if (this$bids == null ? other$bids != null : !((Object)this$bids).equals(other$bids)) {
                return false;
            }
            String this$instId = this.getInstId();
            String other$instId = other.getInstId();
            if (this$instId == null ? other$instId != null : !this$instId.equals(other$instId)) {
                return false;
            }
            String this$ts = this.getTs();
            String other$ts = other.getTs();
            if (this$ts == null ? other$ts != null : !this$ts.equals(other$ts)) {
                return false;
            }
            String this$checksum = this.getChecksum();
            String other$checksum = other.getChecksum();
            return !(this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OkxOrderBook;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $seqId = this.getSeqId();
            result = result * 59 + (int)($seqId >>> 32 ^ $seqId);
            long $prevSeqId = this.getPrevSeqId();
            result = result * 59 + (int)($prevSeqId >>> 32 ^ $prevSeqId);
            List<List<String>> $asks = this.getAsks();
            result = result * 59 + ($asks == null ? 43 : ((Object)$asks).hashCode());
            List<List<String>> $bids = this.getBids();
            result = result * 59 + ($bids == null ? 43 : ((Object)$bids).hashCode());
            String $instId = this.getInstId();
            result = result * 59 + ($instId == null ? 43 : $instId.hashCode());
            String $ts = this.getTs();
            result = result * 59 + ($ts == null ? 43 : $ts.hashCode());
            String $checksum = this.getChecksum();
            result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
            return result;
        }

        public String toString() {
            return "OkxOrderBookMessage.OkxOrderBook(asks=" + this.getAsks() + ", bids=" + this.getBids() + ", instId=" + this.getInstId() + ", ts=" + this.getTs() + ", seqId=" + this.getSeqId() + ", checksum=" + this.getChecksum() + ", prevSeqId=" + this.getPrevSeqId() + ")";
        }
    }
}

